package com.at.isv.ui.slideshow

import android.app.Application
import android.app.ProgressDialog
import android.util.Log
import android.widget.Toast
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.at.isv.*
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import okhttp3.MediaType
import okhttp3.MultipartBody
import okhttp3.RequestBody
import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.IOException
import java.lang.reflect.Type
import javax.inject.Inject


@HiltViewModel
class SlideshowViewModel @Inject constructor(application: Application) : ViewModel() {


    private val _customerList = MutableLiveData<ArrayList<DataCustomer>>()
    val customerList: LiveData<ArrayList<DataCustomer>> = _customerList

    private val _vehicleList = MutableLiveData<ArrayList<DataVehicle>>()
    val vehicleList: LiveData<ArrayList<DataVehicle>> = _vehicleList

    private val _itemList = MutableLiveData<ArrayList<DataItem>>()
    val itemList: LiveData<ArrayList<DataItem>> = _itemList

    private val _ChalanItemList = MutableLiveData<ArrayList<ItemData>>()
    val ChalanItemList: LiveData<ArrayList<ItemData>> = _ChalanItemList


    var custlists = ArrayList<DataCustomer>()
    var vehilists = ArrayList<DataVehicle>()
    var itemlists = ArrayList<DataItem>()
    var Chaitemlists = ArrayList<ItemData>()

    var username:String = ""
    var password:String = ""
    var chalanmid:String = ""
    var security_token:String = ""

    private var _isLoading = MutableLiveData<Boolean>()
    val isLoading: LiveData<Boolean> = _isLoading

    private var _errormsg = MutableLiveData<String>()
    val errormsg: LiveData<String> = _errormsg

    private var _chalanMid = MutableLiveData<String>()
    val chalanMid: LiveData<String> = _chalanMid

    private var _lastBaseWeight = MutableLiveData<String>()
    val lastBaseWeight: LiveData<String> = _lastBaseWeight

    private var _itemAdd = MutableLiveData<Boolean>()
    val itemAdd: LiveData<Boolean> = _itemAdd

    private var _chalanSave = MutableLiveData<Boolean>()
    val chalanSave: LiveData<Boolean> = _chalanSave

    private var _chalanCancel = MutableLiveData<String>()
    val chalanCancel: LiveData<String> = _chalanCancel

    private var _chalanAdd = MutableLiveData<Boolean>()
    val chalanAdd: LiveData<Boolean> = _chalanAdd


    private var _ladenWeightAdd = MutableLiveData<Boolean>()
    val ladenWeightAdd: LiveData<Boolean> = _ladenWeightAdd

    private var _itemRemove = MutableLiveData<Boolean>()
    val itemRemove: LiveData<Boolean> = _itemRemove

    private val _DetailList = MutableLiveData<ArrayList<DataListResume>>()
    val DetailList: LiveData<ArrayList<DataListResume>> = _DetailList

    private val _ChalanAddList = MutableLiveData<ArrayList<DataChalanAdd>>()
    val ChalanAddList: LiveData<ArrayList<DataChalanAdd>> = _ChalanAddList

    var ChaAddlists = ArrayList<DataChalanAdd>()

    private val _ChalanImgList = MutableLiveData<ArrayList<DataItemImage>>()
    val ChalanImgList: LiveData<ArrayList<DataItemImage>> = _ChalanImgList

    var ChaImglists = ArrayList<DataItemImage>()


    var delists = ArrayList<DataListResume>()

    init {
        _isLoading.value = true

        custlists.clear()
        username = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("username","").toString()
        password = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("password","").toString()
        chalanmid = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("chalanmid","0").toString()
        security_token = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("security_token","0").toString()
        _chalanMid.value = chalanmid

        if(chalanmid.equals("0"))
        {
            getCustomers()
            getVehicles()
        }
        else
        {
            getDetails()
        }
        getItems()
    }

     fun getCustomers()
    {

        _isLoading.value = true
        _errormsg.value = ""
        custlists.clear()
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.getCustomerList(
            username,password
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        //Log.e("cs",("cs","result =>"+js.getString("result"))
                        if(js.getString("result").equals("1"))
                        {
                            val jsonArray = js.getJSONArray("item")
                            //Log.e("cs",("cs","jsonArray =>"+jsonArray.toString())
                            val gson = Gson()
                            val type: Type = object : TypeToken<List<DataCustomer?>?>() {}.type
                            custlists = gson.fromJson(jsonArray.toString(), type)
                            //Log.e("cs",("cs","conatactlist =>"+custlists.size)
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                        _customerList.value = custlists
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    private fun getVehicles()
    {

        _isLoading.value = true
        _errormsg.value = ""
        vehilists.clear()
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.getVehicleList(
            username,password
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        //Log.e("cs",("cs","result =>"+js.getString("result"))
                        if(js.getString("result").equals("1"))
                        {
                            val jsonArray = js.getJSONArray("item")
                            //Log.e("cs",("cs","jsonArray =>"+jsonArray.toString())
                            val gson = Gson()
                            val type: Type = object : TypeToken<List<DataVehicle?>?>() {}.type
                            vehilists = gson.fromJson(jsonArray.toString(), type)
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                        _vehicleList.value = vehilists
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    private fun getItems()
    {


        _isLoading.value = true
        _errormsg.value = ""
        itemlists.clear()
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.getItemList(
            username,password
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        //Log.e("cs",("cs","result =>"+js.getString("result"))
                        if(js.getString("result").equals("1"))
                        {
                            val jsonArray = js.getJSONArray("item")
                            //Log.e("cs",("cs","jsonArray =>"+jsonArray.toString())
                            val gson = Gson()
                            val type: Type = object : TypeToken<List<DataItem?>?>() {}.type
                            itemlists = gson.fromJson(jsonArray.toString(), type)
                            //Log.e("cs",("cs","conatactlist =>"+custlists.size)
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                        _itemList.value = itemlists
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    private fun getDetails()
    {

        _isLoading.value = true
        _errormsg.value = ""
        delists.clear()
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.getchallandetailResume(
            username,password, chalanmid
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        //Log.e("cs",("cs","result =>"+js.getString("result"))
                        if(js.getString("result").equals("1"))
                        {
                            val jsonArray = js.getJSONArray("item")
                            val gson = Gson()
                            val type: Type = object : TypeToken<List<DataListResume?>?>() {}.type
                            delists = gson.fromJson(jsonArray.toString(), type)
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                        _DetailList.value = delists
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    fun addLadenWeight(tocompanymid:String,
                vehiclenumber:String,ladenweight:String,chalanmid11:String, dod:String, remarks:String)
    {
        _isLoading.value = true
        _ladenWeightAdd.value = false
        _errormsg.value = ""
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.addladenweight(
            username,password,tocompanymid,
            vehiclenumber,ladenweight,chalanmid11,dod,remarks
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        //Log.e("cs",("cs","result =>"+js.getString("result"))
                        if(js.getString("result").equals("1"))
                        {
                            _ladenWeightAdd.value = true
                            chalanmid = js.getString("challanmid")
                            _chalanMid.value = js.getString("challanmid")
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

     fun addItem(orderdrandomid:String,challanmid:String,itemmid:String,tocompanymid:String,
                 vehiclenumber:String,vehicletareweight:String,vehiclegrossweight:String,itemnetweight:String,
                 itemrate:String,totalitemprice:String,challantype:String,challanweighttype:String,itemdeduction:String)
    {
        _itemAdd.value = false
        _isLoading.value = true
        _errormsg.value = ""
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.addChalanItem(
            username,password,orderdrandomid,
            challanmid,itemmid,tocompanymid,
            vehiclenumber,vehicletareweight,
            vehiclegrossweight,itemnetweight,itemrate,
            totalitemprice,challantype,challanweighttype,
            itemdeduction
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        //Log.e("cs",("cs","result =>"+js.getString("result"))
                        if(js.getString("result").equals("1"))
                        {
                            _chalanMid.value = js.getString("challanmid")
                            _itemAdd.value = true
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    fun getChalanItems(challanmid:String)
    {
        Chaitemlists.clear()
        _isLoading.value = true
        _errormsg.value = ""
        _lastBaseWeight.value = ""
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.getChalanItems(
            username,password,challanmid
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        //Log.e("cs",("cs","result =>"+js.getString("result"))
                        if(js.getString("result").equals("1"))
                        {
                            val baseweight = js.getString("lastbaseweight")
                            _lastBaseWeight.postValue(baseweight)
                            val jsonArray = js.getJSONArray("item")
                            //Log.e("cs",("cs","jsonArray =>"+jsonArray.toString())
                            val gson = Gson()
                            val type: Type = object : TypeToken<List<ItemData?>?>() {}.type
                            Chaitemlists = gson.fromJson(jsonArray.toString(), type)
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                        _ChalanItemList.value = Chaitemlists
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    fun cancelChalan(challanmid:String)
    {

        _isLoading.value = true
        _errormsg.value = ""
        _chalanCancel.value = ""
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.cancelChalan(
            username,password,challanmid
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        if(js.getString("result").equals("1"))
                        {
                            _chalanCancel.value = "Cancelled"
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                       // _ChalanItemList.value = Chaitemlists
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

   /* fun addChalan(challanmid:String)
    {

        _isLoading.value = true
        _errormsg.value = ""
        _chalanAdd.value = false
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.addChalan(
            username,password,challanmid
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        if(js.getString("result").equals("1"))
                        {
                            _chalanAdd.value = true
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                        _ChalanItemList.value = Chaitemlists
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }*/

    fun addChalan(challanmid:String,remarks:String,dod:String)
    {

        _isLoading.value = true
        _errormsg.value = ""

        ChaAddlists.clear()
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.addChalan(
            username,password,challanmid,remarks,dod,security_token
        )

        Log.e("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        if(js.getString("result").equals("1"))
                        {
                            val jsonArray = js.getJSONArray("item")
                            //Log.e("cs",("cs","jsonArray =>"+jsonArray.toString())
                            val gson = Gson()
                            val type: Type = object : TypeToken<List<DataChalanAdd?>?>() {}.type
                            ChaAddlists = gson.fromJson(jsonArray.toString(), type)
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                        _ChalanAddList.postValue(ChaAddlists)
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    fun addChalanwithImgs(imglist:ArrayList<DataItemImage>, challanmid:String,dod:String)
    {

        val multipartfilelist: MutableList<MultipartBody.Part> = ArrayList()
        multipartfilelist.clear()
        val part: MultipartBody.Part? = null
        for (p in imglist) {
            val requestBody: RequestBody =
                RequestBody.create(MediaType.parse("*/*"), p.fileimg!!)
            val fileToUploadimg = MultipartBody.Part.createFormData(
                "image[]",
                p.fileimg!!.name,
                requestBody
            )
            multipartfilelist.add(fileToUploadimg)
        }
        //  RequestBody filename = RequestBody.create(MediaType.parse("text/plain"), fileimg.getName());
        val mobile: RequestBody =
            RequestBody.create(MediaType.parse("multipart/form-data"), username)
        val pwd = RequestBody.create(MediaType.parse("multipart/form-data"), password)
        val challanmid1: RequestBody = RequestBody.create(MediaType.parse("multipart/form-data"), challanmid)
        val dod1: RequestBody = RequestBody.create(MediaType.parse("multipart/form-data"), dod)

        _isLoading.value = true
        _errormsg.value = ""

        ChaAddlists.clear()
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.addChalanwithImgs(
            multipartfilelist,mobile,pwd,challanmid1,dod1
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        if(js.getString("result").equals("1"))
                        {
                            val jsonArray = js.getJSONArray("item")
                            //Log.e("cs",("cs","jsonArray =>"+jsonArray.toString())
                            val gson = Gson()
                            val type: Type = object : TypeToken<List<DataChalanAdd?>?>() {}.type
                            ChaAddlists = gson.fromJson(jsonArray.toString(), type)
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                        _ChalanAddList.postValue(ChaAddlists)
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    fun uploadPic(imglist:ArrayList<DataItemImage>, challanmid:String)
    {

        val multipartfilelist: MutableList<MultipartBody.Part> = ArrayList()
        multipartfilelist.clear()
        val part: MultipartBody.Part? = null
        for (p in imglist) {
            val requestBody: RequestBody =
                RequestBody.create(MediaType.parse("*/*"), p.fileimg)
            val fileToUploadimg = MultipartBody.Part.createFormData(
                "image[]",
                p.fileimg!!.name,
                requestBody
            )
            multipartfilelist.add(fileToUploadimg)
        }
        //  RequestBody filename = RequestBody.create(MediaType.parse("text/plain"), fileimg.getName());
        val mobile: RequestBody =
            RequestBody.create(MediaType.parse("multipart/form-data"), username)
        val pwd = RequestBody.create(MediaType.parse("multipart/form-data"), password)
        val challanmid1: RequestBody = RequestBody.create(MediaType.parse("multipart/form-data"), challanmid)

        _isLoading.value = true
        _errormsg.value = ""
        ChaImglists.clear()
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.uploadPic(
            multipartfilelist,mobile,pwd,challanmid1
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        if(js.getString("result").equals("1"))
                        {
                            val jsonArray = js.getJSONArray("item")
                            //Log.e("cs",("cs","jsonArray =>"+jsonArray.toString())
                            val gson = Gson()
                            val type: Type = object : TypeToken<List<DataItemImage?>?>() {}.type
                            ChaImglists = gson.fromJson(jsonArray.toString(), type)
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                        _ChalanImgList.postValue(ChaImglists)
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    fun removeItem(challanmid:String,challandmid:String)
    {

        _isLoading.value = true
        _errormsg.value = ""
        _itemRemove.value = false
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.removeItem(
            username,password,challandmid
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        if(js.getString("result").equals("1"))
                        {
                           /* val jsonArray = js.getJSONArray("item")
                            //Log.e("cs",("cs","jsonArray =>"+jsonArray.toString())
                            val gson = Gson()
                            val type: Type = object : TypeToken<List<DataChalanAdd?>?>() {}.type
                            ChaAddlists = gson.fromJson(jsonArray.toString(), type)*/
                            _itemRemove.value = true
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    fun getImags(challanmid:String)
    {

        _isLoading.value = true
        _errormsg.value = ""

        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.getImgs(
            username,password,challanmid
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        if(js.getString("result").equals("1"))
                        {
                             val jsonArray = js.getJSONArray("item")
                             //Log.e("cs",("cs","jsonArray =>"+jsonArray.toString())
                             val gson = Gson()
                             val type: Type = object : TypeToken<List<DataChalanAdd?>?>() {}.type
                             ChaAddlists = gson.fromJson(jsonArray.toString(), type)

                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    fun saveChalan(dod:String,remarks:String)
    {
        viewModelScope.launch(Dispatchers.IO) {
            runCatching {
                _isLoading.postValue(true)
                _errormsg.postValue("")
                _chalanSave.postValue(false)
                AppConfig.retrofit.create(ApiConfig::class.java).savechalan(username,password,chalanmid,dod,remarks)
            }.onSuccess{

                val response = it?.execute()
                Log.e("cs","urls =>"+it?.request()?.url())
                Log.e("cs","urls =>"+it?.request()?.url())
                if (response!!.isSuccessful) {
                    _isLoading.postValue(false)
                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        Log.e("cs","result =>"+js.getString("result"))
                        if(js.getString("result").equals("1"))
                        {
                            _chalanSave.postValue(true)
                        }
                        else
                        {
                            _errormsg.postValue(js.getString("msg"))
                        }
                    } catch (e: IOException) {
                        _isLoading.postValue(false)
                        _errormsg.postValue(e.message)
                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.postValue(false)
                        _errormsg.postValue(e.message)
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.postValue(false)
                    _errormsg.postValue("Please try after some time")

                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }.onFailure {
                _isLoading.postValue(false)
                _errormsg.postValue("Failure =>$it")

                //Log.e("cs",("cs", "Failure =>$it")
            }
        }
    }
}