package com.at.isv.ui.slideshow

import android.Manifest
import android.app.Activity
import android.app.AlertDialog
import android.app.ProgressDialog
import android.bluetooth.BluetoothAdapter
import android.bluetooth.BluetoothDevice
import android.content.*
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.net.Uri
import android.os.Bundle
import android.os.Environment
import android.os.IBinder
import android.provider.MediaStore
import android.text.Editable
import android.text.SpannableStringBuilder
import android.text.TextWatcher
import android.text.method.Touch.scrollTo
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.widget.AdapterView
import android.widget.AdapterView.OnItemClickListener
import android.widget.ArrayAdapter
import android.widget.Toast
import androidx.activity.result.ActivityResult
import androidx.activity.result.ActivityResultCallback
import androidx.activity.result.contract.ActivityResultContracts
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.FileProvider
import androidx.fragment.app.Fragment
import androidx.fragment.app.activityViewModels
import androidx.lifecycle.ViewModelProvider
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import androidx.navigation.fragment.NavHostFragment
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.at.isv.*
import com.at.isv.ConstantValues.PREFS_NAME
import com.at.isv.databinding.FragmentSlideshowBinding
import com.bumptech.glide.Glide
import com.dantsu.escposprinter.EscPosCharsetEncoding
import com.dantsu.escposprinter.EscPosPrinter
import com.dantsu.escposprinter.connection.bluetooth.BluetoothConnection
import com.dantsu.escposprinter.connection.bluetooth.BluetoothPrintersConnections
import com.google.android.flexbox.FlexDirection
import com.google.android.flexbox.FlexWrap
import com.google.android.flexbox.FlexboxLayoutManager
import com.karumi.dexter.Dexter
import com.karumi.dexter.MultiplePermissionsReport
import com.karumi.dexter.PermissionToken
import com.karumi.dexter.listener.PermissionRequest
import com.karumi.dexter.listener.multi.MultiplePermissionsListener
import com.mazenrashed.printooth.data.printable.Printable
import dagger.hilt.android.AndroidEntryPoint
import java.io.ByteArrayOutputStream
import java.io.File
import java.io.FileOutputStream
import java.io.IOException
import java.math.RoundingMode
import java.text.DecimalFormat
import java.text.ParseException
import java.text.SimpleDateFormat
import java.util.*
import kotlin.random.Random


@AndroidEntryPoint
class SlideshowFragment : Fragment() , ServiceConnection, SerialListener {

    private var _binding: FragmentSlideshowBinding? = null

    // This property is only valid between onCreateView and
    // onDestroyView.
    private val binding get() = _binding!!
    var connectedbluetoothdevice: BluetoothDevice? = null
    private val myviewmodel : MainViewModel by activityViewModels()

    private enum class Connected {
        False, Pending, True
    }

    private var deviceAddress: String? = null
    private var service: SerialService? = null
    private var connected = Connected.False
    private var initialStart = true

    var is_reading = false


    var truckTareWeight  = 0.00
    var truckFilledWeight  = 0.00
    var itemNetWeight  = 0.00

    var client_id = "0"
    var clientNameList:ArrayList<String> = ArrayList<String>()
    var clientIDList:ArrayList<String> = ArrayList<String>()

    var vehicle_Name = ""
    var VehicleNameList:ArrayList<String> = ArrayList<String>()
    var VehicleStatusList:ArrayList<String> = ArrayList<String>()

    var item_ID = "0"
    var ItemNameList:ArrayList<String> = ArrayList<String>()
    var ItemIDList:ArrayList<String> = ArrayList<String>()

    var CustomerDataList:ArrayList<DataCustomer> = ArrayList<DataCustomer>()
    var VehicleDataList:ArrayList<DataVehicle> = ArrayList<DataVehicle>()
    var ItemDataList:ArrayList<DataItem> = ArrayList<DataItem>()

    val chalantypeArray  = arrayOf<String>("Multiple Weight", "Single Weight")
    val chalanTransactiontypeArray  = arrayOf<String>("Select Transaction", "Sale" , "Purchase")

    var initialWeight = 0.0
    var grossWeight = 0.0
    var baseWeight = 0.0
    var netWeight = 0.0
    var itemRate = 0.0
    var itemSaleRate = 0.0
    var itemPurchaseRate = 0.0
    val df = DecimalFormat("#.##")
    var chalanWeightType = "Multiple Weight"
    var chalanTransType = "Select Transaction"
   // var newchalanTransType = "Select Transaction"
    var chalanmid = "0"
    var orderdrandomid = ""
    var username = ""
    var itemlist = ArrayList<ItemData>()

    var initialweight = false
    var itemweight = false

    var fileimg: File? = null
    var storageDir: File? = null
    var dirpath: String = ""
    var currentPhotoPath: String = ""
    var mCurrentPhotoPath : String = ""

    var viewClicked : View? = null

    var gst_rate : Float = 8.0F
    var totalPrice : Float = 0.0F
    var deduction : Float = 0.0F

    var chalanPicMin = 0
    var chalanPicMax = 1
    var chalanMaxItems = 1
    var chalanswitchJobItemsCount = false

    var settings: SharedPreferences? = null
    var editor: SharedPreferences.Editor? = null

    var getSetBannerImgList: ArrayList<DataItemImage> = ArrayList<DataItemImage>()
    var adapterForBannerImg: AdapterForItemImages? = null

    lateinit var slideshowViewModel:SlideshowViewModel
    var deleteItem = true
    var addClient = false
    var dod = false

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
         slideshowViewModel =
            ViewModelProvider(this).get(SlideshowViewModel::class.java)

        _binding = FragmentSlideshowBinding.inflate(inflater, container, false)
        val root: View = binding.root

        settings = requireActivity().getSharedPreferences(PREFS_NAME,0)
        editor = settings!!.edit()

        orderdrandomid =  settings!!.getString("orderdrandomid","0").toString()
        username =  settings!!.getString("username","0").toString()
        deviceAddress =  settings!!.getString("bdscale_mac","0").toString()
        gst_rate =  settings!!.getFloat("gst_rate", 8.0F)




        val editPrice = requireActivity().getSharedPreferences(AdapterForList.PREFS_NAME,0).getBoolean("editPrice",false)
        val editWeight = requireActivity().getSharedPreferences(AdapterForList.PREFS_NAME,0).getBoolean("editWeight",false)
        val chalanPic = requireActivity().getSharedPreferences(AdapterForList.PREFS_NAME,0).getBoolean("chalanPic",false)
         dod = requireActivity().getSharedPreferences(AdapterForList.PREFS_NAME,0).getBoolean("chalanDod",false)
        val showPrice = requireActivity().getSharedPreferences(AdapterForList.PREFS_NAME,0).getBoolean("showPrice",true)
        val chalanDeduction = requireActivity().getSharedPreferences(AdapterForList.PREFS_NAME,0).getBoolean("chalanDeduction",false)
        val chalanRemarks = requireActivity().getSharedPreferences(AdapterForList.PREFS_NAME,0).getBoolean("chalanRemarks",false)
        chalanPicMin = requireActivity().getSharedPreferences(AdapterForList.PREFS_NAME,0).getInt("chalanPicMin",0)
        chalanPicMax = requireActivity().getSharedPreferences(AdapterForList.PREFS_NAME,0).getInt("chalanPicMax",0)
        chalanMaxItems = requireActivity().getSharedPreferences(AdapterForList.PREFS_NAME,0).getInt("chalanMaxItems",0)
        deleteItem = requireActivity().getSharedPreferences(AdapterForList.PREFS_NAME,0).getBoolean("deleteItem",false)
        chalanswitchJobItemsCount = requireActivity().getSharedPreferences(AdapterForList.PREFS_NAME,0).getBoolean("chalanswitchJobItemsCount",false)

        if(editPrice) {
            binding.etEditItemPrice.visibility = View.VISIBLE

        }
        else {
            binding.etEditItemPrice.visibility = View.INVISIBLE

        }

        if(chalanDeduction) {
            deduction =  settings!!.getFloat("deduction", 0.0F)
            binding.tvdeduction.setText(deduction.toString())
            binding.llDeduction.visibility = View.VISIBLE
        }
        else {
            deduction =   0.0F
            binding.llDeduction.visibility = View.GONE
        }

        if(chalanRemarks)
            binding.etRemarks1.visibility = View.VISIBLE
        else
            binding.etRemarks1.visibility = View.GONE


        if(editWeight) {
            binding.etEditStartWeight.visibility = View.VISIBLE
            binding.etEditGrossWeight.visibility = View.VISIBLE
        }
        else {
            binding.etEditStartWeight.visibility = View.INVISIBLE
            binding.etEditGrossWeight.visibility = View.INVISIBLE
        }

        if(chalanPic) {
            binding.btnAddPic.visibility = View.VISIBLE
            binding.btnUploadPic.visibility = View.GONE
        }
        else {
            binding.btnAddPic.visibility = View.GONE
            binding.btnUploadPic.visibility = View.GONE
        }

        if(dod)
        {
            binding.etDOD1.visibility = View.VISIBLE
        }
        else
        {
            binding.etDOD1.visibility = View.GONE
        }

        if(showPrice)
        {
            binding.llPRice1.visibility = View.VISIBLE
            binding.llPrice2.visibility = View.VISIBLE
        }
        else
        {
            binding.llPRice1.visibility = View.GONE
            binding.llPrice2.visibility = View.GONE
        }

        itemlist.clear()
        binding.recyclerviewItems.setHasFixedSize(true)
        binding.recyclerviewItems.isNestedScrollingEnabled = false
        binding.recyclerviewItems.layoutManager = LinearLayoutManager(requireContext(),
            RecyclerView.VERTICAL,false)
        binding.recyclerviewItems.adapter = AdapterForItem(itemlist,requireContext(),requireActivity(),deleteItem,showPrice)

        binding.recyclerviewItemsImgs.setHasFixedSize(true)
        binding.recyclerviewItemsImgs.isNestedScrollingEnabled = false
        val flexboxLayoutManager = FlexboxLayoutManager(requireActivity())
        flexboxLayoutManager.apply {
            flexDirection = FlexDirection.ROW
            flexWrap = FlexWrap.WRAP
        }
        binding.recyclerviewItemsImgs.layoutManager = flexboxLayoutManager
       /* binding.recyclerviewItemsImgs.layoutManager = LinearLayoutManager(requireContext(),
            RecyclerView.HORIZONTAL,false)*/
        adapterForBannerImg = AdapterForItemImages(getSetBannerImgList,requireContext(),requireActivity())
        binding.recyclerviewItemsImgs.adapter = adapterForBannerImg

        slideshowViewModel.isLoading.observe(viewLifecycleOwner)
        {
            if(it) {
                requireActivity().window.setFlags(
                    WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE,
                    WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE)
                viewClicked?.isEnabled = false
                binding.pb.visibility = View.VISIBLE
            }
            else {
                requireActivity().window.clearFlags(WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE)
                viewClicked?.isEnabled = true
                binding.pb.visibility = View.GONE
            }
        }
        slideshowViewModel.errormsg.observe(viewLifecycleOwner)
        {
            if(it.isNotEmpty())
                Toast.makeText(requireContext(),it,Toast.LENGTH_SHORT).show()
        }

        binding.tvdeduction.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {

            }

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                val inputded = s.toString().trim()
                if(inputded.isNotEmpty())
                {
                    //Log.e("cs",("cs","in textwatcher")
                    try {
                            val nettstr = binding.tvnetweight.text.toString().trim()
                            if(nettstr.isNotEmpty())
                            {
                                var deddouble = s.toString().toDouble()
                                var newtweightdouble =nettstr.toString().toDouble()
                                val df = DecimalFormat("#.##")
                                df.roundingMode = RoundingMode.CEILING
                                deddouble = df.format(deddouble).toDouble()
                                newtweightdouble = df.format(newtweightdouble).toDouble()
                                if(deddouble < newtweightdouble)
                                {
                                    newtweightdouble = newtweightdouble + deduction - deddouble
                                    deduction = deddouble.toFloat()
                                    netWeight = newtweightdouble
                                    binding.tvnetweight.setText(netWeight.toString())
                                }
                                else{
                                    if(newtweightdouble != 0.0)
                                        binding.tvdeduction.error = "Deduction can not be lower than net weight"
                                    //Toast.makeText(context,"Deduction can not be lower than net weight",Toast.LENGTH_SHORT).show()
                                }
                            }
                        } catch (e: NumberFormatException)
                        {
                            binding.tvdeduction.error = "Invalid Deduction value"
                        }
                    }
            }

            override fun afterTextChanged(s: Editable?) {

            }

        })

        //TODO :: no of items + price with 8% gst
        // update login api with scale bt name & Address , same with BT Print , GST
        // check enable/disable for visibility of views e.g camera ,price , edit
        // QRCode with encrypted username and password in , get in app and check in logic
        // add device id in user master and item price in chalan details

        slideshowViewModel.customerList.observe(viewLifecycleOwner) {
            CustomerDataList.clear()
            clientNameList.clear()
            clientIDList.clear()
            CustomerDataList.addAll(it)

            //Log.e("cs",("cs","Customerdatalist=>"+CustomerDataList.size)

            for(cust in CustomerDataList)
            {
                clientNameList.add(cust.customerName)
                clientIDList.add(cust.customerID)
            }
            if(addClient)
            {
                binding.etClientName.setText(clientNameList.get(0))
                client_id = clientIDList.get(0)
                addClient = false
            }

        }

        slideshowViewModel.vehicleList.observe(viewLifecycleOwner) {
            VehicleDataList.clear()
            VehicleNameList.clear()
            VehicleStatusList.clear()
            VehicleDataList.addAll(it)

            //Log.e("cs",("cs","VehicleDataList=>"+VehicleDataList.size)

            for(vehi in VehicleDataList)
            {
                VehicleNameList.add(vehi.vehicleno)
                VehicleStatusList.add(vehi.vehicleStatus)
            }

        }

        slideshowViewModel.itemList.observe(viewLifecycleOwner) {
            ItemDataList.clear()
            ItemNameList.clear()
            ItemIDList.clear()
            ItemDataList.addAll(it)

            //Log.e("cs",("cs","ItemDataList=>"+ItemDataList.size)

          if(it.size > 0)
          {
              for(item in ItemDataList)
              {
                  ItemNameList.add(item.itemname)
                  ItemIDList.add(item.itemmid)
              }

              binding.etItemName.setText(ItemNameList.get(0))
              item_ID = ItemIDList.get(0)

              if(chalanmid.equals("0")) {
                  Log.e("cs","1=> true")
                  binding.tvFirstWeightStart.isEnabled = true
                  binding.btnStartReading.isEnabled = false
                  binding.etEditGrossWeight.isEnabled = false
              }
              else {
                  binding.btnStartReading.isEnabled = binding.recyclerviewItems.adapter!!.itemCount < chalanMaxItems
                  binding.etEditGrossWeight.isEnabled = binding.recyclerviewItems.adapter!!.itemCount < chalanMaxItems
                  binding.tvFirstWeightStart.isEnabled = false

              }


              itemPurchaseRate= ItemDataList.get(0).purchaserate.toDouble()
              itemSaleRate= ItemDataList.get(0).salesrate.toDouble()
          }

        }

        binding.etClientName.setSafeOnClickListener {
            val customDialogbox = CustomDialogbox(context, clientNameList, "Select Company")
            customDialogbox.create()
            customDialogbox.listView!!.onItemClickListener =
                AdapterView.OnItemClickListener { parent, view, position, id -> // int poos = arrWorkTypeNameArray.indexOf(parent.getSelectedItem());
                    binding.etClientName.setText(customDialogbox.adapter!!.getItem(position))
                    client_id = clientIDList.get(clientNameList.indexOf(customDialogbox.adapter!!.getItem(position)))
                    customDialogbox.dismiss()
                }
        }

        /*binding.etVehicleName.setSafeOnClickListener {
            val customDialogbox = CustomDialogbox(context, VehicleNameList, "Select Vehicle")
            customDialogbox.create()
            customDialogbox.listView!!.onItemClickListener =
                AdapterView.OnItemClickListener { parent, view, position, id -> // int poos = arrWorkTypeNameArray.indexOf(parent.getSelectedItem());
                    binding.etVehicleName.setText(customDialogbox.adapter!!.getItem(position))
                    vehicle_ID = VehicleIDList.get(VehicleNameList.indexOf(customDialogbox.adapter!!.getItem(position)))
                    customDialogbox.dismiss()
                }
        }*/

        val adapter1 = ArrayAdapter(requireContext(),
            android.R.layout.simple_spinner_dropdown_item, VehicleNameList)
        binding.etVehicleName.setAdapter(adapter1)
        binding.etVehicleName.threshold = 1


        binding.etVehicleName.onItemClickListener = OnItemClickListener { parent, view, position, id -> //... your stuff

            val item_name =parent.getItemAtPosition(position)

            val vehicle_status = VehicleStatusList.get(VehicleNameList.indexOf(item_name))

            if(vehicle_status.equals("inuse")) {
                binding.etVehicleName.error = "Vehicle is in another Job"
                binding.etVehicleName.setText("")
                binding.etVehicleName.requestFocus()
            }
            else
            {
                val dataitem = VehicleDataList.get(VehicleNameList.indexOf(item_name))
                binding.etClientName.setText(dataitem.customerName)
                client_id = dataitem.customerID
            }


        }

        val adaptertype = ArrayAdapter(requireContext(),
            android.R.layout.simple_spinner_dropdown_item, chalantypeArray)
       // adaptertype.setDropDownViewResource(R.layout.sampl);
        binding.spnChalanType.adapter = adaptertype

        val adapterTransType = ArrayAdapter(requireContext(),
            android.R.layout.simple_spinner_dropdown_item, chalanTransactiontypeArray)

        binding.spnTransType.adapter = adapterTransType


        binding.spnChalanType.onItemSelectedListener = object :
            AdapterView.OnItemSelectedListener {
            override fun onItemSelected(parent: AdapterView<*>,
                                        view: View?, position: Int, id: Long) {

                chalanWeightType = chalantypeArray.get(position)
                if(chalanWeightType.equals("Single Weight")) {
                    binding.tvInitialWeight.setText("0")
                    binding.llInitialWeight.visibility = View.GONE
                }
                else
                    binding.llInitialWeight.visibility = View.VISIBLE
            }

            override fun onNothingSelected(parent: AdapterView<*>) {
                // write code to perform some action
            }
        }

        binding.spnTransType.onItemSelectedListener = object :
            AdapterView.OnItemSelectedListener {
            override fun onItemSelected(parent: AdapterView<*>,
                                        view: View?, position: Int, id: Long) {

                chalanTransType = chalanTransactiontypeArray.get(position)
            }

            override fun onNothingSelected(parent: AdapterView<*>) {
                // write code to perform some action
            }
        }

        binding.etItemName.setSafeOnClickListener {

            if(chalanWeightType.equals("Single Weight") && chalanTransType.startsWith("Select"))
            {
                Toast.makeText(requireContext(),"Please Select Transaction Type(Sale/Purchase) first",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            if(chalanWeightType.equals("Multiple Weight") && (initialweight ||  binding.tvInitialWeight.text.toString().equals("0") ))
            {
                Toast.makeText(requireContext(),"Please Capture the laden Weight first",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            if(binding.recyclerviewItems.adapter!!.itemCount >= chalanMaxItems)
            {
                Toast.makeText(requireContext(),"Maximum item Allowed Quantity Reached, you can't add more items",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }

            val customDialogbox = CustomDialogbox(context, ItemNameList, "Select Item")
            customDialogbox.create()
            customDialogbox.listView!!.onItemClickListener =
                AdapterView.OnItemClickListener { parent, view, position, id -> // int poos = arrWorkTypeNameArray.indexOf(parent.getSelectedItem());
                    binding.etItemName.setText(customDialogbox.adapter!!.getItem(position))
                    item_ID = ItemIDList.get(ItemNameList.indexOf(customDialogbox.adapter!!.getItem(position)))
                    binding.btnStartReading.isEnabled = true
                    binding.etEditGrossWeight.isEnabled = true
                    binding.etEditItemPrice.isEnabled = true
                    binding.tvFirstWeightStart.isEnabled = false
                    binding.etEditStartWeight.isEnabled = false
                    binding.tvFirstWeightCapture.isEnabled = false
                    itemPurchaseRate= ItemDataList.get(ItemNameList.indexOf(customDialogbox.adapter!!.getItem(position))).purchaserate.toDouble()
                    itemSaleRate= ItemDataList.get(ItemNameList.indexOf(customDialogbox.adapter!!.getItem(position))).salesrate.toDouble()
                    customDialogbox.dismiss()
                }
              binding.tvGrossWeight.setText("0")
          //  val lastgrossweight = it.

            binding.tvnetweight.setText("0")
            binding.tvRate.setText("0")
            binding.tvFinalPrice.setText("0")
        }

        binding.etEditStartWeight.setSafeOnClickListener {
            binding.tvInitialWeight.isEnabled = true
            binding.tvFirstWeightCapture.isEnabled = true
            binding.tvInitialWeight.requestFocus()
        }

        binding.tvFirstWeightCapture.setSafeOnClickListener {

            val iweight = binding.tvInitialWeight.text.toString().trim()
            if(iweight.isEmpty() || iweight.equals("0"))
            {
                binding.tvInitialWeight.error = "Invalid Weight"
                binding.tvInitialWeight.requestFocus()
                return@setSafeOnClickListener
            }
            try {
                initialWeight = iweight.toDouble()
                val df = DecimalFormat("#.##")
                df.roundingMode = RoundingMode.CEILING
                initialWeight = df.format(initialWeight).toDouble()
            }
            catch (e: NumberFormatException)
            {
                binding.tvInitialWeight.error = "Invalid Weight"
                binding.tvInitialWeight.requestFocus()
                return@setSafeOnClickListener
            }
            val vehno = binding.etVehicleName.text.toString().trim()
            if(vehno.isEmpty())
            {
                binding.etVehicleName.error = "Vehicle Name can't be empty"
                binding.etVehicleName.requestFocus()
                return@setSafeOnClickListener
            }
            if(client_id.equals("0"))
            {
                Toast.makeText(requireContext(),"Please select Company",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            var dodqty = binding.etDOD.text.toString().trim()
            if(dodqty.isEmpty())
                dodqty = "0"
            var remarks = binding.etRemarks.text.toString().trim()
            slideshowViewModel.addLadenWeight(client_id,vehno,iweight,chalanmid,dodqty,remarks)
        }

        slideshowViewModel.ladenWeightAdd.observe(viewLifecycleOwner){
            if(it)
            {
                binding.tvInitialWeight.isEnabled = false
                initialweight = false
                binding.spnChalanType.isEnabled = false
                binding.tvtareweight.setText(initialWeight.toString())
                binding.tvInitialWeight.clearFocus()
                binding.tvFirstWeightCapture.isEnabled = false
                binding.btnStartReading.isEnabled = true
                binding.etEditGrossWeight.isEnabled = true
            }
        }



        binding.tvFirstWeightStart.setSafeOnClickListener {
            binding.tvInitialWeight.isEnabled = false
            binding.tvFirstWeightCapture.isEnabled = false
            if(binding.etVehicleName.hasFocus())
                binding.etVehicleName.clearFocus()
            initialweight = true
            is_reading = true

            if (initialStart && service != null) {
                initialStart = false
                //Log.e("cs",("cs","start button 2")
                requireActivity().runOnUiThread { connect() }
            }
            else if(service == null)
            {
                //Log.e("cs",("cs","start button 2.5")
                requireContext().startService(
                    Intent(
                        requireContext(),
                        SerialService::class.java
                    )
                )
            }
          //  binding.llscroll.post( { binding.llscroll.scrollTo(0, binding.llTransa.getY().toInt()) })
        }



        val textwatcheret = object : TextWatcher {
            override fun beforeTextChanged(
                s: CharSequence?,
                start: Int,
                count: Int,
                after: Int
            ) {

            }
            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {

            }

            override fun afterTextChanged(s: Editable?) {
                val inputnet = s.toString().trim()
                if(inputnet.isNotEmpty())
                {
                    //Log.e("cs",("cs","in textwatcher")
                    try
                    {
                        //Log.e("cs",("cs","in textwatcher 1")
                        val tareweightstr = binding.tvtareweight.text.toString().trim()
                        baseWeight = tareweightstr.toDouble()
                        grossWeight = s.toString().toDouble()
                        val df = DecimalFormat("#.##")
                        df.roundingMode = RoundingMode.CEILING
                        grossWeight =  df.format(grossWeight).toDouble()
                        if(grossWeight > baseWeight)
                        {
                            netWeight = grossWeight - baseWeight - deduction
                          //  chalanTransType = "Sale"
                            itemRate = itemSaleRate
                        }
                        else
                        {
                            netWeight = baseWeight - grossWeight - deduction
                          //  chalanTransType = "Purchase"
                            itemRate = itemPurchaseRate
                        }
                        binding.tvRate.setText(itemRate.toString())
                       // binding.spnTransType.setSelection(chalanTransactiontypeArray.indexOf(chalanTransType))
                        netWeight =  df.format(netWeight).toDouble()
                        binding.tvnetweight.setText(netWeight.toString())
                        binding.tvFinalPrice.setText((netWeight*itemRate).toString())
                    }
                    catch (e:NumberFormatException)
                    {
                        //Log.e("cs",("cs","in textwatcher 2")
                        //trolleyBinding!!.tvtweight.error = "Wrong Data"
                    }
                }
            }
        }

        val textwatcheret2 = object : TextWatcher {
            override fun beforeTextChanged(
                s: CharSequence?,
                start: Int,
                count: Int,
                after: Int
            ) {

            }
            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {

            }

            override fun afterTextChanged(s: Editable?) {
                val inputnet = s.toString().trim()
                if(inputnet.isNotEmpty())
                {
                    //Log.e("cs",("cs","in textwatcher")
                    try
                    {
                        //Log.e("cs",("cs","in textwatcher 1")
                        val netweightstr = binding.tvnetweight.text.toString().trim()
                        netWeight = netweightstr.toDouble()
                        itemRate = inputnet.toString().toDouble()
                        val df = DecimalFormat("#.##")
                        df.roundingMode = RoundingMode.CEILING
                        netWeight =  df.format(netWeight).toDouble()
                        var finalprice = netWeight*itemRate

                        finalprice =  df.format(finalprice).toDouble()

                        binding.tvFinalPrice.setText((finalprice).toString())
                    }
                    catch (e:NumberFormatException)
                    {
                        //Log.e("cs",("cs","in textwatcher 2")
                        binding.tvRate.error = "Invalid value"
                    }
                }
            }
        }

        binding.btnStartReading.setSafeOnClickListener {

            if(binding.recyclerviewItems.adapter!!.itemCount >= chalanMaxItems)
            {
                Toast.makeText(requireContext(),"Maximum item Allowed Quantity Reached, you can't add more items",Toast.LENGTH_SHORT).show()
                binding.btnStartReading.isEnabled = false
                binding.etEditGrossWeight.isEnabled = false
                return@setSafeOnClickListener
            }
            binding.tvGrossWeight.isEnabled = false
            binding.tvGrossWeight.removeTextChangedListener(textwatcheret)


            is_reading = true
            itemweight = true

            if (initialStart && service != null) {
                initialStart = false
                //Log.e("cs",("cs","start button 2")
                requireActivity().runOnUiThread { connect() }
            }
            else if(service == null)
            {
                //Log.e("cs",("cs","start button 2.5")
                requireContext().startService(
                    Intent(
                        requireContext(),
                        SerialService::class.java
                    )
                )
            }
        }

        binding.etEditGrossWeight.setSafeOnClickListener {
            if(item_ID.equals("0"))
            {
                Toast.makeText(requireContext(),"Please Select Item First",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            if(binding.recyclerviewItems.adapter!!.itemCount >= chalanMaxItems)
            {
                Toast.makeText(requireContext(),"Maximum item Allowed Quantity Reached, you can't edit item weight",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            binding.tvGrossWeight.addTextChangedListener(textwatcheret)
            binding.tvGrossWeight.isEnabled = true
            binding.btnSaveWeight.isEnabled = true
            binding.tvGrossWeight.requestFocus()
            is_reading = false
            if (connected != Connected.False) disconnect()
            requireActivity().stopService(Intent(activity, SerialService::class.java))
        }

        binding.etEditItemPrice.setSafeOnClickListener {

            binding.tvRate.addTextChangedListener(textwatcheret2)
            binding.tvRate.isEnabled = true
            binding.tvRate.requestFocus()

        }

        binding.btnSaveWeight.setSafeOnClickListener {
            val grossweightstr2 = binding.tvGrossWeight.text.toString().trim()
            val tempad = binding.recyclerviewItems.adapter
            if(grossweightstr2.isEmpty())
            {
                Toast.makeText(requireContext(),"Weight not Captured, Please capture again",Toast.LENGTH_LONG).show()
                return@setSafeOnClickListener
            }
            try {
                grossWeight = grossweightstr2.toDouble()
                val df = DecimalFormat("#.##")
                df.roundingMode = RoundingMode.CEILING
                grossWeight = df.format(grossWeight).toDouble()
            }
            catch (e:NumberFormatException)
            {
                //trolleyBinding!!.btnStartReading.isEnabled = true
                Toast.makeText(requireContext(),"Invalid Weight Captured , Please capture again",Toast.LENGTH_LONG).show()
                return@setSafeOnClickListener
            }
            if(grossWeight == 0.0)
            {
                Toast.makeText(requireContext(),"Gross Weight can not be 0, Please capture again",Toast.LENGTH_LONG).show()
                return@setSafeOnClickListener
            }
            if(netWeight == 0.0)
            {
                Toast.makeText(requireContext(),"Net Item Weight can not be 0, Please capture again",Toast.LENGTH_LONG).show()
                return@setSafeOnClickListener
            }
            if(tempad!!.itemCount > 0 && chalanTransType.equals("Sale") && grossWeight < baseWeight)
            {
                Toast.makeText(requireContext(),"Gross weight should be more than base weight in sale Transactions, please capture weight again",Toast.LENGTH_LONG).show()
                return@setSafeOnClickListener
            }

            if(tempad.itemCount > 0 && chalanTransType.equals("Purchase") && grossWeight > baseWeight)
            {
                Toast.makeText(requireContext(),"Gross weight should be less than base weight in Purchase Transactions, please capture weight again",Toast.LENGTH_LONG).show()
                return@setSafeOnClickListener
            }
            if(binding.recyclerviewItems.adapter!!.itemCount >= chalanMaxItems)
            {
                Toast.makeText(requireContext(),"Maximum item Allowed Quantity Reached, you can't capture any item weight",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            if(tempad.itemCount == 0)
            {
                if(grossWeight > baseWeight)
                    chalanTransType = "Sale"
                else
                    chalanTransType = "Purchase"

                binding.spnTransType.setSelection(chalanTransactiontypeArray.indexOf(chalanTransType))
            }

            binding.spnTransType.isEnabled = false
            itemweight = false
            binding.btnAddItem.isEnabled = true
            is_reading = false
            binding.btnSaveWeight.isEnabled = false
            binding.tvGrossWeight.isEnabled = false
            if( binding.tvGrossWeight.hasFocus())
                binding.tvGrossWeight.clearFocus()

            Toast.makeText(requireContext(),"Weight Captured",Toast.LENGTH_LONG).show()
           /* if (connected != Connected.False) disconnect()
            requireActivity().stopService(Intent(activity, SerialService::class.java))*/

            if(client_id.equals("0"))
            {
                Toast.makeText(requireContext(),"Please Choose Client First",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            vehicle_Name = binding.etVehicleName.text.toString().trim()
            if(vehicle_Name.equals("") && chalanWeightType.equals("Multiple Weight"))
            {
                Toast.makeText(requireContext(),"Please Select or Enter Vehicle Number",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            if(item_ID.equals("0"))
            {
                Toast.makeText(requireContext(),"Please Select Item",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            if(orderdrandomid.equals("0"))
                orderdrandomid = "${Random.nextInt(50)} -${System.currentTimeMillis()}"
            requireActivity().getSharedPreferences(ConstantValues.PREFS_NAME, 0).edit().putString("orderdrandomid",orderdrandomid).apply()
            val tareWeightStr = binding.tvtareweight.text.toString().trim()
            val grossWeightStr = binding.tvGrossWeight.text.toString().trim()
            val netWeightStr = binding.tvnetweight.text.toString().trim()
            val itemtotalprice = binding.tvFinalPrice.text.toString().trim()
            val itemrate = binding.tvRate.text.toString().trim()
            val deduction = binding.tvdeduction.text.toString().trim()
            if(grossWeightStr.equals("0") || netWeightStr.equals("0")) {
                Toast.makeText(requireContext(), "Invalid,Please Check Weight",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            binding.btnAddItem.isEnabled = false
            slideshowViewModel.addItem(orderdrandomid,chalanmid,item_ID,client_id,vehicle_Name
                ,tareWeightStr,grossWeightStr,netWeightStr,itemrate,itemtotalprice,chalanTransType,chalanWeightType,deduction)

        }

        binding.btnAddItem.setSafeOnClickListener {
            if(client_id.equals("0"))
            {
                Toast.makeText(requireContext(),"Please Choose Client First",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            vehicle_Name = binding.etVehicleName.text.toString().trim()
            if(vehicle_Name.equals("") && chalanWeightType.equals("Multiple Weight"))
            {
                Toast.makeText(requireContext(),"Please Select or Enter Vehicle Number",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            if(item_ID.equals("0"))
            {
                Toast.makeText(requireContext(),"Please Select Item",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            if(orderdrandomid.equals("0"))
                orderdrandomid = "${Random.nextInt(50)} -${System.currentTimeMillis()}"
            requireActivity().getSharedPreferences(ConstantValues.PREFS_NAME, 0).edit().putString("orderdrandomid",orderdrandomid).apply()
            val tareWeightStr = binding.tvtareweight.text.toString().trim()
            val grossWeightStr = binding.tvGrossWeight.text.toString().trim()
            val netWeightStr = binding.tvnetweight.text.toString().trim()
            val itemtotalprice = binding.tvFinalPrice.text.toString().trim()
            val itemrate = binding.tvRate.text.toString().trim()
            val deduction = binding.tvdeduction.text.toString().trim()
            if(grossWeightStr.equals("0") || netWeightStr.equals("0")) {
                Toast.makeText(requireContext(), "Invalid,Please Check Weight",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            binding.btnAddItem.isEnabled = false
            slideshowViewModel.addItem(orderdrandomid,chalanmid,item_ID,client_id,vehicle_Name
                ,tareWeightStr,grossWeightStr,netWeightStr,itemrate,itemtotalprice,chalanTransType,chalanWeightType,deduction)
        }

        slideshowViewModel.itemAdd.observe(viewLifecycleOwner){
            if(it)
            {
                Toast.makeText(requireContext(),"Item Added",Toast.LENGTH_SHORT).show()
                item_ID = "0"
                slideshowViewModel.getChalanItems(chalanmid)
                binding.btnStartReading.isEnabled = false
                binding.btnSaveWeight.isEnabled = false
                binding.btnAddItem.isEnabled = false
                binding.etEditGrossWeight.isEnabled = false
                binding.etEditItemPrice.isEnabled = false
            }

        }

        slideshowViewModel.chalanMid.observe(viewLifecycleOwner){

            //Log.e("cs",("cs","chalanMid =>"+it)
            if(!it.equals("0"))
            {
                chalanmid = it
                binding.spnChalanType.isEnabled = false
                binding.spnTransType.isEnabled = false
                binding.etClientName.isEnabled = false
                binding.ibAddClient.isEnabled = false
                binding.etVehicleName.isEnabled = false
                binding.tvInitialWeight.isEnabled = false
                binding.etEditStartWeight.isEnabled = false
                binding.tvFirstWeightStart.isEnabled = false
                binding.tvFirstWeightCapture.isEnabled = false
               /* if(binding.tvInitialWeight.text.equals("0") || binding.tvInitialWeight.text.isEmpty())
                {
                    Log.e("cs","2=> true")
                    binding.tvFirstWeightStart.isEnabled = true
                    binding.etEditStartWeight.isEnabled = true
                }*/
                if(binding.recyclerviewItems.adapter!!.itemCount == 0 && (binding.tvInitialWeight.text.toString().equals("0") || binding.tvInitialWeight.text.toString().isEmpty()))
                {
                    Log.e("cs","3=> true")
                    binding.tvFirstWeightStart.isEnabled = true
                    binding.etEditStartWeight.isEnabled = true
                }

                binding.btnContinueJob.visibility = View.VISIBLE
            }
            else
            {
                Log.e("cs","4=> true")
                chalanmid = "0"
                binding.spnChalanType.isEnabled = true
                binding.spnTransType.isEnabled = true
                binding.etClientName.isEnabled = true
                binding.ibAddClient.isEnabled = true
                binding.etVehicleName.isEnabled = true
                binding.etEditStartWeight.isEnabled = true
                binding.tvFirstWeightStart.isEnabled = true
                binding.tvFirstWeightCapture.isEnabled = false
                binding.btnContinueJob.visibility = View.GONE
            }
        }

        binding.ibAddClient.setSafeOnClickListener {
            addClient = true
            NavHostFragment.findNavController(this@SlideshowFragment).navigate(com.at.isv.R.id.nav_add_client)
        }

        slideshowViewModel.DetailList.observe(viewLifecycleOwner){
            if(it.size > 0)
            {
                val dataitem = it.get(0)
                chalanWeightType = dataitem.challanweighttype
                //Log.e("cs",("cs","chalanWeightType =>"+chalanWeightType)
                binding.spnChalanType.setSelection(chalantypeArray.indexOf(dataitem.challanweighttype))
                binding.etItem.isEnabled = !chalanWeightType.startsWith("Sin")
                if(dataitem.itemlist != null && chalanswitchJobItemsCount && chalanMaxItems == dataitem.itemlist.size) {
                    binding.etItem.isEnabled = false
                    binding.btnAddItem.isEnabled = false
                    Toast.makeText(requireContext(),"No. of maximum Items added.",Toast.LENGTH_SHORT).show()
                }
                else
                {
                    binding.etItem.isEnabled = true
                }
                binding.spnTransType.setSelection(chalanTransactiontypeArray.indexOf(dataitem.challantype))
                binding.etClientName.setText(dataitem.partyname)
                client_id = dataitem.partymid

                binding.etVehicleName.setText(dataitem.vehicleno)
                binding.tvInitialWeight.setText(dataitem.firstbaseweight)
                binding.tvtareweight.setText(dataitem.lastbaseweight)
                binding.etDOD.setText(dataitem.dod)
                binding.etRemarks.setText(dataitem.remarks)
                //Log.e("cs",("cs","dataitem.itemlist =>"+dataitem.itemlist.toString())
                if(dataitem.itemlist != null)
                {

                    binding.recyclerviewItems.adapter = AdapterForItem(dataitem.itemlist,requireContext(), requireActivity(),deleteItem,showPrice)
                    binding.btnStartReading.isEnabled = binding.recyclerviewItems.adapter!!.itemCount < chalanMaxItems
                    binding.tvItemsNo.text = dataitem.itemlist.size.toString()
                     totalPrice = 0.0F
                    for(item in dataitem.itemlist)
                    {
                        try{
                            totalPrice += item.itemprice.toFloat()
                        }
                        catch(e:NumberFormatException)
                        {
                            totalPrice = 0.0F
                        }

                    }
                    binding.tvItemTotalPrice.text = totalPrice.toString()
                    totalPrice+= (totalPrice*gst_rate/100)
                    binding.tvFinalTotalPrice.text = totalPrice.toString()
                    binding.btnAddPic.isEnabled = true
                }
                getSetBannerImgList.clear()
                if(dataitem.imglist != null)
                {
                    getSetBannerImgList.addAll(dataitem.imglist)

                    binding.recyclerviewItemsImgs.adapter = AdapterForItemImages(dataitem.imglist,requireContext(), requireActivity())
                }


            }

        }
        val gst_rates = arrayOf(7.0F,8.0F,9.0F)
        val adapterGST = ArrayAdapter(requireContext(),
            android.R.layout.simple_spinner_item, gst_rates)
        binding.tvGST.adapter = adapterGST
       // binding.tvGST.text = "$gst_rate % "
        binding.tvGST.setSelection(1)
        binding.tvGST.onItemSelectedListener = object :
            AdapterView.OnItemSelectedListener {
            override fun onItemSelected(parent: AdapterView<*>,
                                        view: View?, position: Int, id: Long) {
                gst_rate = gst_rates[position]
                val finaltotalPrice = totalPrice + (totalPrice*gst_rate/100)
                binding.tvFinalTotalPrice.text =finaltotalPrice.toString()
            }

            override fun onNothingSelected(parent: AdapterView<*>) {
                // write code to perform some action
            }
        }

        slideshowViewModel.ChalanItemList.observe(viewLifecycleOwner){
            if(chalanswitchJobItemsCount && chalanMaxItems == it.size) {
                binding.etItem.isEnabled = false
                binding.btnAddItem.isEnabled = false
                Toast.makeText(requireContext(),"No. of maximum Items added.",Toast.LENGTH_SHORT).show()
            }
            else
            {
                binding.etItem.isEnabled = true

            }
            if(it.size == 0) {
                binding.tvtareweight.setText(binding.tvInitialWeight.text.toString())
            }
            else {
                binding.tvtareweight.setText(grossWeight.toString())
            }
          /*  binding.tvGrossWeight.setText("0")
          //  val lastgrossweight = it.

            binding.tvnetweight.setText("0")
            binding.tvRate.setText("0")
            binding.tvFinalPrice.setText("0")*/

            binding.recyclerviewItems.adapter = AdapterForItem(it,requireContext(), requireActivity(),deleteItem,showPrice)
            binding.btnStartReading.isEnabled = binding.recyclerviewItems.adapter!!.itemCount < chalanMaxItems
            binding.tvItemsNo.text = it.size.toString()

            binding.etItemName.setText("")

             totalPrice = 0.0F
            for(item in it)
            {
                try{
                    totalPrice += item.itemprice.toFloat()
                }
                catch(e:NumberFormatException)
                {
                    totalPrice = 0.0F
                }

            }
            binding.tvItemTotalPrice.text = totalPrice.toString()
            totalPrice+= (totalPrice*gst_rate/100)
            binding.tvFinalTotalPrice.text = totalPrice.toString()
            binding.btnAddPic.isEnabled = true
        }

        binding.btnCancelJob.setSafeOnClickListener {
            binding.btnCancelJob.isEnabled = false
            val builder = AlertDialog.Builder(requireContext())
            builder.setTitle("Cancel Job ?")
            builder.setMessage("Are you sure you want to cancel this Job ?")
            builder.setPositiveButton(android.R.string.yes) { dialog, which ->
                if(chalanmid.equals("0")) {
                    binding.btnCancelJob.isEnabled = true

                    Toast.makeText(requireContext(),"Job Cancelled",Toast.LENGTH_LONG).show()
                    NavHostFragment.findNavController(this@SlideshowFragment).popBackStack()
                    dialog.dismiss()
                }
                else
                    slideshowViewModel.cancelChalan(chalanmid)
            }
            builder.setNegativeButton(android.R.string.no) { dialog, which ->
                binding.btnCancelJob.isEnabled = true
                dialog.dismiss()
            }
            builder.show()
        }

        slideshowViewModel.chalanCancel.observe(viewLifecycleOwner){
            if(it.equals("Cancelled"))
            {
                Toast.makeText(requireContext(),"Job Cancelled",Toast.LENGTH_LONG).show()
                NavHostFragment.findNavController(this@SlideshowFragment).popBackStack()
            }
        }

        binding.btnContinueJob.setSafeOnClickListener {
            binding.btnCancelJob.isEnabled = false
            val builder = AlertDialog.Builder(requireContext())
            builder.setTitle("Save Job ?")
            builder.setMessage("Are you sure you want to Save this Job and go to Pending List ?")
            builder.setPositiveButton(android.R.string.yes) { dialog, which ->
                var dodqty = binding.etDOD.text.toString().trim()
                if(dodqty.isEmpty())
                    dodqty = "0"
                val remarks = binding.etRemarks.text.toString().trim()
               slideshowViewModel.saveChalan(dodqty,remarks)
            }
            builder.setNegativeButton(android.R.string.no) { dialog, which ->
                binding.btnCancelJob.isEnabled = true
                dialog.dismiss()
            }
            builder.show()
        }

        slideshowViewModel.chalanSave.observe(viewLifecycleOwner){
            if(it)
            {
                Toast.makeText(requireContext(),"Job Saved",Toast.LENGTH_LONG).show()
                NavHostFragment.findNavController(this@SlideshowFragment).popBackStack()
            }
        }

        binding.btnAddJob.setSafeOnClickListener {
            if(client_id.equals("0"))
            {
                Toast.makeText(requireContext(),"Please Choose Client First",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            vehicle_Name = binding.etVehicleName.text.toString().trim()
            if(vehicle_Name.equals("") && chalanWeightType.equals("Multiple Weight"))
            {
                Toast.makeText(requireContext(),"Please Select or Enter Vehicle Number",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            if(binding.recyclerviewItems.adapter!!.itemCount == 0)
            {
                Toast.makeText(requireContext(),"Please Add Item",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            if(chalanmid.equals("0"))
            {
              //  Toast.makeText(requireContext(),"Something went wrong , reloading the page",Toast.LENGTH_SHORT).show()
                Toast.makeText(requireContext(),"Something went wrong",Toast.LENGTH_SHORT).show()
                return@setSafeOnClickListener
            }
            var dodtxt = "0"
            if(dod)
            {
                dodtxt = binding.etDOD.text.toString().trim()
                if(dodtxt.isEmpty())
                    dodtxt = "0"
            }

            val remarks = binding.etRemarks.text.toString().trim()

            if(chalanPic ){
                /*if(chalanPicMin == 0 && adapterForBannerImg!!.itemCount == 0)
                {
                    slideshowViewModel.addChalan(chalanmid)
                }*/
                if( chalanPicMin <= adapterForBannerImg!!.itemCount && adapterForBannerImg!!.itemCount <= chalanPicMax) {
                    /* val imageList = ArrayList<DataItemImage>()
                     for(getSetBannerImg in getSetBannerImgList)
                     {
                         if(getSetBannerImg.cidid.equals("0"))
                             imageList.add(getSetBannerImg)
                     }
                     slideshowViewModel.addChalanwithImgs(imageList,chalanmid,dodtxt)*/
                    slideshowViewModel.addChalan(chalanmid,remarks,dodtxt)
                }
                else
                {
                    Toast.makeText(requireContext(),"Please Check Image Count, it must be between mandatory image count and maximum image count",Toast.LENGTH_SHORT).show()
                    return@setSafeOnClickListener
                }
            }
            else
                slideshowViewModel.addChalan(chalanmid,remarks,dodtxt)


        }

        /*slideshowViewModel.chalanAdd.observe(viewLifecycleOwner){
            if(it)
            {
                Toast.makeText(requireContext(),"Chalan Added Successfully",Toast.LENGTH_LONG).show()
                NavHostFragment.findNavController(this@SlideshowFragment).popBackStack()
            }
        }*/
        slideshowViewModel.ChalanAddList.observe(viewLifecycleOwner){

            if(it.size > 0 )
            {
                val additem = it.get(0)
                /*printjob(additem.challannofordisplay,additem.challandate,additem.timeIn,additem.ladenWeight,
                    additem.timeOut,additem.unladenWeight,additem.deduction,additem.netWeght)*/

                Toast.makeText(requireContext(),"Job Added",Toast.LENGTH_LONG).show()
                printjob2(additem.challannofordisplay,additem.challandate,additem.timeIn,additem.ladenWeight,
                    additem.timeOut,additem.unladenWeight,additem.deduction,additem.netWeght,additem.partyname)
            }

        }

        binding.btnAddPic.setSafeOnClickListener{
            if (adapterForBannerImg!!.itemCount < chalanPicMax) {
                //Log.e("cs",("cs","btnAddPic 2")
                Dexter.withContext(requireContext())
                    .withPermissions(
                        Manifest.permission.CAMERA,
                        Manifest.permission.ACCESS_COARSE_LOCATION
                    ).withListener(object : MultiplePermissionsListener {
                        override fun onPermissionsChecked(report: MultiplePermissionsReport) {
                            if (report.areAllPermissionsGranted()) {
                                //Log.e("cs",("cs", "all permission granted 11")
                                dispatchTakePictureIntent()
                                /*Intent cameraIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
                         startActivityForResult(cameraIntent, REQUEST_IMAGE_CAPTURE);*/
                            } else {
                                //Log.e("cs",("cs", "all permission nottttttt granted 11")
                            }
                        }

                        override fun onPermissionRationaleShouldBeShown(
                            permissions: List<PermissionRequest>,
                            token: PermissionToken
                        ) {
                            token.continuePermissionRequest()
                        }
                    }).check()
            } else {
                Toast.makeText(
                    requireContext(),
                    "Maximum of $chalanPicMax images allowed.",
                    Toast.LENGTH_SHORT
                ).show()
            }
        }



        slideshowViewModel.itemRemove.observe(viewLifecycleOwner){
            if(it)
            {
                Toast.makeText(requireContext(), "Item Removed.",
                    Toast.LENGTH_SHORT
                ).show()
                slideshowViewModel.getChalanItems(chalanmid)
            }
        }

        slideshowViewModel.lastBaseWeight.observe(viewLifecycleOwner){
            if(it.isNotEmpty())
            {
                binding.tvtareweight.setText(it)
            }
        }

        binding.btnUploadPic.setSafeOnClickListener {
            val imageList = ArrayList<DataItemImage>()
            for(getSetBannerImg in getSetBannerImgList)
            {
                if(getSetBannerImg.cidid.equals("0"))
                    imageList.add(getSetBannerImg)
            }
            if(imageList.size > 0)
            {
                slideshowViewModel.uploadPic(getSetBannerImgList,chalanmid)
            }
            else

                Toast.makeText(requireContext(), "No new Pictures to upload.",
                    Toast.LENGTH_SHORT
                ).show()

        }

        slideshowViewModel.ChalanImgList.observe(viewLifecycleOwner){
            getSetBannerImgList.clear()
            getSetBannerImgList.addAll(it)
            binding.recyclerviewItemsImgs.adapter = adapterForBannerImg
        }


        return root
    }
    override fun onDestroyView() {
        if (connected != Connected.False) disconnect()
        requireActivity().stopService(Intent(activity, SerialService::class.java))
        LocalBroadcastManager.getInstance(requireContext()).sendBroadcast(Intent("load_data"))
        super.onDestroyView()
        _binding = null
    }

 /*   fun printjob(ticketno:String,cdate:String,timeIn:String,ladenWeight:String,timeOut:String,unladenWeight:String
                 ,deduction:String,netWeght:String)
    {
        val progressDialog = ProgressDialog(requireContext())
        progressDialog.setMessage("Checking Printer...")
        progressDialog.show()
        val printables = ArrayList<Printable>()
        val companyheader = "\nCompany Header"
        val cname = settings!!.getString("company_name","ISV").toString()
        val truck =  binding.etVehicleName.text.toString().trim()

        val stringBuilder =
              "\nCompany Name 		: $cname\n" +
                "Truck        		: $truck\n" +
                "Ticket No    		: $ticketno\n" +
                "Date         		: $cdate\n" +
                "Time In            : $timeIn\n" + "时间（进)\n" +
                "Laden Wt.          : $ladenWeight kg\n" + "装载重量\n"+
                "Time Out           : $timeOut\n" + "时间（出）\n"+
                "Unladen Wt.        : $unladenWeight kg\n" + "卸载重量\n" +
                "Deduction    	    : $deduction kg\n" +
                "Net Wt.    		: $netWeght kg\n" + "净重\n" +
                "Issued By   		:______________\n" +
                "Received By		:_______________\n"

        val stringBuilder1 =
              "\nCompany Name 		: $cname\n" +
                "Truck        		: $truck\n" +
                "Ticket No    		: $ticketno\n" +
                "Date         		: $cdate\n" +
                "Time In            : $timeIn\n" + "时间（进)\n" +
                "Laden Wt.          : $ladenWeight kg\n" + "装载重量\n"+
                "Time Out           : $timeOut\n" + "时间（出）\n"+
                "Unladen Wt.        : $unladenWeight kg\n" + "卸载重量\n" +
                "Net Wt.    		: $netWeght kg\n" + "净重\n" +
                "Issued By   		:______________\n" +
                "Received By		:_______________\n"


        //Log.e("cs",("cs","stringBuilder=>"+stringBuilder.toString())
        if(Printooth.hasPairedPrinter())
        {
            val printableHeader = TextPrintable.Builder()
                .setText(companyheader.toString())
                .setEmphasizedMode(DefaultPrinter.EMPHASIZED_MODE_BOLD)
                .setAlignment(DefaultPrinter.ALIGNMENT_CENTER)
                .setFontSize(DefaultPrinter.FONT_SIZE_LARGE)
                .setLineSpacing(DefaultPrinter.LINE_SPACING_30)
                .setUnderlined(DefaultPrinter.UNDERLINED_MODE_OFF)
                .build()

            val printable = TextPrintable.Builder()
                .setText(stringBuilder.toString())
                .setEmphasizedMode(DefaultPrinter.EMPHASIZED_MODE_NORMAL)
                .setFontSize(DefaultPrinter.FONT_SIZE_NORMAL)
                .setLineSpacing(DefaultPrinter.LINE_SPACING_30)
                .setUnderlined(DefaultPrinter.UNDERLINED_MODE_OFF)
                .build()

            val printable1 = TextPrintable.Builder()
                .setText(stringBuilder1.toString())
                .setEmphasizedMode(DefaultPrinter.EMPHASIZED_MODE_NORMAL)
                .setFontSize(DefaultPrinter.FONT_SIZE_NORMAL)
                .setLineSpacing(DefaultPrinter.LINE_SPACING_30)
                .setUnderlined(DefaultPrinter.UNDERLINED_MODE_OFF)
                .build()

            printables.add(printableHeader)
            if(dod)
                printables.add(printable)
            else
                printables.add(printable1)
            Printooth.printer().print(printables)

            Printooth.printer().printingCallback = object : PrintingCallback {
                override fun connectingWithPrinter() {
                    progressDialog.setMessage("Connecting with Printer...")
                }
                override fun printingOrderSentSuccessfully() {
                    progressDialog.dismiss()
                    Toast.makeText(requireContext(),"Chalan Added and PRinted Successfully",Toast.LENGTH_LONG).show()
                    progressDialog.dismiss()
                    NavHostFragment.findNavController(this@SlideshowFragment).popBackStack()
                }  //printer was received your printing order successfully.

                override fun connectionFailed(error: String) {
                    progressDialog.dismiss()
                    Toast.makeText(requireContext(),"Print connection Failed $error",Toast.LENGTH_LONG).show()
                }

                override fun disconnected() {
                    progressDialog.dismiss()
                   // Toast.makeText(requireContext(),"Printer disconnected",Toast.LENGTH_LONG).show()
                }

                override fun onError(error: String) {
                    progressDialog.dismiss()
                    Toast.makeText(requireContext(),"Print connection Error $error",Toast.LENGTH_LONG).show()
                }

                override fun onMessage(message: String) {
                    progressDialog.dismiss()
                    Toast.makeText(requireContext(),"Print message $message",Toast.LENGTH_LONG).show()
                }
            }
            *//*progressDialog.setOnDismissListener {

            }*//*
        }
        else
        {
            progressDialog.dismiss()
            Toast.makeText(requireContext(),"Printer not selected",Toast.LENGTH_LONG).show()
            NavHostFragment.findNavController(this@SlideshowFragment).popBackStack()
            // slideshowViewModel.gettrolleylist(pref_id)
        }


    }*/

    fun printjob2(ticketno:String,cdate:String,timeIn:String,ladenWeight:String,timeOut:String,unladenWeight:String
                  ,deduction:String,netWeght:String,partyName:String)
    {
        val progressDialog = ProgressDialog(requireContext())
        progressDialog.setMessage("Checking Printer...")
        progressDialog.show()
        val printables = ArrayList<Printable>()
        val companyheader = "\nCompany Header\n"
        val cname = settings!!.getString("company_name","ISV").toString()
        val truck =  binding.etVehicleName.text.toString().trim()



        val bdprint_mac = settings!!.getString("bdprint_mac","")

        var listDevices   = BluetoothPrintersConnections().list
        var printDevice: BluetoothConnection? = null
        for(printdevice1 in listDevices!!)
        {
            if(printdevice1.device.address == bdprint_mac)
            {
                printDevice = printdevice1
            }
        }
        val dodamt = binding.etDOD.text.toString().trim()

        if(printDevice != null)
        {
            try{
                val printer =
                    EscPosPrinter(printDevice, 203, 40f, 32, EscPosCharsetEncoding("windows-936", 16))

                if(dod)
                {
                    printer
                        .printFormattedText(
                            "\n[C]<b>KENDO TRADING PTE LTD</b>\n" +
                                    "[C]<b>233 PANDAN LOOP,</b>\n" +
                                    "[C]<b>SINGAPORE 128421</b>\n\n" +
                                    "[L]Company Name [L]: $partyName\n" +
                                    "[L]Truck [L]: $truck\n" +
                                    "[L]Ticket No [L]: $ticketno\n" +
                                    "[L]Date [L]: $cdate\n\n" +
                                    "[L]Time In  [L]: $timeIn\n" +
                                    "[L]时间（进) \n" +
                                    "[L]Laden Wt. [L]: $ladenWeight kg\n" +
                                    "[L]装载重量\n\n" +
                                    "[L]Time Out [L]: $timeOut\n" +
                                    "[L]时间（出）\n" +
                                    "[L]Unladen Wt. [L]: $unladenWeight kg\n" +
                                    "[L]卸载重量\n\n" +
                                    "[L]Net Wt. [L]: $netWeght kg\n" +
                                    "[L]净重\n\n" +
                                    "[L]D.O.D. [L]: $dodamt \n\n\n" +
                                    "[L]Issued By [L]: _____________\n\n\n" +
                                    "[L]Received By [L]: _____________\n"
                        )
                }
                else
                {
                    printer
                        .printFormattedText(
                            "\n[C]<b>KENDO TRADING PTE LTD</b>\n" +
                                    "[C]<b>233 PANDAN LOOP,</b>\n" +
                                    "[C]<b>SINGAPORE 128421</b>\n\n" +
                                    "[L]Company Name [L]: $partyName\n" +
                                    "[L]Truck [L]: $truck\n" +
                                    "[L]Ticket No [L]: $ticketno\n" +
                                    "[L]Date [L]: $cdate\n\n" +
                                    "[L]Time In  [L]: $timeIn\n" +
                                    "[L]时间（进) \n" +
                                    "[L]Laden Wt. [L]: $ladenWeight kg\n" +
                                    "[L]装载重量\n\n" +
                                    "[L]Time Out [L]: $timeOut\n" +
                                    "[L]时间（出）\n" +
                                    "[L]Unladen Wt. [L]: $unladenWeight kg\n" +
                                    "[L]卸载重量\n\n" +
                                    "[L]Net Wt. [L]: $netWeght kg\n" +
                                    "[L]净重\n\n\n" +
                                    "[L]Issued By [L]: _____________\n\n\n" +
                                    "[L]Received By [L]: _____________\n"
                        )
                }
                printer.disconnectPrinter()
                progressDialog.dismiss()
                NavHostFragment.findNavController(this@SlideshowFragment).popBackStack()
            }
            catch (e : Exception)
            {
                progressDialog.dismiss()
                Toast.makeText(requireContext(),"Printer Error :: "+e.message,Toast.LENGTH_LONG).show()
                NavHostFragment.findNavController(this@SlideshowFragment).popBackStack()
            }

        }
        else
        {
            progressDialog.dismiss()
            Toast.makeText(requireContext(),"Printer Not Found",Toast.LENGTH_LONG).show()
            NavHostFragment.findNavController(this@SlideshowFragment).popBackStack()
        }



    }

    private fun connect() {
        try {
            val bluetoothAdapter = BluetoothAdapter.getDefaultAdapter()
            val device = bluetoothAdapter.getRemoteDevice(deviceAddress)
            status("connecting...")
            connected = Connected.Pending
            val socket = SerialSocket(requireActivity().applicationContext, device)
            service!!.connect(socket)
        } catch (e: Exception) {
            onSerialConnectError(e)
        }
    }

    private fun disconnect() {
        initialStart = true
        is_reading = false
        connected = Connected.False
        service!!.disconnect()
        val sta = binding.tvbconnect.text.toString().trim()
        if(sta.equals("connected")) {
            Glide.with(requireContext()).load(R.drawable.edittextborder_red)
                .into(binding.ivBTConnect)
            status("Disconnected")
        }
    }


    override fun onStart() {
        super.onStart()
        if (service != null) service!!.attach(this) else requireActivity().startService(
            Intent(
                activity,
                SerialService::class.java
            )
        ) // prevents service destroy on unbind from recreated activity caused by orientation change
    }

    override fun onStop() {
        if (service != null && !requireActivity().isChangingConfigurations) service!!.detach()
        super.onStop()
    }

    override fun onAttach(activity: Activity) {
        super.onAttach(activity)
        requireActivity().bindService(
            Intent(getActivity(), SerialService::class.java),
            this,
            Context.BIND_AUTO_CREATE
        )
    }

    override fun onDetach() {
        try {
            requireActivity().unbindService(this)
        } catch (ignored: Exception) {
        }
        super.onDetach()
    }

    override fun onResume() {
        super.onResume()

        LocalBroadcastManager.getInstance(requireContext()).registerReceiver(CustomerLoad,
            IntentFilter("CustomerLoad")
        )

        LocalBroadcastManager.getInstance(requireContext()).registerReceiver(removeItem,
            IntentFilter("removeItem")
        )

        if(initialStart && service != null) {
            //Log.e("cs","1 service on")
            initialStart = false
            activity?.runOnUiThread(this::connect)
        }
        else if(service == null)
        {
            //Log.e("cs",("cs","start button 2.5")
            //Log.e("cs","2 service on")
            requireContext().startService(
                Intent(
                    requireContext(),
                    SerialService::class.java
                )
            )
        }

    }

    override fun onPause() {
        super.onPause()
        LocalBroadcastManager.getInstance(requireContext()).unregisterReceiver(CustomerLoad)
        LocalBroadcastManager.getInstance(requireContext()).unregisterReceiver(removeItem)
    }

    val CustomerLoad = object : BroadcastReceiver(){
        override fun onReceive(context: Context?, intent: Intent?) {
            slideshowViewModel.getCustomers()
        }

    }

    val removeItem = object : BroadcastReceiver(){
        override fun onReceive(context: Context?, intent: Intent?) {
           val chalanDetailID = intent!!.getStringExtra("itmeid")
            slideshowViewModel.removeItem(chalanmid,chalanDetailID!!)
            //Toast.makeText(requireContext(),"In Developement",Toast.LENGTH_SHORT).show()
        }

    }

    override fun onServiceConnected(name: ComponentName, binder: IBinder) {
        service = (binder as SerialService.SerialBinder).service
        service!!.attach(this)
       // Log.e("cs","2.1 service on =>"+isResumed)
       // Log.e("cs","2.1 service on =>"+is_reading)
       // if (initialStart && isResumed && is_reading) {
        if (initialStart && isResumed ) {
            //Log.e("cs","2.5 service on")
            initialStart = false
            requireActivity().runOnUiThread { connect() }
        }
    }



    override fun onServiceDisconnected(name: ComponentName) {
        service = null
    }

    private fun receive(datas: ArrayDeque<ByteArray>?) {
        val spn = SpannableStringBuilder()
        var oldweight = ""

        for (data in datas!!) {

            val msg :String  = String(data)
            //Log.e("cs",("cs","string 23=>"+msg)
            if(msg.contains(",") && msg.contains("kg") && (msg.indexOfFirst { it == ',' } <  msg.indexOfFirst { it == 'g' }))
            {
                val b = msg.substring(msg.indexOfFirst { it == ',' }, msg.indexOfFirst { it == 'g'})
                val a = b.filter { it.isDigit() || it == '.'}
                if(a.trim().isNotEmpty()  && !a.equals(oldweight))
                {
                    //Log.e("cs",("cs","string 44=>"+a)
                    requireActivity().runOnUiThread {
                        var grossweightstr = "0"
                        var tareweightstr = "0"
                        var netweightstr = "0"
                        var livereadingWeight = a.toDouble()
                        livereadingWeight = df.format(livereadingWeight).toDouble()
                        binding.tvLiveReading.setText(livereadingWeight.toString())
                        if(chalanWeightType.equals("Single Weight")) {
                          //  singleRecive(a)
                            baseWeight = 0.0
                            grossWeight = a.toDouble()
                            grossWeight = df.format(grossWeight).toDouble()
                            netWeight = grossWeight - baseWeight - deduction
                            if(chalanTransType.equals("Sale"))
                                itemRate = itemSaleRate
                            else if(chalanTransType.equals("Purchase"))
                                itemRate = itemPurchaseRate
                            binding.tvRate.setText(itemRate.toString())

                            netWeight =  df.format(netWeight).toDouble()
                            binding.tvGrossWeight.setText(grossWeight.toString())
                            binding.tvnetweight.setText(netWeight.toString())
                            binding.tvFinalPrice.setText((netWeight*itemRate).toString())
                            binding.btnSaveWeight.isEnabled = true
                        }
                        else{
                          //  multipleRecive(a)
                          //  val firstweight = binding.tvInitialWeight.text.toString().equals("0") || binding.tvInitialWeight.text.toString().isEmpty()
                            if(initialweight)
                            {
                                initialWeight = a.toDouble()
                                initialWeight = df.format(initialWeight).toDouble()
                                binding.tvInitialWeight.setText( initialWeight.toString())
                                binding.tvtareweight.setText( initialWeight.toString())
                                baseWeight = initialWeight
                                binding.tvFirstWeightCapture.isEnabled = true
                            }
                            else if(itemweight)
                            {
                                 tareweightstr = binding.tvtareweight.text.toString().trim()
                                baseWeight = tareweightstr.toDouble()
                                baseWeight = df.format(baseWeight).toDouble()
                                grossWeight = a.toDouble()
                                grossWeight = df.format(grossWeight).toDouble()

                                if(grossWeight > baseWeight)
                                {
                                    netWeight = grossWeight - baseWeight - deduction
                                    itemRate = itemSaleRate
                                }
                                else
                                {
                                    netWeight = baseWeight - grossWeight - deduction
                                    itemRate = itemPurchaseRate
                                }
                                binding.tvRate.setText(itemRate.toString())
                                netWeight =  df.format(netWeight).toDouble()
                                binding.tvGrossWeight.setText(grossWeight.toString())
                                binding.tvnetweight.setText(netWeight.toString())
                                binding.tvFinalPrice.setText((netWeight*itemRate).toString())
                                binding.btnSaveWeight.isEnabled = true
                            }
                        }

                        oldweight = a
                    }
                }
            }
        }
        // binding.textGallery2.setText(spn)
    }


    private fun status(str: String) {

        binding.tvbconnect.text = str

    }

    /*
     * SerialListener
     */
    override fun onSerialConnect() {
        status("connected")
        connected = Connected.True
        Glide.with(requireContext()).load(R.drawable.edittextborder_green)
            .into(binding.ivBTConnect)
    }

    override fun onSerialConnectError(e: Exception?) {
        status("connection failed: " + e!!.message)
        disconnect()
    }

    override fun onSerialRead(data: ByteArray) {
        val datas = ArrayDeque<ByteArray>()
        datas.add(data)
        receive(datas)
    }

    override fun onSerialRead(datas: ArrayDeque<ByteArray>?) {
        receive(datas)
    }

    override fun onSerialIoError(e: Exception?) {
        status("connection lost: " + e!!.message)
        disconnect()
    }



    var someActivityResultLauncher = registerForActivityResult<Intent, ActivityResult>(
        ActivityResultContracts.StartActivityForResult(),
        object : ActivityResultCallback<ActivityResult?> {
            override fun onActivityResult(result: ActivityResult?){
                //Log.e("cs",("cs", "new activity result 111=>" + AppCompatActivity.RESULT_OK)
                //   Toast.makeText(ActGetSignOrPic.this, "111", Toast.LENGTH_SHORT).show();
                if (result!!.resultCode == AppCompatActivity.RESULT_OK) {
                    // Here, no request code
                    //Log.e("cs",("cs", "new activity result 222=>" + AppCompatActivity.RESULT_OK)
                    //  Toast.makeText(ActGetSignOrPic.this, "222", Toast.LENGTH_SHORT).show();
                    try {

                        //  Toast.makeText(ActGetSignOrPic.this, "333", Toast.LENGTH_SHORT).show();
                        val mImageBitmap = MediaStore.Images.Media.getBitmap(
                            requireActivity().contentResolver,
                            Uri.parse(mCurrentPhotoPath)
                        )
                        val out = ByteArrayOutputStream()
                        mImageBitmap.compress(Bitmap.CompressFormat.JPEG, 100, out)
                        //Log.e("cs",("cs", "original size=>" + out.toByteArray().size)

                        //  mImageBitmap.compress(Bitmap.CompressFormat.JPEG, 10, out);
                        try {
                            val bitmap = BitmapFactory.decodeFile(fileimg!!.path)
                            bitmap.compress(
                                Bitmap.CompressFormat.JPEG,
                                80,
                                FileOutputStream(fileimg)
                            )
                         /*   var file_size: Int = (fileimg!!.length() / 1024).toString().toInt()
                            if (file_size < 1000) {
                                tvsizeimg.setText("$file_size KB Orig")
                            } else {
                                file_size = file_size / 1024
                                tvsizeimg.setText("$file_size MB Orig")
                            }*/
                           // //Log.e("cs",("cs", "original size=>$file_size")
                            //  bitmap.compress (Bitmap.CompressFormat.JPEG, 20, new FileOutputStream (fileimg));
                            //  Bitmap imageBitmap = SiliCompressor.with(getApplicationContext()).getCompressBitmap(mCurrentPhotoPath, true);
                         //   //Log.e("cs",("cs", "original file path=>" + fileimg.getAbsolutePath())
                            /* String filePath = SiliCompressor.with(getApplicationContext()).compress(mCurrentPhotoPath,  storageDir, true);
                                //Log.e("cs",("cs","new file path=>"+filePath);*/
                            //Bitmap bitmap22 = BitmapFactory.decodeFile (filePath);

                        } catch (t: Throwable) {
                            //Log.e("cs",("ERROR", "Error compressing file.$t")
                            t.printStackTrace()
                        }
                        val getSetBannerImg = DataItemImage("0",fileimg!!.absolutePath,fileimg!!)

                        //  fileList.add(fileimg);
                        val getsetBaneerImgList1 = kotlin.collections.ArrayList<DataItemImage>()
                        getsetBaneerImgList1.add(getSetBannerImg)
                       // binding.recyclerviewItemsImgs.setAdapter(adapterForBannerImg)

                       // binding.btnUploadPic.isEnabled = true

                        slideshowViewModel.uploadPic(getsetBaneerImgList1,chalanmid)

                    } catch (e: IOException) {
                        e.printStackTrace()
                        //Log.e("cs",("cs", "new activity result exception=>" + e.message)
                        //  Toast.makeText(ActGetSignOrPic.this, "555"+e.getMessage(), Toast.LENGTH_SHORT).show();
                    }


                    // //Log.e("cs",("cs","new activity result=>"+result.getData());
                }
            }


        })


    @Throws(IOException::class)
    private fun createImageFile(type: String): File {
        // Create an image file name
        val timeStamp = SimpleDateFormat("yyyyMMdd_HHmmss").format(Date())
        val imageFileName = "JPEG_" + timeStamp + "_"
        storageDir = requireActivity().getExternalFilesDir(Environment.DIRECTORY_PICTURES)
        dirpath = storageDir!!.absolutePath
        val image = File.createTempFile(
            imageFileName,  /* prefix */
            ".jpg",  /* suffix */
            storageDir /* directory */
        )

        currentPhotoPath = image.absolutePath
        mCurrentPhotoPath = "file:" + image.absolutePath
        //Log.e("cs",("cs", "image created =>"+image.exists())
        return image
    }

    private fun dispatchTakePictureIntent() {
        val takePictureIntent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
        // Ensure that there's a camera activity to handle the intent
        //Log.e("cs",("cs", "new 111")
        if (takePictureIntent.resolveActivity(requireActivity().packageManager) != null) {
            // Create the File where the photo should go
            try {
                fileimg = createImageFile("image")
            } catch (ex: IOException) {
                // Error occurred while creating the File
                //Log.e("cs",("cs", "new 112=>" + ex.message)
            }

            //Log.e("cs",("cs", "new 111")
            // Continue only if the File was successfully created
            if (fileimg != null) {
                val photoURI = FileProvider.getUriForFile(
                    requireContext(),
                    "com.at.isv.fileprovider",
                    fileimg!!
                )
                takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT, photoURI)
                //Log.e("cs",("cs", "new 113")
                someActivityResultLauncher.launch(takePictureIntent)
            } else {
                //Log.e("cs",("cs", "new 1133445")
            }
        } else {
            //Log.e("cs",("cs", "new 1188")
        }
    }

    fun View.setSafeOnClickListener(onSafeClick: (View) -> Unit) {
        val safeClickListener = SafeClickListener {
            //viewClicked = it
            onSafeClick(it)
        }
        setOnClickListener(safeClickListener)
    }
}


