package com.at.isv.ui.home

import android.app.Application
import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.at.isv.ApiConfig
import com.at.isv.AppConfig
import com.at.isv.ConstantValues
import com.at.isv.DataCustomer
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import dagger.hilt.android.lifecycle.HiltViewModel
import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.IOException
import java.lang.reflect.Type
import javax.inject.Inject

@HiltViewModel
class HomeViewModel  @Inject constructor(application: Application): ViewModel() {

    private var _isLoading = MutableLiveData<Boolean>()
    val isLoading: LiveData<Boolean> = _isLoading

    private var _errormsg = MutableLiveData<String>()
    val errormsg: LiveData<String> = _errormsg

    init {
        _isLoading.value = true
    }


}