package com.at.isv.ui.home

import android.content.Intent
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import androidx.lifecycle.ViewModelProvider
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import androidx.viewpager.widget.ViewPager.SimpleOnPageChangeListener
import androidx.viewpager2.adapter.FragmentStateAdapter
import androidx.viewpager2.widget.ViewPager2.OnPageChangeCallback
import com.at.isv.CompletedChalanFragment
import com.at.isv.PendingChalanFragment
import com.at.isv.databinding.FragmentHomeBinding
import com.google.android.material.tabs.TabLayoutMediator
import dagger.hilt.android.AndroidEntryPoint


@AndroidEntryPoint
class HomeFragment : Fragment() {

    private var _binding: FragmentHomeBinding? = null

    // This property is only valid between onCreateView and
    // onDestroyView.
    private val binding get() = _binding!!

    lateinit var adapter:AdapterTabPager

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        val homeViewModel =
            ViewModelProvider(this).get(HomeViewModel::class.java)

        _binding = FragmentHomeBinding.inflate(inflater, container, false)
        val root: View = binding.root

       /* binding.cv1.setBackgroundResource(R.drawable.bg1);
        binding.cv2.setBackgroundResource(R.drawable.bg2);
        binding.cv3.setBackgroundResource(R.drawable.bg3);
        binding.cv4.setBackgroundResource(R.drawable.bg4);


        binding.cv1.setOnClickListener {
            NavHostFragment.findNavController(this@HomeFragment).navigate(R.id.nav_gallery)
        }

        binding.cv2.setOnClickListener {
            NavHostFragment.findNavController(this@HomeFragment).navigate(R.id.nav_sales)
        }

        binding.cv3.setOnClickListener {
            NavHostFragment.findNavController(this@HomeFragment).navigate(R.id.nav_slideshow)
        }

        binding.cv4.setOnClickListener {
            NavHostFragment.findNavController(this@HomeFragment).navigate(R.id.nav_purchase)
        }*/

         adapter = AdapterTabPager(activity)
        adapter.addFragment(PendingChalanFragment(), "Pending")
        adapter.addFragment(CompletedChalanFragment(), "Completed")

        binding.vp.adapter = adapter
        binding.vp.currentItem = 0
        TabLayoutMediator(binding.tb, binding.vp) { tab, position ->
            tab.text = adapter.getTabTitle(position)
        }.attach()

        binding.vp.registerOnPageChangeCallback(object : OnPageChangeCallback() {
            override fun onPageSelected(position: Int) {
                // Add your logic
                LocalBroadcastManager.getInstance(requireContext()).sendBroadcast(Intent("load_data"))
            }
        })


        return root
    }

    class AdapterTabPager(activity: FragmentActivity?) : FragmentStateAdapter(activity!!) {
        private val mFragmentList: MutableList<Fragment> = ArrayList()
        private val mFragmentTitleList: MutableList<String> = ArrayList()

        public fun getTabTitle(position : Int): String{
            return mFragmentTitleList[position]
        }

        fun addFragment(fragment: Fragment, title: String) {
            mFragmentList.add(fragment)
            mFragmentTitleList.add(title)
        }

        override fun getItemCount(): Int {
            return mFragmentList.size
        }

        override fun createFragment(position: Int): Fragment {
            return mFragmentList[position]
        }
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }
}