package com.at.isv.ui.gallery

import android.app.Application
import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.at.isv.*
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import dagger.hilt.android.lifecycle.HiltViewModel
import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.IOException
import java.lang.reflect.Type
import javax.inject.Inject

@HiltViewModel
class GalleryViewModel @Inject constructor(application: Application): ViewModel() {

    private val _DetailList = MutableLiveData<ArrayList<ListDataDetail>>()
    val DetailList: LiveData<ArrayList<ListDataDetail>> = _DetailList


    var delists = ArrayList<ListDataDetail>()


    var username:String = ""
    var password:String = ""
    var chalanmid:String = ""

    private var _isLoading = MutableLiveData<Boolean>()
    val isLoading: LiveData<Boolean> = _isLoading

    private var _chalanCancel = MutableLiveData<Boolean>()
    val chalanCancel: LiveData<Boolean> = _chalanCancel

    private var _errormsg = MutableLiveData<String>()
    val errormsg: LiveData<String> = _errormsg

    init {
        _isLoading.value = true

        delists.clear()
        username = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("username","").toString()
        password = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("password","").toString()
        chalanmid = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("chalanmid","0").toString()


        getDetails()
    }

    private fun getDetails()
    {

        _isLoading.value = true
        _errormsg.value = ""
        delists.clear()
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.getdetails(
            username,password, chalanmid
        )

       // Log.e("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        //Log.e("cs",("cs","result =>"+js.getString("result"))
                        if(js.getString("result").equals("1"))
                        {
                            val jsonArray = js.getJSONArray("item")
                            val gson = Gson()
                            val type: Type = object : TypeToken<List<ListDataDetail?>?>() {}.type
                            delists = gson.fromJson(jsonArray.toString(), type)
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                        _DetailList.value = delists
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    fun editChalan()
    {

        _isLoading.value = true
        _errormsg.value = ""
        _chalanCancel.value = false
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.editChalan(
            username,password,chalanmid
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        if(js.getString("result").equals("1"))
                        {
                            _chalanCancel.value = true
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

}