package com.at.isv.ui.gallery

import android.app.ProgressDialog
import android.bluetooth.BluetoothDevice
import android.content.Intent
import android.content.SharedPreferences
import android.graphics.Bitmap
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import androidx.navigation.fragment.NavHostFragment
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.at.isv.*
import com.at.isv.databinding.FragmentGalleryBinding
import com.dantsu.escposprinter.EscPosCharsetEncoding
import com.dantsu.escposprinter.EscPosPrinter
import com.dantsu.escposprinter.connection.bluetooth.BluetoothConnection
import com.dantsu.escposprinter.connection.bluetooth.BluetoothPrintersConnections
import com.mazenrashed.printooth.Printooth
import com.mazenrashed.printooth.data.printable.Printable
import com.mazenrashed.printooth.data.printable.TextPrintable
import com.mazenrashed.printooth.data.printer.DefaultPrinter
import com.mazenrashed.printooth.utilities.PrintingCallback
import dagger.hilt.android.AndroidEntryPoint


@AndroidEntryPoint
class GalleryFragment : Fragment(){

    private var _binding: FragmentGalleryBinding? = null

    // This property is only valid between onCreateView and
    // onDestroyView.
    private val binding get() = _binding!!


    var is_reading = false

    var settings: SharedPreferences? = null
    var editor: SharedPreferences.Editor? = null

    var timein = ""
    var timeOut = ""
    var firstWeight = ""
    var lastWeight = ""

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        val galleryViewModel =
            ViewModelProvider(this).get(GalleryViewModel::class.java)

        _binding = FragmentGalleryBinding.inflate(inflater, container, false)
        val root: View = binding.root

        settings = requireActivity().getSharedPreferences(ConstantValues.PREFS_NAME,0)
        editor = settings!!.edit()

        val printc = settings!!.getBoolean("chalanReprint",false)
        val editchalan = settings!!.getBoolean("chalanEdit",false)
        val showPrice = settings!!.getBoolean("showPrice",true)
        val showDOD = settings!!.getBoolean("chalanDod",false)
        val chalanDeduction = settings!!.getBoolean("chalanDeduction",false)

        if(printc)
            binding.btnRePrint.visibility = View.VISIBLE
        else
            binding.btnRePrint.visibility = View.GONE

        if(editchalan)
            binding.btnEdit.visibility = View.VISIBLE
        else
            binding.btnEdit.visibility = View.GONE

        if(showPrice)
            binding.llPrice.visibility = View.VISIBLE
        else
            binding.llPrice.visibility = View.GONE

        if(chalanDeduction)
            binding.llDeduction.visibility = View.VISIBLE
        else
            binding.llDeduction.visibility = View.GONE

        if(showDOD)
            binding.tvDOD.visibility = View.VISIBLE
        else
            binding.tvDOD.visibility = View.GONE

        binding.btnEdit.setOnClickListener {
            galleryViewModel.editChalan()
        }

        binding.recyclerviewItems.setHasFixedSize(true)
        binding.recyclerviewItems.isNestedScrollingEnabled = false
        binding.recyclerviewItems.layoutManager = LinearLayoutManager(requireContext(),RecyclerView.VERTICAL,false)

        binding.recyclerviewImgs.setHasFixedSize(true)
        binding.recyclerviewImgs.isNestedScrollingEnabled = false
        binding.recyclerviewImgs.layoutManager = LinearLayoutManager(requireContext(),RecyclerView.HORIZONTAL,false)

        galleryViewModel.isLoading.observe(viewLifecycleOwner)
        {
            if(it) {
                binding.pb.visibility = View.VISIBLE
            }
            else {
                binding.pb.visibility = View.GONE
            }
        }

        galleryViewModel.DetailList.observe(viewLifecycleOwner){
            if(it.isEmpty())
            {
                Toast.makeText(requireContext(),"No Data",Toast.LENGTH_SHORT).show()
            }
            else{
                binding.tvtno.text = it.get(0).challannofordisplay
                binding.tvdate.text = it.get(0).challandate
                binding.tvcompany.text = it.get(0).partyname
                binding.tvtype.text = it.get(0).challantype
                binding.tvcPersonName.text = it.get(0).contactperson
                binding.tvcPersonNumber.text = it.get(0).contactphone
                binding.tvcPersonAdrs.text = it.get(0).partyaddress
                binding.tvVehicle.text = it.get(0).vehicleno
                it.get(0).vehicledetail.also { binding.tvVehicleDetails.text = it }
                binding.tvGrossWeight.text = it.get(0).firstbaseweight
                binding.tvtareweight.text = it.get(0).lastbaseweight
                binding.tvnetweight.text = it.get(0).totalnetweight
                binding.tvPrice.text = it.get(0).totaliprice
                binding.tvDispatchedBy.text = it.get(0).dispatchedbyname
                binding.tvDispatchedOn.text = it.get(0).dispatchedon
                binding.tvDOD.text = it.get(0).deadonduck
                binding.tvRemarks.text = it.get(0).cremarks
                binding.tvdeduction.text = it.get(0).challantotaldeduction

                timein = it.get(0).timeIn
                timeOut = it.get(0).timeOut
                firstWeight = it.get(0).firstbaseweight
                lastWeight = it.get(0).lastbaseweight

                val itemlist = it.get(0).itemlist
                if(it.get(0).imglist != null)
                {
                    val imglist = it.get(0).imglist
                    binding.recyclerviewImgs.adapter = AdapterForItemImages(imglist,requireContext(), requireActivity())
                }


                binding.recyclerviewItems.adapter = AdapterForItem(itemlist,requireContext(), requireActivity(),false,showPrice)

            }
        }

        galleryViewModel.chalanCancel.observe(viewLifecycleOwner){
            if(it)
            {
                Toast.makeText(requireContext(),"Job moved to Pending List, Please edit Job from there.",Toast.LENGTH_SHORT).show()
                LocalBroadcastManager.getInstance(requireContext()).sendBroadcast(Intent("load_data"))
                NavHostFragment.findNavController(this@GalleryFragment).popBackStack()
            }
        }

        binding.btnRePrint.setOnClickListener {
          /*  printjob(binding.tvtno.text.toString().trim(),binding.tvdate.text.toString().trim(),
                timein,firstWeight,timeOut,lastWeight, binding.tvnetweight.text.toString().trim(),
                binding.tvnetweight.text.toString().trim()
            )*/

            printjob2(binding.tvtno.text.toString().trim(),binding.tvdate.text.toString().trim(),
                timein,firstWeight,timeOut,lastWeight, binding.tvnetweight.text.toString().trim(),
                binding.tvnetweight.text.toString().trim(),binding.tvcompany.text.toString()
            )
        }

        return root
    }

    override fun onDestroyView() {

        super.onDestroyView()
        _binding = null
    }

    fun printjob(ticketno:String,cdate:String,timeIn:String,ladenWeight:String,timeOut:String,unladenWeight:String
                 ,deduction:String,netWeght:String)
    {
        val progressDialog = ProgressDialog(requireContext())
        progressDialog.setMessage("Checking Printer...")
        progressDialog.show()
        val printables = ArrayList<Printable>()
        val companyheader = "\nCompany Header\n"
        val cname = settings!!.getString("company_name","ISV").toString()
        val truck =  binding.tvVehicle.text.toString().trim()

        val stringBuilder =
                  "\nCompany Name : $cname\n" +
                    "Truck        : $truck\n" +
                    "Ticket No    : $ticketno\n" +
                    "Date         : $cdate\n" +
                    "Time In      : $timeIn\n" + "时间（进)\n" +
                    "Laden Wt.    : $ladenWeight kg\n" + "装载重量\n"+
                    "Time Out     : $timeOut\n" + "时间（出）\n"+
                    "Unladen Wt.  : $unladenWeight kg\n" + "卸载重量\n" +
                    "Net Wt.      : $netWeght kg\n" + "净重\n" +
                    "Issued By    :______________\n" +
                    "Received By  :_______________\n\n\n\n"
        //Log.e("cs",("cs","stringBuilder=>"+stringBuilder.toString())

        binding.tvPrint.setText(stringBuilder)

        binding.llPrint.isDrawingCacheEnabled = true
        binding.llPrint.buildDrawingCache(true)
        binding.llPrint.measure(View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED),
            View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED));
        binding.llPrint.layout(0, 0, binding.llPrint.getMeasuredWidth(), binding.llPrint.getMeasuredHeight());
        val fullbitmap = Bitmap.createBitmap(binding.llPrint.getDrawingCache())


        if(Printooth.hasPairedPrinter())
        {
            val printableHeader = TextPrintable.Builder()
                .setText(companyheader.toString())
                .setEmphasizedMode(DefaultPrinter.EMPHASIZED_MODE_BOLD)
                .setAlignment(DefaultPrinter.ALIGNMENT_CENTER)
                .setFontSize(DefaultPrinter.FONT_SIZE_NORMAL)
                .setLineSpacing(DefaultPrinter.LINE_SPACING_30)
                .setUnderlined(DefaultPrinter.UNDERLINED_MODE_OFF)
                .build()


            val printable = TextPrintable.Builder()
                .setText(stringBuilder.toString())
                .setEmphasizedMode(DefaultPrinter.EMPHASIZED_MODE_NORMAL)
                .setFontSize(DefaultPrinter.FONT_SIZE_NORMAL)
                .setLineSpacing(DefaultPrinter.LINE_SPACING_30)
                .setUnderlined(DefaultPrinter.UNDERLINED_MODE_OFF)
                .setCharacterCode(DefaultPrinter.CHARCODE_PC850) // Chara
                .build()
          /*  val printable = ImagePrintable.Builder(fullbitmap)
                .build()*/

            printables.add(printableHeader)
            printables.add(printable)
            Printooth.printer().print(printables)

            Printooth.printer().printingCallback = object : PrintingCallback {
                override fun connectingWithPrinter() {
                    progressDialog.setMessage("Connecting with Printer...")
                }
                override fun printingOrderSentSuccessfully() {
                    progressDialog.dismiss()
                    Toast.makeText(requireContext(),"Chalan Reprinted",Toast.LENGTH_LONG).show()
                }  //printer was received your printing order successfully.

                override fun connectionFailed(error: String) {
                    progressDialog.dismiss()
                    Toast.makeText(requireContext(),"Print connection Failed $error",Toast.LENGTH_LONG).show()
                }

                override fun disconnected() {
                    progressDialog.dismiss()
                    //Toast.makeText(requireContext(),"Printer disconnected",Toast.LENGTH_LONG).show()
                }

                override fun onError(error: String) {
                    progressDialog.dismiss()
                    Toast.makeText(requireContext(),"Print connection Error $error",Toast.LENGTH_LONG).show()
                }

                override fun onMessage(message: String) {
                    progressDialog.dismiss()
                    Toast.makeText(requireContext(),"Print message $message",Toast.LENGTH_LONG).show()
                }
            }
            /*progressDialog.setOnDismissListener {

            }*/
        }
        else
        {
            Toast.makeText(requireContext(),"Printer not selected",Toast.LENGTH_LONG).show()
            // slideshowViewModel.gettrolleylist(pref_id)
        }
    }

    fun printjob2(ticketno:String,cdate:String,timeIn:String,ladenWeight:String,timeOut:String,unladenWeight:String
                 ,deduction:String,netWeght:String,partyName:String)
    {
        val progressDialog = ProgressDialog(requireContext())
        progressDialog.setMessage("Checking Printer...")
        progressDialog.show()
        val printables = ArrayList<Printable>()
        val companyheader = "\nCompany Header\n"
        val cname = settings!!.getString("company_name","ISV").toString()
        val truck =  binding.tvVehicle.text.toString().trim()

        val dod = binding.tvDOD.visibility == View.VISIBLE

        val dodamt = binding.tvDOD.text.toString().trim()

        val bdprint_mac = settings!!.getString("bdprint_mac","")

        var listDevices   = BluetoothPrintersConnections().list
        var printDevice: BluetoothConnection? = null
        for(printdevice1 in listDevices!!)
        {
            if(printdevice1.device.address == bdprint_mac)
            {
                printDevice = printdevice1
            }
        }


        if(printDevice != null)
        {
            try{
                val printer =
                    EscPosPrinter(printDevice, 203, 40f, 32, EscPosCharsetEncoding("windows-936", 16))

                if(dod)
                {
                    printer
                        .printFormattedText(
                            "\n[C]<b>KENDO TRADING PTE LTD</b>\n" +
                                    "[C]<b>233 PANDAN LOOP,</b>\n" +
                                    "[C]<b>SINGAPORE 128421</b>\n\n" +
                                    "[L]Company Name [L]: $partyName\n" +
                                    "[L]Truck [L]: $truck\n" +
                                    "[L]Ticket No [L]: $ticketno\n" +
                                    "[L]Date [L]: $cdate\n\n" +
                                    "[L]Time In  [L]: $timeIn\n" +
                                    "[L]时间（进) \n" +
                                    "[L]Laden Wt. [L]: $ladenWeight kg\n" +
                                    "[L]装载重量\n\n" +
                                    "[L]Time Out [L]: $timeOut\n" +
                                    "[L]时间（出）\n" +
                                    "[L]Unladen Wt. [L]: $unladenWeight kg\n" +
                                    "[L]卸载重量\n\n" +
                                    "[L]Net Wt. [L]: $netWeght kg\n" +
                                    "[L]净重\n\n" +
                                    "[L]D.O.D. [L]: $dodamt \n\n\n" +
                                    "[L]Issued By [L]: _____________\n\n\n" +
                                    "[L]Received By [L]: _____________\n"
                        )
                }
                else
                {
                    printer
                        .printFormattedText(
                            "\n[C]<b>KENDO TRADING PTE LTD</b>\n" +
                                    "[C]<b>233 PANDAN LOOP,</b>\n" +
                                    "[C]<b>SINGAPORE 128421</b>\n\n" +
                                    "[L]Company Name [L]: $partyName\n" +
                                    "[L]Truck [L]: $truck\n" +
                                    "[L]Ticket No [L]: $ticketno\n" +
                                    "[L]Date [L]: $cdate\n\n" +
                                    "[L]Time In  [L]: $timeIn\n" +
                                    "[L]时间（进) \n" +
                                    "[L]Laden Wt. [L]: $ladenWeight kg\n" +
                                    "[L]装载重量\n\n" +
                                    "[L]Time Out [L]: $timeOut\n" +
                                    "[L]时间（出）\n" +
                                    "[L]Unladen Wt. [L]: $unladenWeight kg\n" +
                                    "[L]卸载重量\n\n" +
                                    "[L]Net Wt. [L]: $netWeght kg\n" +
                                    "[L]净重\n\n\n" +
                                    "[L]Issued By [L]: _____________\n\n\n" +
                                    "[L]Received By [L]: _____________\n"
                        )
                }

                printer.disconnectPrinter()
                progressDialog.dismiss()

            }
            catch (e : Exception)
            {
                progressDialog.dismiss()
                Toast.makeText(requireContext(),"Printer Error :: "+e.message,Toast.LENGTH_LONG).show()
            }

        }
        else
        {
            progressDialog.dismiss()
            Toast.makeText(requireContext(),"Printer Not Found",Toast.LENGTH_LONG).show()
        }


    }


}