package com.at.isv

import android.content.Context
import android.content.Intent
import android.content.SharedPreferences
import android.graphics.Color
import android.net.ConnectivityManager
import android.net.NetworkCapabilities
import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.provider.Settings
import android.util.Log
import android.view.Gravity
import android.view.View
import android.widget.FrameLayout
import android.widget.TextView
import android.widget.Toast
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import com.at.isv.databinding.ActivitySplashBinding
import com.google.android.material.snackbar.Snackbar
import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.IOException
import kotlin.random.Random

class SplashActivity : AppCompatActivity() {

    private lateinit var binding: ActivitySplashBinding
    private val hideHandler = Handler(Looper.myLooper()!!)
    var settings: SharedPreferences? = null
    var editor: SharedPreferences.Editor? = null

    var fcm_token:String = ""
    var username:String = ""
    var password:String = ""
    lateinit var snackbar: Snackbar

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivitySplashBinding.inflate(layoutInflater)
        setContentView(binding.root)

        // supportActionBar?.setDisplayHomeAsUpEnabled(true)
        //supportActionBar?.v
        supportActionBar?.hide()

        settings = getSharedPreferences(ConstantValues.PREFS_NAME, 0)
        editor = settings?.edit()

        username = settings!!.getString("username","").toString()
        password = settings!!.getString("password","").toString()
        /*  if (fcm_token.isEmpty()) {
              getfcm()
          }*/

        if(username.isEmpty())
        {
            //Log.e("cs",("cs","username is empty"+username);
            hideHandler.postDelayed(Runnable{
                //  val intent = Intent(applicationContext, HomeActivity::class.java)
                val intent = Intent(applicationContext, LoginActivity::class.java)
                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
                startActivity(intent)
                finish()
            },4000)
        }
        else
        {
            //Log.e("cs",("cs","username is not empty"+username);
            hideHandler.postDelayed(Runnable{
                showsnackbar()

            },3000)
        }
    }

    fun showsnackbar() {

        if (!checkonline()) {
            snackbar = Snackbar
                .make(
                    binding.root,
                    "No internet connection! Please turn on the Internet.",
                    Snackbar.LENGTH_INDEFINITE
                )
                .setAction("Retry") { showsnackbar() }
            snackbar.setActionTextColor(Color.WHITE)
            val sbView: View = snackbar.getView()
            val params = sbView.layoutParams as FrameLayout.LayoutParams
            params.gravity = Gravity.BOTTOM
            sbView.layoutParams = params
            sbView.setBackgroundColor(0x55FFFF)
            val textView = sbView.findViewById<View>(com.google.android.material.R.id.snackbar_text) as TextView
            textView.setTextColor(Color.WHITE)
            snackbar.show() //displaying the created dialog.
        } else {
            login(username, password.toString())
        }
    }

    fun checkonline():Boolean
    {
        val cm = applicationContext.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        var isonline = false
        val n = cm.activeNetwork
        if (n != null) {
            val nc = cm.getNetworkCapabilities(n)
            //It will check for both wifi and cellular network
            isonline = nc!!.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR) || nc.hasTransport(
                NetworkCapabilities.TRANSPORT_WIFI)
        }
        return isonline

    }


    /*fun getfcm() {
        fcm_token = settings!!.getString("fcm_token", "")!!
        //Log.e("cs",("cs", "before getting fcm")
        //Log.e("cs",("cs", "before getting fcm22")

        //Log.e("cs",("cs", "before getting fcm3333")
        if (fcm_token.isEmpty()) {
            FirebaseMessaging.getInstance().token
                .addOnCompleteListener(OnCompleteListener { task ->
                    if (!task.isSuccessful) {
                        ////Log.e("cs",("cs", "Fetching FCM registration token failed", task.getException());
                        return@OnCompleteListener
                    }

                    // Get new FCM registration token
                    val token = task.result
                    if (token.length > 0) {
                        ////Log.e("cs",("cs", "fcm_token  11223344->" + fcm_token);
                        fcm_token = task.result
                        ////Log.e("cs",("cs", "fcm_token  11223355->" + fcm_token);
                        editor!!.putString("fcm_token", fcm_token).apply()
                    }


                    // Log and toast
                })
        }

        //Log.e("cs",("cs", "after getting fcm")
    }*/

    fun login(username:String,password:String)
    {
        val deviceid = Settings.Secure.getString(contentResolver, Settings.Secure.ANDROID_ID)
        val security_token = "${Random.nextInt(999)} -${System.currentTimeMillis().toString()}"
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.login(
            username,password,deviceid,security_token
        )
        //Log.e("cs",("cs","login url"+ call222!!.request().url());
        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                if (response.isSuccessful) {
                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        val jsonArray = js.getJSONArray("item")
                        for (i in 0 until jsonArray.length()) {
                            val jsonObject = jsonArray.getJSONObject(i)
                            val result123 = jsonObject.getString("result")
                            //Log.e("cs",("cs", "result123=>$result123")
                            if ((result123 == "1")) {
                                editor!!.putString("uname",jsonObject.getString("uname")).apply()
                                editor!!.putString("username",username).apply()
                                editor!!.putString("password",password).apply()
                                editor!!.putString("security_token",security_token).apply()
                                editor!!.putString("userdesignation",jsonObject.getString("userdesignation")).apply()
                                editor!!.putString("mobileno",jsonObject.getString("mobileno")).apply()
                                editor!!.putString("appversion",jsonObject.getString("appversion")).apply()
                                editor!!.putString("applink",jsonObject.getString("applink")).apply()
                                editor!!.putString("companymid",jsonObject.getString("companymid")).apply()
                                editor!!.putString("company_name",jsonObject.getString("company_name")).apply()
                                editor!!.putString("bdscale_name",jsonObject.getString("bdscale_name")).apply()
                                editor!!.putString("bdscale_mac",jsonObject.getString("bdscale_mac")).apply()
                                editor!!.putString("bdprint_name",jsonObject.getString("bdprint_name")).apply()
                                editor!!.putString("bdprint_mac",jsonObject.getString("bdprint_mac")).apply()
                                editor!!.putFloat("gst_rate",jsonObject.getString("gst_rate").toFloat()).apply()
                                editor!!.putBoolean("deleteItem",jsonObject.getInt("showDeleteChalanItems") > 0).apply()
                                editor!!.putBoolean("editPrice",jsonObject.getInt("ShowEditPrices") > 0).apply()
                                editor!!.putBoolean("editWeight",jsonObject.getInt("ShowManualWeightEdit") > 0).apply()
                                editor!!.putBoolean("chalanPic",jsonObject.getInt("showChalanPitures") > 0).apply()
                                editor!!.putBoolean("chalanswitchJobItemsCount",jsonObject.getInt("showItemAllowed") > 0).apply()
                                editor!!.putBoolean("chalanEdit",jsonObject.getInt("showEditCompletedChalan") > 0).apply()
                                editor!!.putBoolean("chalanReprint",jsonObject.getInt("showReprintChalan") > 0).apply()
                                editor!!.putBoolean("chalanReport",jsonObject.getInt("ShowReport") > 0).apply()
                                editor!!.putBoolean("showPrice",jsonObject.getInt("showPrices") > 0).apply()

                                if(jsonObject.getString("bdscale_mac").isEmpty() || jsonObject.getString("bdprint_mac").isEmpty())
                                {
                                    showdialog()
                                }
                                else
                                {
                                    val intent = Intent(applicationContext, HomeActivity::class.java)
                                    intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
                                    startActivity(intent)
                                    finish()
                                }

                            } else {
                                val intent = Intent(applicationContext, LoginActivity::class.java)
                                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
                                startActivity(intent)
                                finish()
                            }
                        }
                    } catch (e: IOException) {
                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    fun showdialog()
    {
        val builder = AlertDialog.Builder(this)
        builder.setTitle("Scale And/Or Print Mac Address Not Found")
        builder.setMessage("Please ask Admin to assign the Scale and Print OR if you have settings Password then select the devices from it.")
//builder.setPositiveButton("OK", DialogInterface.OnClickListener(function = x))

        builder.setPositiveButton("Enter App") { dialog, which ->
            val intent = Intent(applicationContext, HomeActivity::class.java)
            intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
            startActivity(intent)
            finish()
        }

        builder.setNegativeButton("Exit App") { dialog, which ->
            finish()
        }


        builder.show()
    }
}