package com.at.isv

import android.app.ProgressDialog
import android.content.Intent
import android.content.SharedPreferences
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import androidx.fragment.app.activityViewModels
import androidx.navigation.fragment.NavHostFragment
import com.at.isv.databinding.FragmentChangePasswordBinding
import com.at.isv.databinding.FragmentSettingsBinding
import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.IOException

// TODO: Rename parameter arguments, choose names that match
// the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
private const val ARG_PARAM1 = "param1"
private const val ARG_PARAM2 = "param2"

/**
 * A simple [Fragment] subclass.
 * Use the [SettingsFragment.newInstance] factory method to
 * create an instance of this fragment.
 */
class SettingsFragment : Fragment() {
    // TODO: Rename and change types of parameters
    private var param1: String? = null
    private var param2: String? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            param1 = it.getString(ARG_PARAM1)
            param2 = it.getString(ARG_PARAM2)
        }
    }

    private var _binding: FragmentSettingsBinding? = null

    // This property is only valid between onCreateView and
    // onDestroyView.
    private val binding get() = _binding!!

    var settings: SharedPreferences? = null
    var editor: SharedPreferences.Editor? = null

    var username:String = ""
    var password:String = ""

    private val myviewmodel : HomeActivityViewModel by activityViewModels()

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        _binding = FragmentSettingsBinding.inflate(inflater, container, false)
        val root: View = binding.root

        settings = requireActivity().getSharedPreferences(ConstantValues.PREFS_NAME, 0)
        editor = settings?.edit()

        username =  settings?.getString("username","").toString()
        password =  settings?.getString("password","").toString()

        binding.tvweightName.text = settings?.getString("bdscale_name","Select").toString()
        binding.tvPrinterName.text = settings?.getString("bdprint_name","Select").toString()

        var type: String = ""
        binding.tvweightName.setOnClickListener {
            type = "Weight"
            myviewmodel.setBDType(type)
        }

        binding.tvPrinterName.setOnClickListener {
            type = "Printer"
            myviewmodel.setBDType(type)
        }

        myviewmodel.bdWeightName.observe(viewLifecycleOwner){
            binding.tvweightName.text = it
        }

        myviewmodel.bdPrintName.observe(viewLifecycleOwner){
            binding.tvPrinterName.text = it
        }

        binding.switchDelete.isChecked = settings!!.getBoolean("deleteItem",false)
        binding.switchPrices.isChecked = settings!!.getBoolean("editPrice",false)
        binding.switchEditManu.isChecked = settings!!.getBoolean("editWeight",false)
        binding.switchCamera.isChecked = settings!!.getBoolean("chalanPic",false)
        binding.switchEditjob.isChecked = settings!!.getBoolean("chalanEdit",false)
        binding.switchReprintjob.isChecked = settings!!.getBoolean("chalanReprint",false)
        binding.switchReport.isChecked = settings!!.getBoolean("chalanReport",false)
        binding.switchDod.isChecked = settings!!.getBoolean("chalanDod",false)
        binding.switchRemarks.isChecked = settings!!.getBoolean("chalanRemarks",false)
        binding.switchDeduction.isChecked = settings!!.getBoolean("chalanDeduction",false)
        binding.switchJobItemsCount.isChecked = settings!!.getBoolean("chalanswitchJobItemsCount",false)

        binding.etMinPic.setText(settings!!.getInt("chalanPicMin",0).toString())
        binding.etMaxPic.setText(settings!!.getInt("chalanPicMax",1).toString())
        binding.etMaxItemAllow.setText(settings!!.getInt("chalanMaxItems",9).toString())

        binding.switchCamera.setOnCheckedChangeListener { buttonView, isChecked ->
            if(isChecked)
            {
                binding.etMinPic.isEnabled = true
                binding.etMaxPic.isEnabled = true
            }
            else
            {
                binding.etMinPic.isEnabled = false
                binding.etMaxPic.isEnabled = false
            }
        }

        binding.switchDeduction.setOnCheckedChangeListener { buttonView, isChecked ->
            binding.etEditDeduction.isEnabled = isChecked
        }

        binding.switchJobItemsCount.setOnCheckedChangeListener { buttonView, isChecked ->
            binding.etMaxItemAllow.isEnabled = isChecked
        }

        binding.btnSave.setOnClickListener {
            var minPic = 0
            var maxPic = 2
            var maxItemAllw = 1
            var deduction = 0.0F
            if(binding.switchCamera.isChecked)
            {

                try {
                    minPic = binding.etMinPic.text.toString().trim().toInt()
                }
                catch(e:NumberFormatException)
                {
                    binding.etMinPic.error = "Invalid Minimum Picture value "
                    binding.etMinPic.requestFocus()
                    return@setOnClickListener
                }
                try {
                    maxPic = binding.etMaxPic.text.toString().trim().toInt()
                }
                catch(e:NumberFormatException)
                {
                    binding.etMaxPic.error = "Invalid Maximum Picture value "
                    binding.etMaxPic.requestFocus()
                    return@setOnClickListener
                }

            }
            if(binding.switchJobItemsCount.isChecked)
            {
                try {
                    maxItemAllw = binding.etMaxItemAllow.text.toString().trim().toInt()
                }
                catch (e:NumberFormatException)
                {
                    binding.etMaxItemAllow.error = "Invalid Maximum Item Allowed value "
                    binding.etMaxItemAllow.requestFocus()
                    return@setOnClickListener
                }
            }


            if(binding.switchDeduction.isChecked)
            {
                try {
                    deduction = binding.etEditDeduction.text.toString().trim().toFloat()
                }
                catch (e:NumberFormatException)
                {
                    binding.etEditDeduction.error = "Invalid Deduction value "
                    binding.etEditDeduction.requestFocus()
                    return@setOnClickListener
                }
            }

            binding.btnSave.isEnabled = false
            savesettings(minPic,maxPic,maxItemAllw,deduction)
           
        }

        return root
    }

    fun savesettings(minPic:Int,maxPic:Int,maxItemAllw:Int, ded:Float)
    {

        val bdscale_name = settings?.getString("bdscale_name","")
        val bdscale_mac = settings?.getString("bdscale_mac","")
        val bdprint_name = settings?.getString("bdprint_name","")
        val bdprint_mac = settings?.getString("bdprint_mac","")

        val showDeleteChalanItems = if(binding.switchDelete.isChecked)"1" else "0"
        val ShowEditPrices = if(binding.switchPrices.isChecked) "1" else "0"
        val ShowManualWeightEdit = if(binding.switchEditManu.isChecked) "1" else "0"
        val showChalanPitures = if(binding.switchCamera.isChecked) "1" else "0"
        val showItemAllowed = if(binding.switchJobItemsCount.isChecked) "1" else "0"
        val showEditCompletedChalan = if(binding.switchEditjob.isChecked) "1" else "0"
        val showReprintChalan = if(binding.switchReprintjob.isChecked) "1" else "0"
        val ShowReport = if(binding.switchReport.isChecked) "1" else "0"




        val pDialog = ProgressDialog(requireContext())
        pDialog.setMessage("Saving Settings..")
        pDialog.show()
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.updateSettings(
            username,password, bdscale_name,bdscale_mac,bdprint_name,bdprint_mac,
            showDeleteChalanItems,ShowEditPrices,ShowManualWeightEdit,
            showChalanPitures,showItemAllowed,showEditCompletedChalan,
            showReprintChalan,ShowReport
        )

        Log.e("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                binding.btnSave.isEnabled = true
                if (response.isSuccessful) {
                    binding.btnSave.isEnabled = true
                    if (pDialog.isShowing) pDialog.dismiss()
                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);

                        val jsonArray = js.getJSONArray("item")
                        for (i in 0 until jsonArray.length()) {
                            val jsonObject = jsonArray.getJSONObject(i)
                            val result123 = jsonObject.getString("result")
                            if (pDialog.isShowing) pDialog.dismiss()
                            //Log.e("cs",("cs", "result123=>$result123")
                            if ((result123 == "1")) {
                                editor!!.putBoolean("deleteItem",binding.switchDelete.isChecked).apply()
                                editor!!.putBoolean("editPrice",binding.switchPrices.isChecked).apply()
                                editor!!.putBoolean("editWeight",binding.switchEditManu.isChecked).apply()
                                editor!!.putBoolean("chalanPic",binding.switchCamera.isChecked).apply()
                                editor!!.putBoolean("chalanEdit",binding.switchEditjob.isChecked).apply()
                                editor!!.putBoolean("chalanReprint",binding.switchReprintjob.isChecked).apply()
                                editor!!.putBoolean("chalanReport",binding.switchReport.isChecked).apply()

                                editor!!.putBoolean("chalanDod",binding.switchDod.isChecked).apply()
                                editor!!.putBoolean("chalanRemarks",binding.switchRemarks.isChecked).apply()
                                editor!!.putBoolean("chalanDeduction",binding.switchDeduction.isChecked).apply()
                                editor!!.putBoolean("chalanswitchJobItemsCount",binding.switchJobItemsCount.isChecked).apply()

                                myviewmodel.setChalanReport(binding.switchReport.isChecked)

                                editor!!.putInt("chalanPicMin",minPic).apply()
                                editor!!.putInt("chalanPicMax",maxPic).apply()
                                editor!!.putInt("chalanMaxItems",maxItemAllw).apply()
                                editor!!.putFloat("deduction",ded).apply()



                                Toast.makeText(requireContext(),"Values Saved",Toast.LENGTH_SHORT).show()
                                NavHostFragment.findNavController(this@SettingsFragment).popBackStack()
                            } else {
                                Toast.makeText(requireContext(),"Incorrect Username/Password, Please Try again",
                                    Toast.LENGTH_LONG).show()
                            }
                        }
                    } catch (e: IOException) {
                        if (pDialog.isShowing) pDialog.dismiss()
                        binding.btnSave.isEnabled = true
                        Toast.makeText(requireContext(),"There was some IOException, Please try again after some time.",
                            Toast.LENGTH_LONG).show()
                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        if (pDialog.isShowing) pDialog.dismiss()
                        binding.btnSave.isEnabled = true
                        Toast.makeText(requireContext(),"There was some Exception, Please try again after some time.",
                            Toast.LENGTH_LONG).show()
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    if (pDialog.isShowing) pDialog.dismiss()
                    binding.btnSave.isEnabled = true
                    Toast.makeText(requireContext(),"There was some Issue, Please try again after some time.",
                        Toast.LENGTH_LONG).show()
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                if (pDialog.isShowing) pDialog.dismiss()
                binding.btnSave.isEnabled = true

                Toast.makeText(requireContext(),t.cause.toString(),
                    Toast.LENGTH_LONG).show()
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    companion object {
        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         *
         * @param param1 Parameter 1.
         * @param param2 Parameter 2.
         * @return A new instance of fragment SettingsFragment.
         */
        // TODO: Rename and change types and number of parameters
        @JvmStatic
        fun newInstance(param1: String, param2: String) =
            SettingsFragment().apply {
                arguments = Bundle().apply {
                    putString(ARG_PARAM1, param1)
                    putString(ARG_PARAM2, param2)
                }
            }
    }
}