package com.at.isv

import android.os.Handler
import android.os.SystemClock
import android.view.View

class SafeClickListener(
    private var defaultInterval: Int = 3000,
    private val onSafeCLick: (View) -> Unit
) : View.OnClickListener {
    private var lastTimeClicked: Long = 0
    private var firstClickValid = true
    override fun onClick(v: View) {
        if (SystemClock.elapsedRealtime() - lastTimeClicked < defaultInterval) {
            return
        }
        lastTimeClicked = SystemClock.elapsedRealtime()
       //  v.isEnabled = false
        onSafeCLick(v)

        //Handler().postDelayed(Runnable { v.isEnabled = true }, defaultInterval.toLong())
    }

}