package com.at.isv

import android.app.Application
import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.at.isv.*
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.IOException
import java.lang.reflect.Type
import javax.inject.Inject


@HiltViewModel
class ReportViewModel @Inject constructor(application: Application) : ViewModel() {


    private val _customerList = MutableLiveData<ArrayList<DataCustomer>>()
    val customerList: LiveData<ArrayList<DataCustomer>> = _customerList

    private val _vehicleList = MutableLiveData<ArrayList<DataVehicle>>()
    val vehicleList: LiveData<ArrayList<DataVehicle>> = _vehicleList

    private val _itemList = MutableLiveData<ArrayList<DataItem>>()
    val itemList: LiveData<ArrayList<DataItem>> = _itemList


    var custlists = ArrayList<DataCustomer>()
    var vehilists = ArrayList<DataVehicle>()
    var itemlists = ArrayList<DataItem>()
    var Chaitemlists = ArrayList<ItemData>()

    var username:String = ""
    var password:String = ""
    var chalanmid:String = ""

    private var _isLoading = MutableLiveData<Boolean>()
    val isLoading: LiveData<Boolean> = _isLoading

    private var _errormsg = MutableLiveData<String>()
    val errormsg: LiveData<String> = _errormsg

    private val _chalanList = MutableLiveData<ArrayList<DataReport>>()
    val chalanList: LiveData<ArrayList<DataReport>> = _chalanList


    var chalList = ArrayList<DataReport>()


    init {
        _isLoading.value = true

        custlists.clear()
        username = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("username","").toString()
        password = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("password","").toString()

        getCustomers()
        getVehicles()
        getItems()
    }

     fun getCustomers()
    {

        _isLoading.value = true
        _errormsg.value = ""
        custlists.clear()
        custlists.add(DataCustomer("0","All","","",""))
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.getCustomerList(
            username,password
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        //Log.e("cs",("cs","result =>"+js.getString("result"))
                        if(js.getString("result").equals("1"))
                        {
                            val jsonArray = js.getJSONArray("item")
                            //Log.e("cs",("cs","jsonArray =>"+jsonArray.toString())
                            val gson = Gson()
                            val type: Type = object : TypeToken<List<DataCustomer?>?>() {}.type
                            custlists.addAll(gson.fromJson(jsonArray.toString(), type))
                            //Log.e("cs",("cs","conatactlist =>"+custlists.size)
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                        _customerList.value = custlists
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    private fun getVehicles()
    {

        _isLoading.value = true
        _errormsg.value = ""
        vehilists.clear()
        vehilists.add(DataVehicle("0","All","","free","0",""))
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.getVehicleList(
            username,password
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        //Log.e("cs",("cs","result =>"+js.getString("result"))
                        if(js.getString("result").equals("1"))
                        {
                            val jsonArray = js.getJSONArray("item")
                            //Log.e("cs",("cs","jsonArray =>"+jsonArray.toString())
                            val gson = Gson()
                            val type: Type = object : TypeToken<List<DataVehicle?>?>() {}.type
                            vehilists.addAll(gson.fromJson(jsonArray.toString(), type))
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                        _vehicleList.value = vehilists
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    private fun getItems()
    {

        _isLoading.value = true
        _errormsg.value = ""
        itemlists.clear()
        itemlists.add(DataItem("0","All","","","",""))
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.getItemList(
            username,password
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        //Log.e("cs",("cs","result =>"+js.getString("result"))
                        if(js.getString("result").equals("1"))
                        {
                            val jsonArray = js.getJSONArray("item")
                            //Log.e("cs",("cs","jsonArray =>"+jsonArray.toString())
                            val gson = Gson()
                            val type: Type = object : TypeToken<List<DataItem?>?>() {}.type
                            itemlists.addAll(gson.fromJson(jsonArray.toString(), type))
                            //Log.e("cs",("cs","conatactlist =>"+custlists.size)
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                        _itemList.value = itemlists
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    fun getFilteredList(fromDate:String,toDate:String,ClientID:String,VehicleID:String,ItemId:String)
    {
        viewModelScope.launch(Dispatchers.IO) {
            runCatching {
                _isLoading.postValue(true)
                _errormsg.postValue("")
                chalList.clear()
                AppConfig.retrofit.create(ApiConfig::class.java).getFilteredChalanList(username,password,fromDate,toDate,ClientID,VehicleID,ItemId)
            }.onSuccess{

                //Log.e("cs",("cs","url=>"+it?.request()!!.url())
                val response = it!!.execute()
                if (response.isSuccessful) {

                    _isLoading.postValue(false)
                    try {
                        val result = response.body()?.string()

                        val js = JSONObject(result!!);
                        //Log.e("cs",("cs","result =>"+js.getString("result"))
                        if(js.getString("result").equals("1"))
                        {
                            val gson = Gson()
                            val jsonArray = js.getJSONArray("chalanArr")
                            val type: Type = object : TypeToken<List<DataList?>?>() {}.type
                            val challanList:ArrayList<DataList> = gson.fromJson(jsonArray.toString(), type)

                            val jsonArray1 = js.getJSONArray("custArr")
                            val type1: Type = object : TypeToken<List<DataReportSub?>?>() {}.type
                            val custList:ArrayList<DataReportSub> = gson.fromJson(jsonArray1.toString(), type1)




                            val jsonArray2 = js.getJSONArray("vehiArr")
                            val type2: Type = object : TypeToken<List<DataReportSub?>?>() {}.type
                            val vehiList:ArrayList<DataReportSub> = gson.fromJson(jsonArray2.toString(), type2)

                            val jsonArray3 = js.getJSONArray("itemArr")
                            val type3: Type = object : TypeToken<List<DataReportSub?>?>() {}.type
                            val itemList:ArrayList<DataReportSub> = gson.fromJson(jsonArray3.toString(), type3)

                            chalList.add(DataReport(challanList,custList,vehiList,itemList))

                        }
                        else
                        {
                            _errormsg.postValue(js.getString("msg"))
                        }
                        _chalanList.postValue(chalList)

                    } catch (e: IOException) {
                        _isLoading.postValue(false)

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.postValue(false)
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.postValue(false)
                    _errormsg.postValue("Please try after some time")

                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }.onFailure {
                _isLoading.postValue(false)
                _errormsg.postValue("Failure =>$it")

                //Log.e("cs",("cs", "Failure =>$it")
            }
        }
    }


}