package com.at.isv

import android.R
import android.app.DatePickerDialog
import android.os.Bundle
import android.text.Editable
import android.text.TextWatcher
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.widget.*
import androidx.fragment.app.Fragment
import androidx.fragment.app.activityViewModels
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.at.isv.databinding.FragmentReportBinding
import com.at.isv.ui.slideshow.SlideshowViewModel
import dagger.hilt.android.AndroidEntryPoint
import java.text.SimpleDateFormat
import java.util.*
import kotlin.collections.ArrayList


// TODO: Rename parameter arguments, choose names that match
// the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
private const val ARG_PARAM1 = "param1"
private const val ARG_PARAM2 = "param2"

/**
 * A simple [Fragment] subclass.
 * Use the [ReportFragment.newInstance] factory method to
 * create an instance of this fragment.
 */
@AndroidEntryPoint
class ReportFragment : Fragment() {
    // TODO: Rename and change types of parameters
    private var param1: String? = null
    private var param2: String? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            param1 = it.getString(ARG_PARAM1)
            param2 = it.getString(ARG_PARAM2)
        }
    }

    private var _binding: FragmentReportBinding? = null

    // This property is only valid between onCreateView and
    // onDestroyView.
    private val binding get() = _binding!!
     val reportViewModel: ReportViewModel by  lazy {
        ViewModelProvider(this).get(ReportViewModel::class.java)
    }
    private val myviewmodel : HomeActivityViewModel by activityViewModels()
    var fromDate = ""
    var toDate = ""
    var startDate:Date? = null
    var endDate:Date? = null
    var viewClicked : View? = null

    var client_id = "0"
    var clientNameList:ArrayList<String> = ArrayList<String>()
    var clientIDList:ArrayList<String> = ArrayList<String>()

    var vehicle_ID = "0"
    var VehicleNameList:ArrayList<String> = ArrayList<String>()
    var VehicleIDList:ArrayList<String> = ArrayList<String>()

    var item_ID = "0"
    var ItemNameList:ArrayList<String> = ArrayList<String>()
    var ItemIDList:ArrayList<String> = ArrayList<String>()

    var CustomerDataList:ArrayList<DataCustomer> = ArrayList<DataCustomer>()
    var VehicleDataList:ArrayList<DataVehicle> = ArrayList<DataVehicle>()
    var ItemDataList:ArrayList<DataItem> = ArrayList<DataItem>()

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment

        _binding = FragmentReportBinding.inflate(inflater, container, false)
        val root: View = binding.root

        binding.recyclerViewReport.isNestedScrollingEnabled= false
        binding.recyclerViewReport.setHasFixedSize(true)
        binding.recyclerViewReport.layoutManager = LinearLayoutManager(requireContext(),
            RecyclerView.VERTICAL,false)

        var dataList = ArrayList<DataReport>()
        var adapterForList = AdapterForReport(dataList, requireContext(), requireActivity())
        binding.recyclerViewReport.adapter =adapterForList

        reportViewModel.isLoading.observe(viewLifecycleOwner)
        {
            if(it) {
                requireActivity().window.setFlags(
                    WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE,
                    WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE)
                viewClicked?.isEnabled = false
                binding.pb.visibility = View.VISIBLE
            }
            else {
                requireActivity().window.clearFlags(WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE)
                viewClicked?.isEnabled = true
                binding.pb.visibility = View.GONE
            }
        }
        reportViewModel.errormsg.observe(viewLifecycleOwner)
        {
            if(it.isNotEmpty())
                Toast.makeText(requireContext(),it, Toast.LENGTH_SHORT).show()
        }

        val c1 = Calendar.getInstance()
        val c = Calendar.getInstance()
        val day = c[Calendar.DAY_OF_MONTH]
        val month = c[Calendar.MONTH] + 1
        val year = c[Calendar.YEAR]
        var month1 = ""
        var day1 = ""
        month1 = if (month < 10) {
            "0$month"
        } else {
            "" + month
        }
        day1 = if (day < 10) {
            "0$day"
        } else {
            "" + day
        }

        if(fromDate.isEmpty() && toDate.isEmpty())
        {
            fromDate = "01-$month1-$year"
            toDate = "$day1-$month1-$year"
            binding.etStartDate.setText(fromDate)
            binding.etEndDate.setText(toDate)

            startDate = SimpleDateFormat("dd-MM-yyyy", Locale.getDefault()).parse(fromDate)
            endDate = SimpleDateFormat("dd-MM-yyyy", Locale.getDefault()).parse(toDate)

        }

        reportViewModel.getFilteredList(fromDate,toDate,client_id,vehicle_ID,item_ID)

        binding.etStartDate.setOnClickListener {
            val dpd = DatePickerDialog(
                activity!!,
                { view: DatePicker?, year: Int, monthOfYear: Int, dayOfMonth: Int ->
                    //Log.e("cs",("cs","fromDate 1=>"+year+"-"+monthOfYear+"-"+dayOfMonth)
                    val month3 = monthOfYear+1
                    var month2 = ""
                    var day2 = ""
                    month2 = if (month3 < 10) {
                        "0$month3"
                    } else {
                        "" + month3
                    }
                    day2 = if (dayOfMonth < 10) {
                        "0$dayOfMonth"
                    } else {
                        "" + dayOfMonth
                    }

                    fromDate = day2 + "-" + month2 + "-" + year
                    //Log.e("cs",("cs","fromDate 2=>"+fromDate)
                    startDate = SimpleDateFormat("dd-MM-yyyy", Locale.getDefault()).parse(fromDate)
                    binding.etStartDate.setText(fromDate)
                    reportViewModel.getFilteredList(fromDate,toDate,client_id,vehicle_ID,item_ID)
                }, c1.get(Calendar.YEAR), c1.get(Calendar.MONTH), c1.get(Calendar.DAY_OF_MONTH)
            )
            dpd.datePicker.maxDate = endDate!!.time
            dpd.show()
        }

        binding.etEndDate.setOnClickListener {
            val dpd = DatePickerDialog(
                activity!!,
                { view: DatePicker?, year: Int, monthOfYear: Int, dayOfMonth: Int ->
                    val month3 = monthOfYear+1
                    var month2 = ""
                    var day2 = ""
                    month2 = if (month3 < 10) {
                        "0$month3"
                    } else {
                        "" + month3
                    }
                    day2 = if (dayOfMonth < 10) {
                        "0$dayOfMonth"
                    } else {
                        "" + dayOfMonth
                    }
                    toDate =
                        day2 + "-" + month2 + "-" + year
                    endDate = SimpleDateFormat("dd-MM-yyyy", Locale.getDefault()).parse(toDate)
                    binding.etEndDate.setText(toDate)
                    reportViewModel.getFilteredList(fromDate,toDate,client_id,vehicle_ID,item_ID)
                }, c1.get(Calendar.YEAR), c1.get(Calendar.MONTH), c1.get(Calendar.DAY_OF_MONTH)
            )


            dpd.datePicker.minDate = startDate!!.time
            dpd.datePicker.maxDate = c.timeInMillis
            dpd.show()
        }

        reportViewModel.customerList.observe(viewLifecycleOwner) {
            CustomerDataList.clear()
            clientNameList.clear()
            clientIDList.clear()
            CustomerDataList.addAll(it)

            //Log.e("cs",("cs","Customerdatalist=>"+CustomerDataList.size)

            for(cust in CustomerDataList)
            {
                clientNameList.add(cust.customerName)
                clientIDList.add(cust.customerID)
            }

        }

        reportViewModel.vehicleList.observe(viewLifecycleOwner) {
            VehicleDataList.clear()
            VehicleNameList.clear()
            VehicleIDList.clear()
            VehicleDataList.addAll(it)

            //Log.e("cs",("cs","VehicleDataList=>"+VehicleDataList.size)

            for(vehi in VehicleDataList)
            {
                VehicleNameList.add(vehi.vehicleno)
                VehicleIDList.add(vehi.vehicleID)
            }
        }

        reportViewModel.itemList.observe(viewLifecycleOwner) {
            ItemDataList.clear()
            ItemNameList.clear()
            ItemIDList.clear()
            ItemDataList.addAll(it)
            for(item in ItemDataList)
            {
                ItemNameList.add(item.itemname)
                ItemIDList.add(item.itemmid)
            }

        }

        binding.etCustomer.setSafeOnClickListener {
            val customDialogbox = CustomDialogbox(context, clientNameList, "Select Customer")
            customDialogbox.create()
            customDialogbox.listView!!.onItemClickListener =
                AdapterView.OnItemClickListener { parent, view, position, id -> // int poos = arrWorkTypeNameArray.indexOf(parent.getSelectedItem());
                    binding.etCustomer.setText(customDialogbox.adapter!!.getItem(position))
                    client_id = clientIDList.get(clientNameList.indexOf(customDialogbox.adapter!!.getItem(position)))
                    reportViewModel.getFilteredList(fromDate,toDate,client_id,vehicle_ID,item_ID)
                    customDialogbox.dismiss()
                }
        }

        binding.etVehicle.setSafeOnClickListener {
            val customDialogbox = CustomDialogbox(context, VehicleNameList, "Select Vehicle")
            customDialogbox.create()
            customDialogbox.listView!!.onItemClickListener =
                AdapterView.OnItemClickListener { parent, view, position, id -> // int poos = arrWorkTypeNameArray.indexOf(parent.getSelectedItem());
                    binding.etVehicle.setText(customDialogbox.adapter!!.getItem(position))
                    vehicle_ID = VehicleIDList.get(VehicleNameList.indexOf(customDialogbox.adapter!!.getItem(position)))
                    reportViewModel.getFilteredList(fromDate,toDate,client_id,vehicle_ID,item_ID)
                    customDialogbox.dismiss()
                }
        }

        binding.etItem.setSafeOnClickListener {
            val customDialogbox = CustomDialogbox(context, ItemNameList, "Select Item")
            customDialogbox.create()
            customDialogbox.listView!!.onItemClickListener =
                AdapterView.OnItemClickListener { parent, view, position, id -> // int poos = arrWorkTypeNameArray.indexOf(parent.getSelectedItem());
                    binding.etItem.setText(customDialogbox.adapter!!.getItem(position))
                    item_ID = ItemIDList.get(ItemNameList.indexOf(customDialogbox.adapter!!.getItem(position)))
                    reportViewModel.getFilteredList(fromDate,toDate,client_id,vehicle_ID,item_ID)
                    customDialogbox.dismiss()
                }
        }



        binding.etSearch.addTextChangedListener(object : TextWatcher{
            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {

            }

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
               adapterForList.filter.filter(s)
            }

            override fun afterTextChanged(s: Editable?) {

            }
        })



        reportViewModel.chalanList.observe(viewLifecycleOwner){
            //Log.e("cs",("cs","count=>"+it.size)
            if(it.isEmpty())
            {
                binding.recyclerViewReport.visibility = View.GONE
              //  binding.llnodata.visibility = View.VISIBLE
            }
            else {
                //Log.e("cs",("cs","count 1=>"+it.size)
               // binding.llnodata.visibility = View.GONE
                binding.recyclerViewReport.visibility = View.VISIBLE
                dataList.clear()
                dataList.addAll(it)
                //Log.e("cs",("cs","count 2=>"+dataList.size)
                adapterForList = AdapterForReport(dataList, requireContext(), requireActivity())
                binding.recyclerViewReport.adapter =adapterForList
            }
        }
        return root
    }

    fun View.setSafeOnClickListener(onSafeClick: (View) -> Unit) {
        val safeClickListener = SafeClickListener {
            viewClicked = it
            onSafeClick(it)
        }
        setOnClickListener(safeClickListener)
    }

    companion object {
        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         *
         * @param param1 Parameter 1.
         * @param param2 Parameter 2.
         * @return A new instance of fragment ReportFragment.
         */
        // TODO: Rename and change types and number of parameters
        @JvmStatic
        fun newInstance(param1: String, param2: String) =
            ReportFragment().apply {
                arguments = Bundle().apply {
                    putString(ARG_PARAM1, param1)
                    putString(ARG_PARAM2, param2)
                }
            }
    }
}