package com.at.isv

import android.content.*
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.widget.Toast
import androidx.lifecycle.ViewModelProvider
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import androidx.navigation.fragment.NavHostFragment
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.at.isv.databinding.FragmentPendingChalanBinding
import com.at.isv.ui.slideshow.SlideshowViewModel
import dagger.hilt.android.AndroidEntryPoint


// TODO: Rename parameter arguments, choose names that match
// the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
private const val ARG_PARAM1 = "param1"
private const val ARG_PARAM2 = "param2"

/**
 * A simple [Fragment] subclass.
 * Use the [PendingChalanFragment.newInstance] factory method to
 * create an instance of this fragment.
 */
@AndroidEntryPoint
class PendingChalanFragment : Fragment() {
    // TODO: Rename and change types of parameters
    private var param1: String? = null
    private var param2: String? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            param1 = it.getString(ARG_PARAM1)
            param2 = it.getString(ARG_PARAM2)
        }
    }

    private var _binding: FragmentPendingChalanBinding? = null

    // This property is only valid between onCreateView and
    // onDestroyView.
    private val binding get() = _binding!!
    lateinit var pendingChalanViewModel : PendingChalanViewModel

    var settings: SharedPreferences? = null
    var editor: SharedPreferences.Editor? = null


    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        _binding = FragmentPendingChalanBinding.inflate(inflater, container, false)
        val root: View = binding.root

         pendingChalanViewModel =
            ViewModelProvider(this).get(PendingChalanViewModel::class.java)

        settings = requireActivity().getSharedPreferences(ConstantValues.PREFS_NAME,0)
        editor = settings!!.edit()

        binding.recyclerView.setHasFixedSize(true)
        binding.recyclerView.layoutManager = LinearLayoutManager(requireContext(),RecyclerView.VERTICAL,false)

        binding.fabAdd.setOnClickListener {
            val bdscale_mac = settings!!.getString("bdscale_mac","").toString()
            val bdprint_mac = settings!!.getString("bdprint_mac","").toString()
            if(bdscale_mac.isEmpty() || bdprint_mac.isEmpty())
            {
                Toast.makeText(requireContext(),"Please ask Admin to assign the Scale and Print OR if you have settings Password then select the devices from it.",Toast.LENGTH_LONG).show()
                return@setOnClickListener
            }

            requireActivity().getSharedPreferences(AdapterForList.PREFS_NAME,0).edit().remove("chalanmid").apply()
            NavHostFragment.findNavController(this@PendingChalanFragment).navigate(R.id.nav_slideshow)
        }

        pendingChalanViewModel.isLoading.observe(viewLifecycleOwner){
            if(it)
            {
                activity!!.window.setFlags(
                    WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE,
                    WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE)
                binding.pb.visibility = View.VISIBLE

            }
            else
            {
                activity!!.window.clearFlags(WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE)
                binding.pb.visibility = View.GONE
            }
        }

        pendingChalanViewModel.chalanList.observe(viewLifecycleOwner){
            if(it.isEmpty())
            {
                binding.llnodata.visibility = View.VISIBLE
            }
            else {
                binding.llnodata.visibility = View.GONE
                binding.recyclerView.adapter =
                    AdapterForList(it, requireContext(), requireActivity())
            }
        }
        return root
    }

    override fun onResume() {
        super.onResume()
        LocalBroadcastManager.getInstance(requireContext()).registerReceiver(load_data,
            IntentFilter("load_data"))
        pendingChalanViewModel.getChalans()

    }

    override fun onPause() {
        super.onPause()
        LocalBroadcastManager.getInstance(requireContext()).unregisterReceiver(load_data)
    }

    val load_data:BroadcastReceiver = object : BroadcastReceiver(){
        override fun onReceive(context: Context?, intent: Intent?) {
            pendingChalanViewModel.getChalans()
        }

    }

    override fun onViewStateRestored(savedInstanceState: Bundle?) {
        super.onViewStateRestored(savedInstanceState)
        //Log.e("cs",("cs","onViewStateRestored =>")
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        //Log.e("cs",("cs","onViewCreated =>")
    }



    companion object {
        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         *
         * @param param1 Parameter 1.
         * @param param2 Parameter 2.
         * @return A new instance of fragment PendingChalanFragment.
         */
        // TODO: Rename and change types and number of parameters
        @JvmStatic
        fun newInstance(param1: String, param2: String) =
            PendingChalanFragment().apply {
                arguments = Bundle().apply {
                    putString(ARG_PARAM1, param1)
                    putString(ARG_PARAM2, param2)
                }
            }
    }
}