package com.at.isv

import android.annotation.SuppressLint
import android.app.Application
import android.bluetooth.BluetoothDevice
import android.bluetooth.BluetoothSocket
import android.text.SpannableStringBuilder
import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.at.isv.ApiConfig
import com.at.isv.AppConfig
import com.at.isv.ConstantValues
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.channels.BufferOverflow
import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.buffer
import kotlinx.coroutines.flow.flow
import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.ByteArrayInputStream
import java.io.IOException
import java.math.RoundingMode
import java.text.DecimalFormat
import java.util.*
import javax.inject.Inject
import kotlin.collections.ArrayDeque

@HiltViewModel
class MainViewModel @Inject constructor(application: Application): ViewModel() {

    private var _isReading = MutableLiveData<Boolean>()
    val isReading: LiveData<Boolean> = _isReading

    private var _weightdata = MutableLiveData<String>()
    val weightdata: LiveData<String> = _weightdata

    private var _bdType = MutableLiveData<String>()
    val bdType: LiveData<String> = _bdType

    private var _bdWeightName = MutableLiveData<String>()
    val bdWeightName: LiveData<String> = _bdWeightName

    private var _bdPrintName = MutableLiveData<String>()
    val bdPrintName: LiveData<String> = _bdPrintName

    private var _isLoading = MutableLiveData<Boolean>()
    val isLoading: LiveData<Boolean> = _isLoading

    private var _senjob = MutableLiveData<String>()
    val senjob: LiveData<String> = _senjob

    private var _errormsg = MutableLiveData<String>()
    val errormsg: LiveData<String> = _errormsg

    private var _cancelJob = MutableLiveData<String>()
    val cancelJob: LiveData<String> = _cancelJob

    private var _trolleylistSize = MutableLiveData<String>()
    val trolleylistSize: LiveData<String> = _trolleylistSize

    private var _retryld = MutableLiveData<Int>(0)
    val retry: LiveData<Int> = _retryld

    private var _bluetoothweight = MutableLiveData<BluetoothDevice>()
    val bluetoothweight: LiveData<BluetoothDevice> = _bluetoothweight

   // var retry = 0

    lateinit var newsocket: BluetoothSocket

    private val MY_UUID: UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB")

    var username:String = ""
    var password:String = ""
    var pref_id:String = ""

    init {
        _isLoading.value = true
        _errormsg.value = ""
        username = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("username","").toString()
        password = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("password","").toString()
        pref_id = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("pref_id","0").toString()
    }

   /* fun setRetryInVM(ret: Int)
    {
        retry = ret
    }
*/
   /* fun setreading(isread:Boolean)
    {
        _isReading.value = isread
    }

    fun setWeight(weight:String)
    {
        _weightdata.value = weight
    }

    fun setBDType(type:String)
    {
        _bdType.value = type
    }

    fun setbdevice(bdweight: BluetoothDevice)
    {
        _bluetoothweight.value = bdweight
    }


    fun setBDName(type:String,name:String)
    {
        //Log.e("cs",("cs","setBDType :: "+type + "   Name :: "+name )
        if(type.equals("1"))
            _bdWeightName.value = name
        else if(type.equals("2"))
            _bdPrintName.value = name
    }

    public fun canceljob(pref_idlate:String)
    {
        _isLoading.value = true

        _cancelJob.value = ""
        _errormsg.value = ""
//serviceCaller is the interface initialized with retrofit.create...
//serviceCaller is the interface initialized with retrofit.create...


        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.cancelJob(
            username,password,pref_idlate
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);

                        val jsonArray = js.getJSONArray("item")
                        for (i in 0 until jsonArray.length()) {
                            val jsonObject = jsonArray.getJSONObject(i)
                            val result123 = jsonObject.getString("result")
                            //Log.e("cs",("cs", "result123=>$result123")
                            if ((result123 == "1")) {
                                _cancelJob.value = "True"
                            } else {
                                _cancelJob.value = "False"
                                _errormsg.value = jsonObject.getString("msg")
                            }
                        }
                    } catch (e: IOException) {
                        _isLoading.value = false
                        _cancelJob.value = "False"
                        _errormsg.value = "IO Exception"
                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        _cancelJob.value = "False"
                        _errormsg.value = "JSON Exception"
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    _cancelJob.value = "False"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                _cancelJob.value = "False"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }*/

    /*public fun sendjob(pref_idlate:String,hotelid: String,grossweight: String,netweight: String)
    {
        _isLoading.value = true

        _senjob.value = ""
        _errormsg.value = ""
//serviceCaller is the interface initialized with retrofit.create...
//serviceCaller is the interface initialized with retrofit.create...


        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.addjob(
            username,password,pref_idlate,hotelid
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);

                        val jsonArray = js.getJSONArray("item")
                        for (i in 0 until jsonArray.length()) {
                            val jsonObject = jsonArray.getJSONObject(i)
                            val result123 = jsonObject.getString("result")

                            //Log.e("cs",("cs", "result123=>$result123")
                            if ((result123 == "1")) {
                                _senjob.value = "True"
                            } else {
                                _senjob.value = "False"
                                _errormsg.value = jsonObject.getString("msg")
                            }
                        }

                    } catch (e: IOException) {
                        _isLoading.value = false
                        _senjob.value = "False"
                        _errormsg.value = "IO Exception"
                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        _senjob.value = "False"
                        _errormsg.value = "JSON Exception"
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    _senjob.value = "False"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                _senjob.value = "False"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }*/


    @SuppressLint("MissingPermission")
    public inner class ConnectCoroutine(device: BluetoothDevice){
        val mmSocket: BluetoothSocket? by lazy(LazyThreadSafetyMode.NONE) {
            if(retry.value!! < 3)
                device.createRfcommSocketToServiceRecord(MY_UUID)
            else
                device.createInsecureRfcommSocketToServiceRecord(MY_UUID)
        }
        var s = ""
        var oldweight = ""
        lateinit var latestGrossWeight: Flow<String>
        suspend fun run()
        {
           // bluetoothAdapter.cancelDiscovery()
            mmSocket?.let { socket ->
                // Connect to the remote device through the socket. This call blocks
                // until it succeeds or throws an exception.
                newsocket = socket
                try {
                    newsocket.connect()
                }
                catch (e : IOException)
                {
                    //Log.e("cs",("cs","IOException 1 =>"+e.message)
                    try {
                        val clazz = socket.remoteDevice.javaClass
                        val paramTypes = arrayOf<Class<*>>(Integer.TYPE)
                        val m = clazz.getMethod("createRfcommSocket", *paramTypes)
                        newsocket = m.invoke(socket.remoteDevice, Integer.valueOf(1)) as BluetoothSocket
                        newsocket.connect()
                    }
                    catch (e1 : Exception)
                    {
                        //Log.e("cs",("cs","IOException 2 =>"+e1.message)
                    }
                }
                try {

                    val buffer = ByteArray(1024)
                    var len: Int
                    //Log.e("cs",("cs","No Exception conected 4 =>")
                    latestGrossWeight = flow {
                        while(true) {
                            _retryld.value = _retryld.value?.plus(1)
                           /* if(retry.value!! > 3 )
                            {
                               *//* connectedbluetoothdevice = null
                                weightBluetoothDevice = null
                                connecttoremtedevice()*//*
                                *//*requireActivity().runOnUiThread {
                                    trolleyBinding?.tvbconnect?.text = "Re Pairing with bluetooth weight device"
                                    trolleyBinding?.pbconnect?.visibility = View.GONE
                                }*//*
                            }*/
                            len = newsocket.inputStream.read(buffer)
                            _retryld.value = 0

                            val input = ByteArrayInputStream(buffer)

                            val data123 : ByteArray = Arrays.copyOf(buffer, len)
                            val datas = ArrayDeque<ByteArray>()
                            datas.add(data123)

                            val spn = SpannableStringBuilder()
                            val spn_hexenabled = SpannableStringBuilder()
                            for (data in datas) {
                                spn_hexenabled.append(TextUtil.toHexString(data)).append('\n')
                                val msg :String  = String(data)
                                //Log.e("cs",("cs","string 23=>"+msg)
                                if(msg.contains(",") && msg.contains("kg") && msg.count { it == ','} == 1)
                                {
                                    val a = msg.filter { it.isDigit() || it == '.'}
                                    if(a.trim().isNotEmpty()  && !a.equals(oldweight))
                                    {

                                        var grossweightstr = "0"
                                        try {
                                            val df = DecimalFormat("#.##")
                                            df.roundingMode = RoundingMode.CEILING
                                            grossweightstr =  df.format(a.toBigDecimal())
                                            //Log.e("cs",("cs","string 44=>"+a)
                                        }
                                        catch (e:NumberFormatException)
                                        {
                                            grossweightstr = "0";
                                        }
                                        emit(grossweightstr)

                                        oldweight = a
                                        //Log.e("cs",("cs","string 44=>"+a)
                                    }
                                }
                            }
                        }
                    }.buffer(1024, BufferOverflow.DROP_OLDEST)


                } catch (e: Exception) {
                    //Log.e("cs",("cs","connection exception =>"+e.message);
                    try {
                        mmSocket?.close()
                        newsocket.close()

                    } catch (e: IOException) {
                        //Log.e("cs",("cs", "Could not close the client socket", e)
                    }
                }
            }
        }

        fun cancel() {
            try {
                mmSocket?.close()
                newsocket.close()
            } catch (e: IOException) {
                //Log.e("cs",("cs", "Could not close the client socket", e)
            }
        }
    }

}