package com.at.isv

import android.app.Dialog
import android.app.ProgressDialog
import android.content.Context
import android.content.Intent
import android.content.SharedPreferences
import android.graphics.Color
import android.net.ConnectivityManager
import android.net.NetworkCapabilities
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.provider.Settings
import android.util.Log
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.TextView
import android.widget.Toast
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import com.at.isv.ConstantValues.PREFS_NAME
import com.at.isv.databinding.ActivityLoginBinding
import com.at.isv.databinding.NewBarcodeScannerBinding
import com.budiyev.android.codescanner.*
import com.google.android.material.snackbar.Snackbar
import com.karumi.dexter.Dexter
import com.karumi.dexter.MultiplePermissionsReport
import com.karumi.dexter.PermissionToken
import com.karumi.dexter.listener.PermissionRequest
import com.karumi.dexter.listener.multi.MultiplePermissionsListener
import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.IOException
import java.math.BigInteger
import java.security.MessageDigest
import kotlin.random.Random

class LoginActivity : AppCompatActivity() {

    private lateinit var binding: ActivityLoginBinding
    var settings: SharedPreferences? = null
    var editor: SharedPreferences.Editor? = null

    var fcm_token:String = ""
    var device_id:String = ""

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityLoginBinding.inflate(layoutInflater)
        setContentView(binding.root)
        supportActionBar?.hide()
        settings = getSharedPreferences(PREFS_NAME, 0)
        editor = settings?.edit()




    }

    override fun onResume() {
        super.onResume()

        binding.btnLogin.isEnabled = false
        binding.btnLoginScan.isEnabled = false

        device_id = Settings.Secure.getString(
            contentResolver,
            Settings.Secure.ANDROID_ID
        )

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            Dexter.withContext(this@LoginActivity)
                .withPermissions(
                    android.Manifest.permission.BLUETOOTH_CONNECT,
                    android.Manifest.permission.BLUETOOTH_SCAN,
                    android.Manifest.permission.CAMERA,
                    android.Manifest.permission.ACCESS_COARSE_LOCATION
                ).withListener(object : MultiplePermissionsListener {
                    override fun onPermissionsChecked(report: MultiplePermissionsReport) {
                        if (!report.areAllPermissionsGranted()) {
                            //Log.e("cs",("cs", "no permission 1")
                            val denied = report.deniedPermissionResponses
                            var perdenied  = ""
                            for(d in denied)
                            {
                                perdenied =  perdenied + (d.permissionName) + ","
                            }
                            Toast.makeText(
                                this@LoginActivity,
                                "Please Provide $perdenied permissions requested by the app",
                                Toast.LENGTH_LONG
                            ).show()
                            val intent = Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS)
                            val uri = Uri.fromParts("package", packageName, null)
                            intent.data = uri
                            startActivity(intent)
                        }
                        else
                        {
                            binding.btnLogin.isEnabled = true
                            binding.btnLoginScan.isEnabled = true
                        }
                    }

                    override fun onPermissionRationaleShouldBeShown(
                        permissions: List<PermissionRequest?>?,
                        token: PermissionToken?
                    ) {
                        token?.continuePermissionRequest()
                    }
                }).check()

        } else {
            Dexter.withContext(this@LoginActivity)
                .withPermissions(
                    android.Manifest.permission.BLUETOOTH,
                    android.Manifest.permission.BLUETOOTH_ADMIN,
                    android.Manifest.permission.CAMERA,
                    android.Manifest.permission.ACCESS_COARSE_LOCATION
                ).withListener(object : MultiplePermissionsListener {
                    override fun onPermissionsChecked(report: MultiplePermissionsReport) {
                        if (!report.areAllPermissionsGranted()) {
                            //Log.e("cs",("cs", "no permission 2")
                            val denied = report.deniedPermissionResponses
                            var perdenied  = ""
                            for(d in denied)
                            {
                                perdenied =  perdenied + (d.permissionName) + ","
                            }
                            Toast.makeText(
                                this@LoginActivity,
                                "Please Provide $perdenied permissions requested by the app",
                                Toast.LENGTH_LONG
                            ).show()
                            val intent = Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS)
                            val uri = Uri.fromParts("package", packageName, null)
                            intent.data = uri
                            startActivity(intent)
                        }
                        else
                        {
                            binding.btnLogin.isEnabled = true
                            binding.btnLoginScan.isEnabled = true
                        }
                    }
                    override fun onPermissionRationaleShouldBeShown(
                        permissions: List<PermissionRequest?>?,
                        token: PermissionToken?
                    ) {
                        token?.continuePermissionRequest()
                    }
                }).check()

        }

        binding.btnLogin.setOnClickListener {
            val username = binding.etEmail.text.toString()
            var password = binding.etPassword.text.toString()

            if (username.isEmpty()) {
                binding.etEmail.error = "Username can't be empty"
                binding.etEmail.requestFocus()
                return@setOnClickListener
            }
            if (password.isEmpty()) {
                binding.etPassword.error = "Password can't be empty"
                binding.etPassword.requestFocus()
                return@setOnClickListener
            }

            password = md5(password)

            showsnackbar(username, password)
        }

        binding.btnLoginScan.setOnClickListener {

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                Dexter.withContext(this@LoginActivity)
                    .withPermissions(
                        android.Manifest.permission.BLUETOOTH_CONNECT,
                        android.Manifest.permission.BLUETOOTH_SCAN,
                        android.Manifest.permission.CAMERA
                    ).withListener(object : MultiplePermissionsListener {
                        override fun onPermissionsChecked(report: MultiplePermissionsReport) {
                            if (!report.areAllPermissionsGranted()) {
                                //Log.e("cs",("cs", "no permission 1")
                                Toast.makeText(
                                    this@LoginActivity,
                                    "Please Provide all the permissions requested the app",
                                    Toast.LENGTH_LONG
                                ).show()
                                val intent = Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS)
                                val uri = Uri.fromParts("package", packageName, null)
                                intent.data = uri
                                startActivity(intent)
                            } else {
                                val dialog = Dialog(this@LoginActivity)

                                // set custom dialog

                                val barcodeScannerBinding =
                                    NewBarcodeScannerBinding.inflate(layoutInflater)
                                dialog.setContentView(barcodeScannerBinding.root)

                                // set custom height and width
                                dialog.window!!.setLayout(
                                    ViewGroup.LayoutParams.MATCH_PARENT,
                                    ViewGroup.LayoutParams.WRAP_CONTENT
                                )
                                // show dialog
                                dialog.show()

                                val scannerView: CodeScannerView = barcodeScannerBinding.scannerView
                                val mCodeScanner = CodeScanner(this@LoginActivity, scannerView)

                                mCodeScanner.camera =
                                    CodeScanner.CAMERA_BACK // or CAMERA_FRONT or specific camera id
                                mCodeScanner.formats =
                                    CodeScanner.ALL_FORMATS // list of type BarcodeFormat,
                                // ex. listOf(BarcodeFormat.QR_CODE)
                                mCodeScanner.autoFocusMode = AutoFocusMode.SAFE // or CONTINUOUS
                                mCodeScanner.scanMode = ScanMode.SINGLE // or CONTINUOUS or PREVIEW
                                mCodeScanner.isAutoFocusEnabled =
                                    true // Whether to enable auto focus or not
                                mCodeScanner.isFlashEnabled =
                                    false // Whether to enable flash or not

                                mCodeScanner.startPreview();
                                mCodeScanner.setDecodeCallback(DecodeCallback { result ->
                                    runOnUiThread {
                                        //  Toast.makeText(activity, result.text, Toast.LENGTH_LONG).show()
                                        val data = result.text /// add barcode to api call
                                        //homeViewModel.gettrolleydetails(trolleybarcode)
                                        //Get Data and go to login
                                        loginQR(data)
                                        dialog.dismiss()
                                    }
                                })
                                mCodeScanner.errorCallback =
                                    ErrorCallback { // or ErrorCallback.SUPPRESS
                                        runOnUiThread {
                                            Toast.makeText(
                                                applicationContext,
                                                "Camera initialization error: ${it.message}",
                                                Toast.LENGTH_LONG
                                            ).show()
                                            //Log.e("cs",("cs", "error =>${it.message}")
                                        }
                                    }
                                /* scannerView.setOnClickListener {
                                     mCodeScanner.startPreview()
                                 }*/

                                dialog.setOnDismissListener {
                                    mCodeScanner.releaseResources();
                                }
                            }

                        }

                        override fun onPermissionRationaleShouldBeShown(
                            permissions: List<PermissionRequest?>?,
                            token: PermissionToken?
                        ) {
                            token?.continuePermissionRequest()
                        }
                    }).check()

            } else {
                Dexter.withContext(this@LoginActivity)
                    .withPermissions(
                        android.Manifest.permission.BLUETOOTH,
                        android.Manifest.permission.BLUETOOTH_ADMIN,
                        android.Manifest.permission.CAMERA
                    ).withListener(object : MultiplePermissionsListener {
                        override fun onPermissionsChecked(report: MultiplePermissionsReport) {
                            if (!report.areAllPermissionsGranted()) {
                                //Log.e("cs",("cs", "no permission 2")
                                Toast.makeText(
                                    this@LoginActivity,
                                    "Please Provide all the permissions requested the app",
                                    Toast.LENGTH_LONG
                                ).show()
                                val intent = Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS)
                                val uri = Uri.fromParts("package", packageName, null)
                                intent.data = uri
                                startActivity(intent)
                            } else {
                                val dialog = Dialog(this@LoginActivity)

                                // set custom dialog

                                val barcodeScannerBinding =
                                    NewBarcodeScannerBinding.inflate(layoutInflater)
                                dialog.setContentView(barcodeScannerBinding.root)

                                // set custom height and width
                                dialog.window!!.setLayout(
                                    ViewGroup.LayoutParams.MATCH_PARENT,
                                    ViewGroup.LayoutParams.WRAP_CONTENT
                                )
                                // show dialog
                                dialog.show()

                                val scannerView: CodeScannerView = barcodeScannerBinding.scannerView
                                val mCodeScanner = CodeScanner(this@LoginActivity, scannerView)

                                mCodeScanner.camera =
                                    CodeScanner.CAMERA_BACK // or CAMERA_FRONT or specific camera id
                                mCodeScanner.formats =
                                    CodeScanner.ALL_FORMATS // list of type BarcodeFormat,
                                // ex. listOf(BarcodeFormat.QR_CODE)
                                mCodeScanner.autoFocusMode = AutoFocusMode.SAFE // or CONTINUOUS
                                mCodeScanner.scanMode = ScanMode.SINGLE // or CONTINUOUS or PREVIEW
                                mCodeScanner.isAutoFocusEnabled =
                                    true // Whether to enable auto focus or not
                                mCodeScanner.isFlashEnabled =
                                    false // Whether to enable flash or not

                                mCodeScanner.startPreview();
                                mCodeScanner.setDecodeCallback(DecodeCallback { result ->
                                    runOnUiThread {
                                        //  Toast.makeText(activity, result.text, Toast.LENGTH_LONG).show()
                                        val data = result.text /// add barcode to api call
                                        //homeViewModel.gettrolleydetails(trolleybarcode)
                                        //Get Data and go to login
                                        loginQR(data)
                                        dialog.dismiss()
                                    }
                                })
                                mCodeScanner.errorCallback =
                                    ErrorCallback { // or ErrorCallback.SUPPRESS
                                        runOnUiThread {
                                            Toast.makeText(
                                                applicationContext,
                                                "Camera initialization error: ${it.message}",
                                                Toast.LENGTH_LONG
                                            ).show()
                                            //Log.e("cs",("cs", "error =>${it.message}")
                                        }
                                    }
                                /* scannerView.setOnClickListener {
                                     mCodeScanner.startPreview()
                                 }*/

                                dialog.setOnDismissListener {
                                    mCodeScanner.releaseResources();
                                }
                            }
                        }

                        override fun onPermissionRationaleShouldBeShown(
                            permissions: List<PermissionRequest?>?,
                            token: PermissionToken?
                        ) {
                            token?.continuePermissionRequest()
                        }
                    }).check()

            }
        }
    }

    fun md5(input:String): String {
        val md = MessageDigest.getInstance("MD5")
        return BigInteger(1, md.digest(input.toByteArray())).toString(16).padStart(32, '0')
    }

    fun showsnackbar(username:String, password: String)
    {
        if(!isonline())
        {
            val snackbar = Snackbar
                .make(
                    binding.root,
                    "No internet connection! Please turn on the Internet.",
                    Snackbar.LENGTH_INDEFINITE
                )
                .setAction("Retry") { showsnackbar(username,password) }
            snackbar.setActionTextColor(Color.WHITE)
            val sbView: View = snackbar.getView()
            val params = sbView.layoutParams as FrameLayout.LayoutParams
            params.gravity = Gravity.BOTTOM
            sbView.layoutParams = params
            sbView.setBackgroundColor(resources.getColor(R.color.colorPrimary))
            val textView = sbView.findViewById<View>(com.google.android.material.R.id.snackbar_text) as TextView
            textView.setTextColor(Color.WHITE)
            snackbar.show()
        }
        else
        {
            binding.btnLogin.isEnabled = false
            fcm_token = settings!!.getString("fcm_token", "")!!
            /* if (fcm_token.isEmpty()) {
                 getfcm()
             }
             else*/
            login(username,password)
        }

    }

    fun isonline():Boolean
    {
        val cm = applicationContext.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        var isonline = false
        val n = cm.activeNetwork
        if (n != null) {
            val nc = cm.getNetworkCapabilities(n)
            //It will check for both wifi and cellular network
            isonline = nc!!.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR) || nc.hasTransport(
                NetworkCapabilities.TRANSPORT_WIFI)
        }
        return isonline

    }

    /*fun getfcm() {
        fcm_token = settings!!.getString("fcm_token", "")!!
        //Log.e("cs",("cs", "before getting fcm")
        //Log.e("cs",("cs", "before getting fcm22")

        //Log.e("cs",("cs", "before getting fcm3333")
        if (fcm_token.isEmpty()) {
            FirebaseMessaging.getInstance().token
                .addOnCompleteListener(OnCompleteListener { task ->
                    if (!task.isSuccessful) {
                        ////Log.e("cs",("cs", "Fetching FCM registration token failed", task.getException());
                        return@OnCompleteListener
                    }

                    // Get new FCM registration token
                    val token = task.result
                    if (token.length > 0) {
                        ////Log.e("cs",("cs", "fcm_token  11223344->" + fcm_token);
                        fcm_token = task.result
                        ////Log.e("cs",("cs", "fcm_token  11223355->" + fcm_token);
                        editor!!.putString("fcm_token", fcm_token).apply()
                    }


                    // Log and toast
                })
        }
        *//*   if (fcm_token.isEmpty()) {
               FirebaseInstallations.getInstance().getToken(true).addOnCompleteListener { task ->
                   if (task.result.token.length > 0) {
                       fcm_token = task.result.token
                       ////Log.e("cs",("cs","fcm token in new Firebase installations->"+fcm_token);
                       editor!!.putString("fcm_token", fcm_token).apply()
                   }
               }
           }*//*
        login(binding.etEmail.text.toString(),binding.etPassword.text.toString())
        //Log.e("cs",("cs", "after getting fcm")
    }
*/
    fun login(username:String,password:String)
    {

        val pDialog = ProgressDialog(this@LoginActivity)
        pDialog.setMessage("Checking Credentials..")
        pDialog.show()
        val security_token = "${Random.nextInt(999)} -${System.currentTimeMillis().toString()}"
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.login(
            username,password, device_id, security_token
        )

        Log.e("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                binding.btnLogin.isEnabled = true
                if (response.isSuccessful) {
                    binding.btnLogin.isEnabled = true
                    if (pDialog.isShowing) pDialog.dismiss()
                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);

                        val jsonArray = js.getJSONArray("item")
                        for (i in 0 until jsonArray.length()) {
                            val jsonObject = jsonArray.getJSONObject(i)
                            val result123 = jsonObject.getString("result")
                            if (pDialog.isShowing) pDialog.dismiss()
                            //Log.e("cs",("cs", "result123=>$result123")
                            if ((result123 == "1")) {
                                editor!!.putString("uname",jsonObject.getString("uname")).apply()
                                editor!!.putString("username",username).apply()
                                editor!!.putString("password",password).apply()
                                editor!!.putString("security_token",security_token).apply()
                                editor!!.putString("userdesignation",jsonObject.getString("userdesignation")).apply()
                                editor!!.putString("mobileno",jsonObject.getString("mobileno")).apply()
                                editor!!.putString("appversion",jsonObject.getString("appversion")).apply()
                                editor!!.putString("applink",jsonObject.getString("applink")).apply()
                                editor!!.putString("companymid",jsonObject.getString("companymid")).apply()
                                editor!!.putString("company_name",jsonObject.getString("company_name")).apply()
                                editor!!.putString("bdscale_name",jsonObject.getString("bdscale_name")).apply()
                                editor!!.putString("bdscale_mac",jsonObject.getString("bdscale_mac")).apply()
                                editor!!.putString("bdprint_name",jsonObject.getString("bdprint_name")).apply()
                                editor!!.putString("bdprint_mac",jsonObject.getString("bdprint_mac")).apply()
                                editor!!.putFloat("gst_rate",jsonObject.getString("gst_rate").toFloat()).apply()
                                editor!!.putBoolean("deleteItem",jsonObject.getInt("showDeleteChalanItems") > 0).apply()
                                editor!!.putBoolean("editPrice",jsonObject.getInt("ShowEditPrices") > 0).apply()
                                editor!!.putBoolean("editWeight",jsonObject.getInt("ShowManualWeightEdit") > 0).apply()
                                editor!!.putBoolean("chalanPic",jsonObject.getInt("showChalanPitures") > 0).apply()
                                editor!!.putBoolean("chalanswitchJobItemsCount",jsonObject.getInt("showItemAllowed") > 0).apply()
                                editor!!.putBoolean("chalanEdit",jsonObject.getInt("showEditCompletedChalan") > 0).apply()
                                editor!!.putBoolean("chalanReprint",jsonObject.getInt("showReprintChalan") > 0).apply()
                                editor!!.putBoolean("chalanReport",jsonObject.getInt("ShowReport") > 0).apply()
                                editor!!.putBoolean("showPrice",jsonObject.getInt("showPrices") > 0).apply()

                                val intent = Intent(applicationContext, HomeActivity::class.java)
                                intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
                                startActivity(intent)
                                finish()
                            } else {
                                Toast.makeText(this@LoginActivity,"Incorrect Username/Password, Please Try again",
                                    Toast.LENGTH_LONG).show()
                            }
                        }
                    } catch (e: IOException) {
                        if (pDialog.isShowing) pDialog.dismiss()
                        binding.btnLogin.isEnabled = true
                        Toast.makeText(this@LoginActivity,"There was some IOException, Please try again after some time.",
                            Toast.LENGTH_LONG).show()
                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        if (pDialog.isShowing) pDialog.dismiss()
                        binding.btnLogin.isEnabled = true
                        Toast.makeText(this@LoginActivity,"There was some Exception, Please try again after some time.",
                            Toast.LENGTH_LONG).show()
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    if (pDialog.isShowing) pDialog.dismiss()
                    binding.btnLogin.isEnabled = true
                    Toast.makeText(this@LoginActivity,"There was some Issue, Please try again after some time.",
                        Toast.LENGTH_LONG).show()
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                if (pDialog.isShowing) pDialog.dismiss()
                binding.btnLogin.isEnabled = true

                Toast.makeText(this@LoginActivity,t.cause.toString(),
                    Toast.LENGTH_LONG).show()
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    fun loginQR(passkey:String)
    {

        val pDialog = ProgressDialog(this@LoginActivity)
        pDialog.setMessage("Checking Credentials..")
        pDialog.show()
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.loginQR(
            passkey, device_id
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                binding.btnLoginScan.isEnabled = true
                if (response.isSuccessful) {
                    binding.btnLoginScan.isEnabled = true
                    if (pDialog.isShowing) pDialog.dismiss()
                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);

                        val jsonArray = js.getJSONArray("item")
                        for (i in 0 until jsonArray.length()) {
                            val jsonObject = jsonArray.getJSONObject(i)
                            val result123 = jsonObject.getString("result")
                            if (pDialog.isShowing) pDialog.dismiss()
                            //Log.e("cs",("cs", "result123=>$result123")
                            if ((result123 == "1")) {
                                editor!!.putString("uname",jsonObject.getString("uname")).apply()
                                editor!!.putString("username",jsonObject.getString("username1")).apply()
                                editor!!.putString("password",jsonObject.getString("userpwd1")).apply()
                                editor!!.putString("userdesignation",jsonObject.getString("userdesignation")).apply()
                                editor!!.putString("mobileno",jsonObject.getString("mobileno")).apply()
                                editor!!.putString("appversion",jsonObject.getString("appversion")).apply()
                                editor!!.putString("applink",jsonObject.getString("applink")).apply()
                                editor!!.putString("companymid",jsonObject.getString("companymid")).apply()
                                editor!!.putString("company_name",jsonObject.getString("company_name")).apply()
                                editor!!.putString("bdscale_name",jsonObject.getString("bdscale_name")).apply()
                                editor!!.putString("bdscale_mac",jsonObject.getString("bdscale_mac")).apply()
                                editor!!.putString("bdprint_name",jsonObject.getString("bdprint_name")).apply()
                                editor!!.putString("bdprint_mac",jsonObject.getString("bdprint_mac")).apply()
                                editor!!.putFloat("gst_rate",jsonObject.getString("gst_rate").toFloat()).apply()
                                if(jsonObject.getString("bdscale_mac").isEmpty() || jsonObject.getString("bdprint_mac").isEmpty())
                                {
                                    showdialog()
                                }
                                else
                                {
                                    val intent = Intent(applicationContext, HomeActivity::class.java)
                                    intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
                                    startActivity(intent)
                                    finish()
                                }
                            } else {
                                Toast.makeText(this@LoginActivity,"Incorrect Username/Password, Please Try again",
                                    Toast.LENGTH_LONG).show()
                            }
                        }
                    } catch (e: IOException) {
                        if (pDialog.isShowing) pDialog.dismiss()
                        binding.btnLoginScan.isEnabled = true
                        Toast.makeText(this@LoginActivity,"There was some IOException, Please try again after some time.",
                            Toast.LENGTH_LONG).show()
                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        if (pDialog.isShowing) pDialog.dismiss()
                        binding.btnLoginScan.isEnabled = true
                        Toast.makeText(this@LoginActivity,"There was some Exception, Please try again after some time.",
                            Toast.LENGTH_LONG).show()
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    if (pDialog.isShowing) pDialog.dismiss()
                    binding.btnLoginScan.isEnabled = true
                    Toast.makeText(this@LoginActivity,"There was some Issue, Please try again after some time.",
                        Toast.LENGTH_LONG).show()
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                if (pDialog.isShowing) pDialog.dismiss()
                binding.btnLoginScan.isEnabled = true

                Toast.makeText(this@LoginActivity,t.cause.toString(),
                    Toast.LENGTH_LONG).show()
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    fun showdialog()
    {
        val builder = AlertDialog.Builder(this)
        builder.setTitle("Scale And/Or Print Mac Address Not Found")
        builder.setMessage("Please ask Admin to assign the Scale and Print OR if you have settings Password then select the devices from it.")
//builder.setPositiveButton("OK", DialogInterface.OnClickListener(function = x))

        builder.setPositiveButton("Enter App") { dialog, which ->
            val intent = Intent(applicationContext, HomeActivity::class.java)
            intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
            startActivity(intent)
            finish()
        }

        builder.setNegativeButton("Exit App") { dialog, which ->
            finish()
        }


        builder.show()
    }

}