package com.at.isv

import android.annotation.SuppressLint
import android.app.Application
import android.bluetooth.BluetoothDevice
import android.bluetooth.BluetoothSocket
import android.text.SpannableStringBuilder
import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.at.isv.ApiConfig
import com.at.isv.AppConfig
import com.at.isv.ConstantValues
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.channels.BufferOverflow
import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.buffer
import kotlinx.coroutines.flow.flow
import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.ByteArrayInputStream
import java.io.IOException
import java.math.RoundingMode
import java.text.DecimalFormat
import java.util.*
import javax.inject.Inject
import kotlin.collections.ArrayDeque

@HiltViewModel
class HomeActivityViewModel @Inject constructor(application: Application): ViewModel() {

    private var _isPasswordCor = MutableLiveData<Boolean>()
    val isPasswordCor: LiveData<Boolean> = _isPasswordCor


    private var _isLoading = MutableLiveData<Boolean>()
    val isLoading: LiveData<Boolean> = _isLoading

    private var _errormsg = MutableLiveData<String>()
    val errormsg: LiveData<String> = _errormsg

    private var _bdType = MutableLiveData<String>()
    val bdType: LiveData<String> = _bdType

    private var _bdWeightName = MutableLiveData<String>()
    val bdWeightName: LiveData<String> = _bdWeightName

    private var _bdPrintName = MutableLiveData<String>()
    val bdPrintName: LiveData<String> = _bdPrintName


    private var _chalanReport = MutableLiveData<Boolean>()
    val chalanReport: LiveData<Boolean> = _chalanReport


    var username:String = ""
    var password:String = ""

    init {
        _isLoading.value = true
        _errormsg.value = ""
        username = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("username","").toString()
        password = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("password","").toString()
        _chalanReport.value = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getBoolean("chalanReport",false)
    }

    fun setBDType(type:String)
    {
        _bdType.value = type
    }


    fun setBDName(type:String,name:String)
    {
        //Log.e("cs",("cs","setBDType :: "+type + "   Name :: "+name )
        if(type.equals("1"))
            _bdWeightName.value = name
        else if(type.equals("2"))
            _bdPrintName.value = name
    }


    public fun checkPass(setPass:String)
    {
        _isLoading.value = true

        _isPasswordCor.value = false
        _errormsg.value = ""

        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.CheckSettingsPassword(
            username,password,setPass
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);

                        val jsonArray = js.getJSONArray("item")
                        for (i in 0 until jsonArray.length()) {
                            val jsonObject = jsonArray.getJSONObject(i)
                            val result123 = jsonObject.getString("result")
                            //Log.e("cs",("cs", "result123=>$result123")
                            if ((result123 == "1")) {
                                _isPasswordCor.value = true
                            } else {
                                _errormsg.value = jsonObject.getString("message")
                            }
                        }
                    } catch (e: IOException) {
                        _isLoading.value = false
                        _errormsg.value = "IO Exception"
                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        _errormsg.value = "JSON Exception"
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    public fun setChalanReport(creport:Boolean)
    {
        _chalanReport.value = creport
    }


}