package com.at.isv

import android.annotation.SuppressLint
import android.app.Dialog
import android.bluetooth.BluetoothAdapter
import android.bluetooth.BluetoothDevice
import android.bluetooth.BluetoothManager
import android.bluetooth.BluetoothSocket
import android.content.*
import android.content.pm.PackageInfo
import android.content.pm.PackageManager
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.os.CountDownTimer
import android.provider.MediaStore
import android.util.Log
import android.view.Menu
import android.view.MenuItem
import android.view.View
import android.view.ViewGroup
import android.widget.AdapterView
import android.widget.EditText
import android.widget.ImageView
import android.widget.ProgressBar
import android.widget.TextView
import android.widget.Toast
import androidx.activity.addCallback
import androidx.activity.result.ActivityResult
import androidx.activity.result.ActivityResultCallback
import androidx.activity.result.contract.ActivityResultContracts
import androidx.activity.viewModels
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.AppCompatButton
import androidx.core.app.ActivityCompat
import androidx.core.view.GravityCompat
import androidx.drawerlayout.widget.DrawerLayout
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.lifecycleScope
import androidx.navigation.NavController
import androidx.navigation.findNavController
import androidx.navigation.ui.AppBarConfiguration
import androidx.navigation.ui.navigateUp
import androidx.navigation.ui.setupActionBarWithNavController
import androidx.navigation.ui.setupWithNavController
import com.at.isv.ConstantValues.PREFS_NAME
import com.at.isv.databinding.ActivityHomeBinding
import com.at.isv.databinding.GetBluetoothBinding
import com.at.isv.ui.slideshow.SlideshowViewModel
import com.google.android.material.navigation.NavigationView
import com.google.android.material.snackbar.Snackbar
import com.karumi.dexter.Dexter
import com.karumi.dexter.MultiplePermissionsReport
import com.karumi.dexter.PermissionToken
import com.karumi.dexter.listener.PermissionRequest
import com.karumi.dexter.listener.multi.MultiplePermissionsListener
import com.mazenrashed.printooth.Printooth
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.collectLatest
import kotlinx.coroutines.launch
import java.io.ByteArrayOutputStream
import java.io.FileOutputStream
import java.io.IOException
import java.util.*
import kotlin.system.exitProcess

@AndroidEntryPoint
class HomeActivity : AppCompatActivity() {

    private lateinit var appBarConfiguration: AppBarConfiguration
    private lateinit var binding: ActivityHomeBinding

    var settings: SharedPreferences? = null
    var editor: SharedPreferences.Editor? = null

    var mutableListString: MutableList<String> = mutableListOf<String>()
    var pairedadrslist: MutableList<String> = mutableListOf<String>()
    var typelist: MutableList<String> = mutableListOf<String>()
    var bluetoothdevicelist: MutableList<BluetoothDevice> = mutableListOf<BluetoothDevice>()

    lateinit var bluetoothBinding : GetBluetoothBinding
    lateinit var bluetoothAdapter: BluetoothAdapter
    var connectedbluetoothdevice: BluetoothDevice? = null
    var weightBluetoothDevice: BluetoothDevice? = null

    var type:String = "Weight"
    var time_inactivity:Long = 1000*60*20
    var is_reading = false
    lateinit var newsocket: BluetoothSocket
    var retry = 0
    private val MY_UUID: UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB")

   // private val mymainviewmodel : MainViewModel by viewModels()

    lateinit var navController: NavController
    lateinit var drawerLayout: DrawerLayout
    var doubleBackToExitPressedOnce = false

    var timer: CountDownTimer? = null

    var NoOfTrolleies = 0

    var blueToothDialog:Dialog? = null

    var logout = false

    private val homeViewModel : HomeActivityViewModel by viewModels()

    lateinit var dialog:Dialog

    var pbDialog:ProgressBar? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        binding = ActivityHomeBinding.inflate(layoutInflater)
        setContentView(binding.root)


        setSupportActionBar(binding.appBarHome.toolbar)


         drawerLayout = binding.drawerLayout
        val navView: NavigationView = binding.navView
         navController = findNavController(R.id.nav_host_fragment_content_home)
        // Passing each menu ID as a set of Ids because each
        // menu should be considered as top level destinations.
        appBarConfiguration = AppBarConfiguration(
            setOf(
                R.id.nav_home, R.id.nav_gallery, R.id.nav_slideshow
            ), drawerLayout
        )


        setupActionBarWithNavController(navController, appBarConfiguration)
        navView.setupWithNavController(navController)
        binding.appBarHome.tvweightName.visibility = View.GONE


        navController.addOnDestinationChangedListener(
            NavController.OnDestinationChangedListener
            { controller, destination, arguments ->
                // react on change
                // you can check destination.id or destination.label and act based on that

                binding.appBarHome.tvfname.text = destination.label.toString()

               /* if(controller.currentDestination?.id  == R.id.nav_home)
                {
                    binding.appBarHome.tvweightName.visibility = View.VISIBLE
                }
                else
                {
                    binding.appBarHome.tvweightName.visibility = View.GONE
                }*/
            })
        //timer2.start()


        binding.appBarHome.ivnav2.setOnClickListener{
            if(drawerLayout.isOpen)
                drawerLayout.close()
            else
                drawerLayout.open()
        }

        var pInfo: PackageInfo? = null
        try {
            pInfo = applicationContext.packageManager.getPackageInfo(packageName, 0)
        } catch (e: PackageManager.NameNotFoundException) {
            e.printStackTrace()
        }
        val version = pInfo!!.versionCode
        val versionStr = pInfo.versionName

        binding.navAppversion.text = "App Version: $versionStr"

        settings = getSharedPreferences(PREFS_NAME,0)
        editor = settings!!.edit()

        val appversion: String = settings!!.getString("appversion", "0").toString()

        val myver = appversion.toInt()
        val urllink: String = settings!!.getString("applink", "").toString()
        bluetoothBinding = GetBluetoothBinding.inflate(layoutInflater)
        if (myver > version) {
            val builder = AlertDialog.Builder(this)
            builder.setMessage("Please update the app , otherwise you won't able to use the app.")
                .setTitle("App Update")
                .setCancelable(false)
                .setPositiveButton("Ok") { dialog, id ->
                    startActivity(
                        Intent(
                            Intent.ACTION_VIEW,
                            Uri.parse(urllink)
                        )
                    )
                }
                .setNegativeButton("Exit App") { dialog, id -> //  Action for 'NO' Button
                    exitProcess(0)
                }
            //Creating dialog box
            val alert = builder.create()
            //Setting the title manually
            alert.setCanceledOnTouchOutside(false)
            alert.show()
        }

        homeViewModel.chalanReport.observe(this){
            navView.menu.findItem(R.id.nav_report).setVisible(it)
        }

        //./gradlew --stop for stopping the gradle issues

        val hview = binding.navView.getHeaderView(0)

        val hviewname: TextView = hview.findViewById(R.id.tvname)
        val hviewemail: TextView = hview.findViewById(R.id.tvemail)

        hviewname.text = settings!!.getString("username","I Wash")
        hviewemail.text = settings!!.getString("mobileno","App")

        binding.appBarHome.tvname.text =  settings!!.getString("username","Name")
        binding.appBarHome.tvlocation.text =  settings!!.getString("company_name","I Wash")

      /*  binding.appBarHome.tvweightName.setOnClickListener{
            type = "Weight"
            getbluetooth()
        }*/

        homeViewModel.bdType.observe(this){
            type = it
            getbluetooth()
        }

        navView.setNavigationItemSelectedListener(object : NavigationView.OnNavigationItemSelectedListener{
            override fun onNavigationItemSelected(item: MenuItem): Boolean {
                val id = item.itemId
                drawerLayout.closeDrawer(GravityCompat.START);
                if (id == R.id.nav_logout) {

                        editor!!.remove("uname").apply()
                        editor!!.remove("username").apply()
                        editor!!.remove("password").apply()
                        editor!!.remove("userdesignation").apply()
                        editor!!.remove("mobileno").apply()
                        editor?.remove("pref_id")?.apply()
                        editor?.remove("pref_hotel_id")?.apply()
                        /*editor?.clear()?.commit()
                        editor?.clear()?.apply()*/
                        val intent = Intent(applicationContext, LoginActivity::class.java)
                        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
                        startActivity(intent)
                        finish()


                }
                else if(id == R.id.nav_settings)
                {

                     dialog = Dialog(this@HomeActivity)

                    // set custom dialog
                    dialog.setContentView(R.layout.custom_dialog)

                    // set custom height and width
                    dialog.window!!.setLayout(
                        ViewGroup.LayoutParams.MATCH_PARENT,
                        ViewGroup.LayoutParams.WRAP_CONTENT
                    )
                    // show dialog
                    dialog.show()

                    val etSettingsPassword = dialog.findViewById<EditText>(R.id.edit_text)
                    val btnCheckPassword = dialog.findViewById<AppCompatButton>(R.id.btnCheckPassword)
                    val ivClose = dialog.findViewById<ImageView>(R.id.ivClose)
                     pbDialog = dialog.findViewById<ProgressBar>(R.id.pbDialog)

                    ivClose.setOnClickListener {
                        dialog.dismiss()
                    }

                    btnCheckPassword.setOnClickListener {
                        val settingsPassword = etSettingsPassword.text.toString().trim()
                        if(settingsPassword.isEmpty())
                        {
                            etSettingsPassword.error = "Password can't be empty"
                            etSettingsPassword.requestFocus()
                            return@setOnClickListener
                        }
                        homeViewModel.checkPass(settingsPassword)
                    }
                }
                else{
                    if (id != 0) navController.navigate(id)
                }
                return true
            }
        })

        var filter = IntentFilter(BluetoothDevice.ACTION_FOUND)
        registerReceiver(receiver, filter)
        filter = IntentFilter(BluetoothAdapter.ACTION_DISCOVERY_STARTED)
        registerReceiver(receiver, filter)
        filter = IntentFilter(BluetoothAdapter.ACTION_DISCOVERY_FINISHED)
        registerReceiver(receiver, filter)
        filter.addAction(BluetoothDevice.ACTION_ACL_CONNECTED)
        registerReceiver(receiver, filter)
        filter.addAction(BluetoothDevice.ACTION_ACL_DISCONNECTED)
        registerReceiver(receiver, filter)
        filter.addAction(BluetoothAdapter.ACTION_STATE_CHANGED)
        registerReceiver(receiver, filter)

        val bluetoothManager: BluetoothManager = getSystemService(BluetoothManager::class.java)
        bluetoothAdapter = bluetoothManager.getAdapter()

       /* mymainviewmodel.bdType.observe(this){
            type = it
            getbluetooth()
        }*/

        homeViewModel.isLoading.observe(this){
            if(it)
                pbDialog?.visibility = View.VISIBLE
            else
                pbDialog?.visibility = View.GONE
        }


        homeViewModel.isPasswordCor.observe(this){
            if(it)
            {
                dialog.dismiss()
                navController.navigate(R.id.nav_settings)
            }
        }



        homeViewModel.errormsg.observe(this){
            if(it.isNotEmpty())
                Toast.makeText(applicationContext,it,Toast.LENGTH_SHORT).show()
        }

    }

    override fun onResume() {
        super.onResume()

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            Dexter.withContext(this@HomeActivity)
                .withPermissions(
                    android.Manifest.permission.BLUETOOTH_CONNECT,
                    android.Manifest.permission.BLUETOOTH_SCAN
                ).withListener(object : MultiplePermissionsListener {
                    override fun onPermissionsChecked(report: MultiplePermissionsReport) {
                        if(!report.areAllPermissionsGranted())
                        {
                            //Log.e("cs",("cs","no permission 1")
                            Toast.makeText(this@HomeActivity,"You need bluetooth permissions to get the weight of the trolley",
                                Toast.LENGTH_LONG).show()
                            return
                        }
                        else
                        {
                            if (bluetoothAdapter.isEnabled == false) {
                                // Toast.makeText(this@HomeActivity,"Please enable Bluetooth",Toast.LENGTH_LONG).show()
                                val enableBtIntent = Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE)
                                if (ActivityCompat.checkSelfPermission(
                                        this@HomeActivity,
                                        android.Manifest.permission.BLUETOOTH_CONNECT
                                    ) != PackageManager.PERMISSION_GRANTED
                                ) {
                                    return
                                }
                                startForResult.launch(enableBtIntent)
                            }
                            else
                            {
                                //Log.e("cs",("cs","check for default 1")
                               // check_for_default()
                            }
                        }

                    }
                    override fun onPermissionRationaleShouldBeShown(
                        permissions: List<PermissionRequest?>?,
                        token: PermissionToken?
                    ) {
                        token?.continuePermissionRequest()
                    }
                }).check()

        } else {
            Dexter.withContext(this@HomeActivity)
                .withPermissions(
                    android.Manifest.permission.BLUETOOTH,
                    android.Manifest.permission.BLUETOOTH_ADMIN,
                    android.Manifest.permission.ACCESS_FINE_LOCATION,
                    android.Manifest.permission.ACCESS_COARSE_LOCATION
                ).withListener(object : MultiplePermissionsListener {
                    override fun onPermissionsChecked(report: MultiplePermissionsReport) {
                        if(!report.areAllPermissionsGranted())
                        {
                            //Log.e("cs",("cs","no permission 2")
                            Toast.makeText(this@HomeActivity,"You need bluetooth/bluetooth admin permissions to get the weight of the trolley",
                                Toast.LENGTH_LONG).show()
                            return
                        }
                        else
                        {
                            //Log.e("cs",("cs","permission 2")
                            if (bluetoothAdapter.isEnabled == false) {
                                // Toast.makeText(this@HomeActivity,"Please enable Bluetooth",Toast.LENGTH_LONG).show()
                                val enableBtIntent = Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE)
                                if (ActivityCompat.checkSelfPermission(
                                        this@HomeActivity,
                                        android.Manifest.permission.BLUETOOTH
                                    ) != PackageManager.PERMISSION_GRANTED
                                ) {
                                    return
                                }
                                startForResult.launch(enableBtIntent)
                            }
                            else
                            {
                                //Log.e("cs",("cs","check for default 2")
                              //  check_for_default()
                            }
                        }
                    }

                    override fun onPermissionRationaleShouldBeShown(
                        permissions: List<PermissionRequest?>?,
                        token: PermissionToken?
                    ) {
                        token?.continuePermissionRequest()
                    }
                }).check()
        }


        onBackPressedDispatcher.addCallback(this) {
            if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
                drawerLayout.closeDrawer(GravityCompat.START);
            }
            else {
                if (!navController.navigateUp()) {
                    if (doubleBackToExitPressedOnce) {
                        //////Log.e("cs",("cs","doubleBackToExitPressedOnce true");
                        finish()
                    } else {

                        doubleBackToExitPressedOnce = true
                        Toast.makeText(
                            applicationContext,
                            "Please click BACK again to exit",
                            Toast.LENGTH_SHORT
                        ).show()
                        lifecycleScope.launch(Dispatchers.IO) {
                            delay(2000L)
                            doubleBackToExitPressedOnce = false
                        }
                    }
                }
            }
        }

      /*  lifecycleScope.launch {

            connectedbluetoothdevice?.let {
                mymainviewmodel.ConnectCoroutine(it).latestGrossWeight
                    .collectLatest{ grossweight ->
                        // Update View with the latest favorite news
                        //Log.e("cs",("cs","in main flow getting weight value=>"+grossweight)
                    }
            }
        }*/

    }

   /* lateinit var snackBar:Snackbar

    fun showsnackbar()
    {
        snackBar = Snackbar.make(
            binding.root, "There is still Unsubmitted Job in Add Job Work, This job will be cancelled on Logout.",
            Snackbar.LENGTH_INDEFINITE
        ).setAction("Go TO Add Job", object : View.OnClickListener{
            override fun onClick(v: View?) {
                navController.navigate(R.id.nav_slideshow)
            }

        })
            .setActionTextColor(Color.BLUE)
        val snackBarView = snackBar.view
        snackBarView.setBackgroundColor(Color.CYAN)
        val textView = snackBarView.findViewById(com.google.android.material.R.id.snackbar_text) as TextView
        textView.setTextColor(Color.BLUE)
        snackBar.show()
    }

    fun cancelsnackbar()
    {
        if(this@HomeActivity::snackBar.isInitialized && snackBar.isShown)
            snackBar.dismiss()
    }*/

    override fun onDestroy() {
        super.onDestroy()
        unregisterReceiver(receiver)
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        // Inflate the menu; this adds items to the action bar if it is present.
        menuInflater.inflate(R.menu.home, menu)
        return true
    }

    override fun onSupportNavigateUp(): Boolean {
        val navController = findNavController(R.id.nav_host_fragment_content_home)
        return navController.navigateUp(appBarConfiguration) || super.onSupportNavigateUp()
    }



    private val receiver = object : BroadcastReceiver() {
        @SuppressLint("MissingPermission")
        override fun onReceive(context: Context, intent: Intent) {
            Log.d("DISCOVERING-DEVICE 1", intent.data.toString())
            when (intent.action) {
                BluetoothDevice.ACTION_FOUND -> {
                    Log.d("DISCOVERING-DEVICE 2", "Action Found")
                    // Discovery has found a device. Get the BluetoothDevice
                    // object and its info from the Intent.
                    val device: BluetoothDevice =
                        intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE)!!
                    var deviceName = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S && ActivityCompat.checkSelfPermission(
                            this@HomeActivity,
                            android.Manifest.permission.BLUETOOTH_SCAN
                        ) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(
                            this@HomeActivity,
                            android.Manifest.permission.BLUETOOTH_CONNECT
                        ) != PackageManager.PERMISSION_GRANTED
                    ) {
                        Log.d("DISCOVERING-DEVICE 3", "Connect permission not granted")

                        return
                    }
                    else {
                        Log.d("DISCOVERING-DEVICE 4", "Connect permission granted")
                        device.name
                    }

                    val deviceHardwareAddress = device.address // MAC address
                    if(deviceName == null)
                        deviceName = deviceHardwareAddress
                    if(!pairedadrslist.contains(deviceHardwareAddress))
                    {
                        bluetoothdevicelist.add(device)
                        typelist.add("Scanned")
                        mutableListString.add(deviceName)
                        pairedadrslist.add(deviceHardwareAddress)
                        //Log.e("cs",("cs","device=>"+deviceName)

                    }

                    if(this@HomeActivity::bluetoothBinding.isInitialized)
                    {
                        val arrayAdapter = ListAdapter(this@HomeActivity,mutableListString,pairedadrslist,typelist)
                        bluetoothBinding.listview.adapter = arrayAdapter
                    }

                }
                BluetoothDevice.ACTION_ACL_CONNECTED -> {
                    //Log.e("cs",("cs","device connected=>")
                }
                BluetoothDevice.ACTION_ACL_DISCONNECTED -> {
                  /*  if(is_reading)
                    {
                        val device: BluetoothDevice =
                            intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE)!!
                        val printer_device_name = settings?.getString("bdprint_name","Select").toString()
                        val weight_device_name = settings?.getString("bdscale_name","Select").toString()
                        if(device.name.equals(weight_device_name) && weightBluetoothDevice!=null)
                        {
                            connectedbluetoothdevice  = weightBluetoothDevice
                            connectedbluetoothdevice?.let { mymainviewmodel.setbdevice(it) }
                            //connectedbluetoothdevice?.let { ConnectThread(it).start() };
                        }
                        else
                            check_for_default()
                    }*/
                    //Log.e("cs",("cs","device disconnected=>")
                }
                BluetoothAdapter.ACTION_DISCOVERY_STARTED -> {

                    Log.d("DISCOVERING-STARTED", "isDiscovering")
                }
                BluetoothAdapter.ACTION_DISCOVERY_FINISHED -> {

                    Log.d("DISCOVERING-FINISHED", "FinishedDiscovering")
                }
                BluetoothAdapter.ACTION_STATE_CHANGED -> {

                    when(intent.getIntExtra(BluetoothAdapter.EXTRA_STATE, BluetoothAdapter.ERROR)) {
                        BluetoothAdapter.STATE_OFF -> {
                            //Log.e("cs",("cs","bluetooth is off in main activity=>")
                            val snackbar = Snackbar
                                .make(binding.root, "BlueTooth is needed for working of the app", Snackbar.LENGTH_INDEFINITE)
                                .setAction("Ok")
                                {
                                    val enableBtIntent = Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE)
                                    startForResult.launch(enableBtIntent)
                                }
                            snackbar.show()
                        }
                        BluetoothAdapter.STATE_ON -> {
                            //Log.e("cs",("cs","bluetooth is on=>")
                        }
                    }
                }
            }
        }
    }

    @SuppressLint("MissingPermission")
    public fun getbluetooth()
    {
        bluetoothdevicelist.clear()
        mutableListString.clear()
        pairedadrslist.clear()
        typelist.clear()
        //Log.e("cs",("cs"," getbluetooth 0=>")
        if (bluetoothAdapter.isEnabled == false) {
            //Log.e("cs",("cs"," getbluetooth 01=>")
            // Toast.makeText(this@HomeActivity,"Please enable Bluetooth",Toast.LENGTH_LONG).show()
            val enableBtIntent = Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE)
            startForResult.launch(enableBtIntent)
        }
        else {
            //Log.e("cs",("cs"," getbluetooth 02=>")
            // tvblutooth.visibility = View.GONE
            val dialog1 = Dialog(this@HomeActivity)
            bluetoothBinding = GetBluetoothBinding.inflate(layoutInflater)
            dialog1.setContentView(bluetoothBinding.root)

            // set custom height and width
            dialog1.window!!.setLayout(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT
            )
            // show dialog
            dialog1.show()
            if(type.equals("Weight"))
            {
                bluetoothBinding.tvblutooth.setText("Scanning for Weight Device")
            }
            else
            {
                bluetoothBinding.tvblutooth.setText("Scanning for Printer")
            }
            //Log.e("cs",("cs"," getbluetooth 03=>")
            getpaireddata()
            if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.S)
            {
                //Log.e("cs",("cs"," getbluetooth 031=>")
                if (ActivityCompat.checkSelfPermission(
                        this@HomeActivity,
                        android.Manifest.permission.BLUETOOTH_SCAN
                    ) != PackageManager.PERMISSION_GRANTED
                ) {
                    //Log.e("cs",("cs"," getbluetooth 032=>")
                    return
                }
            }
            //Log.e("cs",("cs"," getbluetooth 04=>")
            bluetoothAdapter.startDiscovery()
            //Log.e("cs",("cs"," getbluetooth 05=>")

            Thread(Runnable {
                //Log.e("cs",("cs"," getbluetooth 05 Thread=>")
                Thread.sleep(40000)
                bluetoothAdapter.cancelDiscovery()
                runOnUiThread {
                    bluetoothBinding.pb.visibility = View.GONE
                }
            }).start()
            //Log.e("cs",("cs"," getbluetooth 06=>")

            bluetoothBinding.listview.setOnItemClickListener(object : AdapterView.OnItemClickListener {
                override fun onItemClick(p0: AdapterView<*>?, p1: View?, p2: Int, p3: Long) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S && ActivityCompat.checkSelfPermission(
                            this@HomeActivity,
                            android.Manifest.permission.BLUETOOTH_CONNECT
                        ) != PackageManager.PERMISSION_GRANTED
                    ) {

                        return
                    }
                    //Log.e("cs",("cs","connect permission is there 1")
                    connectedbluetoothdevice = bluetoothdevicelist.get(p2)

                    bluetoothBinding.lldevices.visibility = View.GONE

                    bluetoothBinding.llbtns.visibility = View.GONE
                    bluetoothBinding.btnstop.visibility = View.VISIBLE
                    // LocalBroadcastManager.getInstance(this@HomeActivity).sendBroadcast(Intent("showtext"))
                    dialog1.dismiss()
                    checkDefault()
                }
            } )
        }
    }


    @SuppressLint("MissingPermission")
    public fun checkDefault()
    {
        //Log.e("cs",("cs","connect permission is there 1.1")
        val alertDialogBuilder = AlertDialog.Builder(this@HomeActivity)
        //Log.e("cs",("cs","connect permission is there 2")
        var text= "weight tracking"
        if(type.equals("Printer"))
        {
            text = "printer"
        }
        alertDialogBuilder.setMessage("Are you sure you want to make  ${connectedbluetoothdevice?.name} default device for $text?")
        alertDialogBuilder.setPositiveButton("Yes", DialogInterface.OnClickListener { dialog, which ->
            //TODO : commit in sharedpref editor and check for it when connecting
            //TODO : also make same alert dia//Log.e("cs", for scanned device
            if(type.equals("Printer"))
            {
                Printooth.setPrinter(
                    connectedbluetoothdevice?.name,
                    connectedbluetoothdevice?.address.toString()
                )
                editor?.putString("bdprint_name",connectedbluetoothdevice?.name)?.apply()
                editor?.putString("bdprint_mac",connectedbluetoothdevice?.address)?.apply()
                homeViewModel.setBDName("2", connectedbluetoothdevice?.name.toString())
            }
            else
            {
                editor?.putString("bdscale_mac",connectedbluetoothdevice?.address)?.apply()
                editor?.putString("bdscale_name",connectedbluetoothdevice?.name)?.apply()
                //binding.appBarHome.tvweightName.text = connectedbluetoothdevice?.name
                homeViewModel.setBDName("1", connectedbluetoothdevice?.name.toString())
                //  connectedbluetoothdevice?.let { homeViewModel.setbdevice(it) }
            }
            dialog.dismiss()
        })
        alertDialogBuilder.setNegativeButton("No", DialogInterface.OnClickListener { dialog, which ->
            dialog.dismiss()

        })

        val alert: AlertDialog = alertDialogBuilder.create()
        alert.setTitle(" Make ${connectedbluetoothdevice?.name} default device?")
        alert.show()

      /*  alert.setOnDismissListener {
            if(type.equals("Weight"))
            {
                if (!Printooth.hasPairedPrinter())
                {
                    type = "Printer"
                    getbluetooth()
                }
            }

            *//*  startActivityForResult(Intent(this@HomeActivity,
                  ScanningActivity::class.java),
                  ScanningActivity.SCANNING_FOR_PRINTER)*//*
        }*/
    }

    /*public fun connecttoremtedevice()
    {
        //Log.e("cs",("cs","checking for bluetooth weight device")
        val bluetoothManager: BluetoothManager = getSystemService(BluetoothManager::class.java)
        bluetoothAdapter = bluetoothManager.getAdapter()

        val default_device = settings?.getString("bdscale_mac","0");
        connectedbluetoothdevice = bluetoothAdapter.getRemoteDevice(default_device)
        weightBluetoothDevice = bluetoothAdapter.getRemoteDevice(default_device)
        connectedbluetoothdevice?.let { mymainviewmodel.setbdevice(it) }
        if(connectedbluetoothdevice == null)
            check_for_default()
    }*/

    @SuppressLint("MissingPermission")
    public fun check_for_default()
    {
        bluetoothdevicelist.clear()
        mutableListString.clear()
        pairedadrslist.clear()
        typelist.clear()
        val bluetoothManager: BluetoothManager = getSystemService(BluetoothManager::class.java)
        bluetoothAdapter = bluetoothManager.getAdapter()

        //Log.e("cs",("cs","checking for default 00")
        lateinit var pairedDevices: Set<BluetoothDevice>
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.S)
        {
            pairedDevices= if (ActivityCompat.checkSelfPermission(
                    this@HomeActivity,
                    android.Manifest.permission.BLUETOOTH_CONNECT
                ) != PackageManager.PERMISSION_GRANTED
            ) {
                return
            }
            else
                bluetoothAdapter.bondedDevices
        }
        else
        {
            //Log.e("cs",("cs","checking for default 10")
            pairedDevices = bluetoothAdapter.bondedDevices
            //Log.e("cs",("cs","checking for default 1011=>"+pairedDevices.size)
        }

        //Log.e("cs",("cs","checking for default 11")

        val default_device = settings?.getString("bdscale_mac","0");
        val default_printer_device_name = settings?.getString("bdprint_name","Select");

        //Log.e("cs",("cs","default_device=>"+default_device)
        //Log.e("cs",("cs","default_printer_device_name=>"+default_printer_device_name)

        if(default_device.equals("0"))
        {
            run lit@{
                pairedDevices?.forEach { device ->
                    val deviceName = device.name
                    val deviceHardwareAddress = device.address // MAC address
                    if (default_device == deviceHardwareAddress && type.equals("Weight")) {
                        //Log.e("cs",("cs","checking for default 2=>"+deviceName)
                        connectedbluetoothdevice = device
                        editor?.putString("bdscale_name",connectedbluetoothdevice?.name)?.apply()
                        editor?.putString("bdscale_mac",connectedbluetoothdevice?.address)?.apply()
                      /*  binding.appBarHome.tvweightName.text = connectedbluetoothdevice?.name
                        connectedbluetoothdevice?.let { mymainviewmodel.setbdevice(it) }*/
                    }
                }
            }
            //Log.e("cs",("cs","connectedbluetoothdevice=>"+connectedbluetoothdevice)
            if(connectedbluetoothdevice == null) {
                //Log.e("cs",("cs"," in weight bluetooth=>"+connectedbluetoothdevice)
                type = "Weight"
                getbluetooth()
            }
            else
            {
                //Log.e("cs",("cs"," in printer bluetooth=>"+connectedbluetoothdevice)
                if(!Printooth.hasPairedPrinter())
                {
                    //Log.e("cs",("cs"," in printer bluetooth 2=>"+connectedbluetoothdevice)
                    type = "Printer"
                    getbluetooth()
                }
            }
        }
        else if(!Printooth.hasPairedPrinter())
        {
            //Log.e("cs",("cs"," in printer bluetooth 3=>"+connectedbluetoothdevice)
            type = "Printer"
            getbluetooth()
        }

    }

    @SuppressLint("MissingPermission")
    fun getpaireddata()
    {
        //Log.e("cs",("cs"," getpaireddata 00=>")
        // binding.tvbluetooth.visibility = View.GONE
        lateinit var pairedDevices: Set<BluetoothDevice>
        if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.S)
        {
            //Log.e("cs",("cs","checking for default 00011")
            pairedDevices= if (ActivityCompat.checkSelfPermission(
                    this@HomeActivity,
                    android.Manifest.permission.BLUETOOTH_CONNECT
                ) != PackageManager.PERMISSION_GRANTED
            ) {
                return
            }
            else
                bluetoothAdapter.bondedDevices
        }
        else
        {
            //Log.e("cs",("cs","checking for default 10")
            pairedDevices = bluetoothAdapter.bondedDevices
            //Log.e("cs",("cs","checking for default 1011=>"+pairedDevices.size)
        }
        //Log.e("cs",("cs"," getpaireddata 01=>")
        pairedDevices?.forEach { device ->
            val deviceName = device.name
            val deviceHardwareAddress = device.address // MAC address
            mutableListString.add(deviceName)
            pairedadrslist.add(deviceHardwareAddress)
            typelist.add("Paired")
            bluetoothdevicelist.add(device)
            //Log.e("cs",("cs","device=>"+deviceName)
        }
        val arrayAdapter = ListAdapter(this@HomeActivity,mutableListString,pairedadrslist,typelist)
        bluetoothBinding.listview.adapter = arrayAdapter
    }

    val startForResult = registerForActivityResult(
        ActivityResultContracts.StartActivityForResult()
    ) { result ->
        when(result.resultCode){
            RESULT_OK -> {
                //Log.e("cs",("cs","check for defaultin activity result")
                check_for_default()
            }
            RESULT_CANCELED -> {
                val snackbar = Snackbar
                    .make(binding.root, "BlueTooth is needed for working of the app", Snackbar.LENGTH_INDEFINITE)
                    .setAction("Ok")
                    {
                        checkforactivityresult()
                    }
                snackbar.show()
            } else -> {
            //Log.e("cs",("cs","bluetooth result in else")
        } }
    }

    public fun checkforactivityresult()
    {
        val enableBtIntent = Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE)
        if (ActivityCompat.checkSelfPermission(
                this,
                android.Manifest.permission.BLUETOOTH_CONNECT
            ) != PackageManager.PERMISSION_GRANTED
        ) {
            return
        }
        startForResult.launch(enableBtIntent)
    }







}