package com.at.isv

import android.app.Application
import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.at.isv.ApiConfig
import com.at.isv.AppConfig
import com.at.isv.ConstantValues
import com.at.isv.DataCustomer
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.IOException
import java.lang.reflect.Type
import javax.inject.Inject

@HiltViewModel
class CompletedChalamViewModel  @Inject constructor(application: Application): ViewModel() {

    private var _isLoading = MutableLiveData<Boolean>()
    val isLoading: LiveData<Boolean> = _isLoading

    private var _errormsg = MutableLiveData<String>()
    val errormsg: LiveData<String> = _errormsg

    var username:String = ""
    var password:String = ""

    private val _chalanList = MutableLiveData<ArrayList<DataList>>()
    val chalanList: LiveData<ArrayList<DataList>> = _chalanList


    var chalList = ArrayList<DataList>()

    init {
        _isLoading.value = true

        chalList.clear()
        username = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("username","").toString()
        password = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("password","").toString()

        getChalans()

    }

     fun getChalans()
    {
        viewModelScope.launch(Dispatchers.IO) {
            runCatching {
                _isLoading.postValue(true)
                _errormsg.postValue("")
                chalList.clear()
                AppConfig.retrofit.create(ApiConfig::class.java).getCompletedChalanList(username,password)
            }.onSuccess{

                val response = it?.execute()
            //    Log.e("cs","urls =>"+it?.request()?.url())
                if (response!!.isSuccessful) {
                    _isLoading.postValue(false)
                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        Log.e("cs","result =>"+js.getString("result"))
                        if(js.getString("result").equals("1"))
                        {
                            val jsonArray = js.getJSONArray("item")
                            //Log.e("cs",("cs","jsonArray =>"+jsonArray.toString())
                            val gson = Gson()
                            val type: Type = object : TypeToken<List<DataList?>?>() {}.type
                            chalList = gson.fromJson(jsonArray.toString(), type)
                            //Log.e("cs",("cs","conatactlist =>"+chalList.size)
                        }
                        else
                        {
                            _errormsg.postValue(js.getString("msg"))
                        }
                        _chalanList.postValue(chalList)

                    } catch (e: IOException) {
                        _isLoading.postValue(false)
                        _errormsg.postValue(e.message)
                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.postValue(false)
                        _errormsg.postValue(e.message)
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.postValue(false)
                    _errormsg.postValue("Please try after some time")

                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }.onFailure {
                _isLoading.postValue(false)
                _errormsg.postValue("Failure =>$it")

                //Log.e("cs",("cs", "Failure =>$it")
            }
        }
    }


}