package com.at.isv

import android.content.SharedPreferences
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import androidx.navigation.fragment.NavHostFragment
import com.at.isv.databinding.FragmentChangePasswordBinding
import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.IOException

// TODO: Rename parameter arguments, choose names that match
// the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
private const val ARG_PARAM1 = "param1"
private const val ARG_PARAM2 = "param2"

/**
 * A simple [Fragment] subclass.
 * Use the [ChangePasswordFragment.newInstance] factory method to
 * create an instance of this fragment.
 */
class ChangePasswordFragment : Fragment() {
    // TODO: Rename and change types of parameters
    private var param1: String? = null
    private var param2: String? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            param1 = it.getString(ARG_PARAM1)
            param2 = it.getString(ARG_PARAM2)
        }
    }

    private var _binding: FragmentChangePasswordBinding? = null

    // This property is only valid between onCreateView and
    // onDestroyView.
    private val binding get() = _binding!!

    var settings: SharedPreferences? = null
    var editor: SharedPreferences.Editor? = null

    var username:String = ""
    var password:String = ""

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        _binding = FragmentChangePasswordBinding.inflate(inflater, container, false)
        val root: View = binding.root

        settings = requireActivity().getSharedPreferences(ConstantValues.PREFS_NAME, 0)
        editor = settings?.edit()

        username =  settings?.getString("password","").toString()
        password =  settings?.getString("password","").toString()


        binding.btnSave.setOnClickListener {
            val c_pass = binding.etCPassword.text.toString().trim()
            val n_pass = binding.etRPassword.text.toString().trim()
            val nr_pass = binding.etNPassword.text.toString().trim()

            if(!c_pass.equals(password))
            {
                binding.etCPassword.setError("Current Password is wrong")
                binding.etCPassword.requestFocus()
                return@setOnClickListener
            }
            if(n_pass.isEmpty())
            {
                binding.etRPassword.setError("Password can't be empty")
                binding.etRPassword.requestFocus()
                return@setOnClickListener
            }

            if(!n_pass.equals(nr_pass))
            {
                binding.etNPassword.setError("New Password doesn't match")
                binding.etNPassword.requestFocus()
                return@setOnClickListener
            }

            changePassword(n_pass)
        }

        return root
    }

    public fun changePassword(new_pass:String)
    {
        binding.pb.visibility = View.VISIBLE
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.changePass(
            username,password,new_pass
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                binding.pb.visibility = View.GONE
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);

                        val jsonArray = js.getJSONArray("item")
                        for (i in 0 until jsonArray.length()) {
                            val jsonObject = jsonArray.getJSONObject(i)
                            val result123 = jsonObject.getString("result")

                            //Log.e("cs",("cs", "result123=>$result123")
                            if ((result123 == "1")) {
                                Toast.makeText(requireContext(),"Password changed Successfully",
                                    Toast.LENGTH_LONG).show()
                                NavHostFragment.findNavController(this@ChangePasswordFragment).popBackStack()
                            } else {
                                Toast.makeText(requireContext(),"Password changed Failed", Toast.LENGTH_LONG).show()
                            }
                        }
                    } catch (e: IOException) {
                        binding.pb.visibility = View.GONE
                        Toast.makeText(requireContext(),"Password changed Failed IO Exception",
                            Toast.LENGTH_LONG).show()
                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        binding.pb.visibility = View.GONE
                        Toast.makeText(requireContext(),"Password changed Failed JSON Exception",
                            Toast.LENGTH_LONG).show()
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    binding.pb.visibility = View.GONE
                    Toast.makeText(requireContext(),"Password changed Failed , response failed",
                        Toast.LENGTH_LONG).show()
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                binding.pb.visibility = View.GONE
                Toast.makeText(requireContext(),"Password changed Failed, ${t.message}", Toast.LENGTH_LONG).show()
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

    companion object {
        /**
         * Use this factory method to create a new instance of
         * this fragment using the provided parameters.
         *
         * @param param1 Parameter 1.
         * @param param2 Parameter 2.
         * @return A new instance of fragment ChangePasswordFragment.
         */
        // TODO: Rename and change types and number of parameters
        @JvmStatic
        fun newInstance(param1: String, param2: String) =
            ChangePasswordFragment().apply {
                arguments = Bundle().apply {
                    putString(ARG_PARAM1, param1)
                    putString(ARG_PARAM2, param2)
                }
            }
    }
}