package com.at.isv

import okhttp3.MultipartBody
import okhttp3.RequestBody
import okhttp3.ResponseBody
import retrofit2.Call
import retrofit2.http.*

interface ApiConfig {
    /* @Multipart
    @POST("studentadd.php")
    Call<ResponseBody> uploadFile(@Part MultipartBody.Part image
            , @Part("mobile") RequestBody mobile, @Part("password") RequestBody password
            , @Part("studentname") RequestBody studentname, @Part("stumobile") RequestBody conno, @Part("gender") RequestBody gender
            , @Part("dob") RequestBody birthdate, @Part("p7") RequestBody regdate
            , @Part("email") RequestBody email, @Part("villageid") RequestBody villageid
            , @Part("aadhar") RequestBody aadhar, @Part(value = "address",encoding = "UTF-8") RequestBody address
            , @Part("schoolcate") RequestBody schoolcate,@Part("schoolid") RequestBody schoolid,@Part("redinglevel") RequestBody redinglevel
            ,@Part("fathercont") RequestBody fathercont
            ,@Part("parentinc") RequestBody parentinc
            ,@Part("parentoccu") RequestBody parentoccu);
*/

    //updating apis because of password encryption and token

    @GET("loginv3.php")
    fun login(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("device_id") device_id: String?,
        @Query("security_token") security_token: String?
    ): Call<ResponseBody?>?

    @GET("autologin.php")
    fun loginQR(
        @Query("key") key: String?,
        @Query("device_id") device_id: String?
    ): Call<ResponseBody?>?


    @GET("customerlistV2.php")
    fun getCustomerList(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?
    ): Call<ResponseBody?>?

    @GET("vehiclelistV2.php")
    fun getVehicleList(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?
    ): Call<ResponseBody?>?

    @GET("itemlistV2.php")
    fun getItemList(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?
    ): Call<ResponseBody?>?


    @GET("challanlistinprocessV2.php")
     fun getPendingChalanList(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?
    ): Call<ResponseBody?>?

    @GET("challanlistcompletedV2.php")
    fun getCompletedChalanList(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?
    ): Call<ResponseBody?>?

   // @GET("challanlistFilteredV1.php")
    @GET("challanlistFilteredV3.php")
    fun getFilteredChalanList(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("fromDate") fromDate: String?,
        @Query("toDate") toDate: String?,
        @Query("ClientID") ClientID: String?,
        @Query("VehicleID") VehicleID: String?,
        @Query("ItemId") ItemId: String?
    ): Call<ResponseBody?>?

    @GET("challandetailV3.php")
    fun getdetails(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("chalanmid") chalanmid: String?
    ): Call<ResponseBody?>?

    @GET("getchallandetailResumeV2.php")
    fun getchallandetailResume(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("chalanmid") chalanmid: String?
    ): Call<ResponseBody?>?

    @GET("addladenweightV3.php")
    fun addladenweight(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("tocompanymid") tocompanymid: String?,
        @Query("vehiclenumber") vehiclenumber: String?,
        @Query("ladenweight") ladenweight: String?,
        @Query("challanmid") challanmid: String?,
        @Query("dod") dod: String?,
        @Query("remarks") remarks: String?
    ): Call<ResponseBody?>?

    @GET("challanitemaddV2.php")
    fun addChalanItem(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("orderdrandomid") orderdrandomid: String?,
        @Query("challanmid") challanmid: String?,
        @Query("itemmid") itemmid: String?,
        @Query("tocompanymid") tocompanymid: String?,
        @Query("vehiclenumber") vehiclenumber: String?,
        @Query("vehicletareweight") vehicletareweight: String?,
        @Query("vehiclegrossweight") vehiclegrossweight: String?,
        @Query("vehiclenetweight") vehiclenetweight: String?,
        @Query("itemrate") itemrate: String?,
        @Query("totalitemprice") totalitemprice: String?,
        @Query("challantype") challantype: String?,
        @Query("challanweighttype") challanweighttype: String?,
        @Query("itemdeduction") itemdeduction: String?
    ): Call<ResponseBody?>?

    @GET("getchalanitemsV2.php")
    fun getChalanItems(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("challanmid") challanmid: String?
    ): Call<ResponseBody?>?

    @GET("cancelChalanV2.php")
    fun cancelChalan(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("challanmid") challanmid: String?
    ): Call<ResponseBody?>?

    @GET("challansaveV4.php")
    fun addChalan(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("challanmid") challanmid: String?,
        @Query("remarks") remarks: String?,
        @Query("dod") dod: String?,
        @Query("security_token") security_token: String?
    ): Call<ResponseBody?>?

    @GET("removeItemV3.php")
    fun removeItem(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("challandmid") challandmid: String?
    ): Call<ResponseBody?>?

    @GET("getImgsV1.php")
    fun getImgs(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("challandmid") challandmid: String?
    ): Call<ResponseBody?>?

    @Multipart
    @POST("challansaveV1.php")
    fun addChalanwithImgs(
        @Part image: List<MultipartBody.Part?>?,
        @Part("mobile") mobile: RequestBody?,
        @Part("password") password: RequestBody?,
        @Part("challanmid") challanmid: RequestBody?,
        @Part("dod1") dod1: RequestBody?
    ): Call<ResponseBody?>?


    @Multipart
    @POST("uploadPicV2.php")
    fun uploadPic(
        @Part image: List<MultipartBody.Part?>?,
        @Part("mobile") mobile: RequestBody?,
        @Part("password") password: RequestBody?,
        @Part("challanmid") challanmid: RequestBody?
    ): Call<ResponseBody?>?

    @GET("editChalanV2.php")
    fun editChalan(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("challanmid") challanmid: String?
    ): Call<ResponseBody?>?

    @GET("addCustomerV2.php")
    fun addCustomer(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("cname") cname: String?,
        @Query("cadrs") cadrs: String?,
        @Query("cpname") cpname: String?,
        @Query("cpno") cpno: String?
    ): Call<ResponseBody?>?


    @GET("updateSettingsV3.php")
    fun updateSettings(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("bdscale_name") bdscale_name: String?,
        @Query("bdscale_mac") bdscale_mac: String?,
        @Query("bdprint_name") bdprint_name: String?,
        @Query("bdprint_mac") bdprint_mac: String?,
        @Query("showDeleteChalanItems") showDeleteChalanItems: String?,
        @Query("ShowEditPrices") ShowEditPrices: String?,
        @Query("ShowManualWeightEdit") ShowManualWeightEdit: String?,
        @Query("showChalanPitures") showChalanPitures: String?,
        @Query("showItemAllowed") showItemAllowed: String?,
        @Query("showEditCompletedChalan") showEditCompletedChalan: String?,
        @Query("showReprintChalan") showReprintChalan: String?,
        @Query("ShowReport") ShowReport: String?
    ): Call<ResponseBody?>?



    @GET("changepasswordV2.php")
    fun changePass(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("new_password") newpassword: String?
    ): Call<ResponseBody?>?

    @GET("checkSettingsPasswordV2.php")
    fun CheckSettingsPassword(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("setpassword") setpassword: String?
    ): Call<ResponseBody?>?

    @GET("saveChalanV1.php")
    fun savechalan(
        @Query("mobile") mobile: String?,
        @Query("password") password: String?,
        @Query("challanmid") challanmid: String?,
        @Query("dod") dod: String?,
        @Query("remarks") remarks: String?
    ): Call<ResponseBody?>?


}