package com.at.isv

import android.app.Application
import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import dagger.hilt.android.lifecycle.HiltViewModel
import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.IOException
import javax.inject.Inject

@HiltViewModel
class AddCustomerViewModel @Inject constructor(application: Application) : ViewModel() {
    var username:String = ""
    var password:String = ""
    private var _isLoading = MutableLiveData<Boolean>()
    val isLoading: LiveData<Boolean> = _isLoading

    private var _errormsg = MutableLiveData<String>()
    val errormsg: LiveData<String> = _errormsg

    private var _customerAdd = MutableLiveData<Boolean>()
    val customerAdd: LiveData<Boolean> = _customerAdd

    init {

        username = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("username","").toString()
        password = application.getSharedPreferences(ConstantValues.PREFS_NAME, 0).getString("password","").toString()

    }

    fun addCustomer(cname:String,cadrs:String,cpname:String,cpno:String)
    {

        _isLoading.value = true
        _errormsg.value = ""
        _customerAdd.value = false
        val getResponse = AppConfig.retrofit.create(ApiConfig::class.java)
        val call222 = getResponse.addCustomer(
            username,password,cname,cadrs,cpname,cpno
        )

        //Log.e("cs",("cs","uel =>"+call222!!.request().url())

        call222!!.enqueue(object : Callback<ResponseBody?> {
            override fun onResponse(
                call: Call<ResponseBody?>,
                response: Response<ResponseBody?>
            ) {
                _isLoading.value = false
                if (response.isSuccessful) {

                    try {
                        val result = response.body()?.string()
                        val js = JSONObject(result!!);
                        if(js.getString("result").equals("1"))
                        {
                            _customerAdd.value = true
                        }
                        else
                        {
                            _errormsg.value = js.getString("msg")
                        }
                    } catch (e: IOException) {
                        _isLoading.value = false

                        e.printStackTrace()
                        // editor?.remove("audio_filepath")?.apply();
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    } catch (e: JSONException) {
                        _isLoading.value = false
                        e.printStackTrace()
                        //Log.e("cs",("cs", "exception 111=>" + e.message)
                    }
                } else {
                    _isLoading.value = false
                    _errormsg.value = "Please try after some time"
                    // editor?.remove("audio_filepath")?.apply();
                    //Log.e("cs",("cs", "exception 222=>+response failed")
                }
            }
            override fun onFailure(call: Call<ResponseBody?>, t: Throwable) {
                _isLoading.value = false
                _errormsg.value = "Getting Data Failed ${t.cause}"
                //editor?.remove("audio_filepath")?.apply();
                //Log.e("cs",("cs", "exception 333=>$t")
            }
        })
    }

}