package com.at.isv

import android.content.Intent
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import androidx.lifecycle.ViewModelProvider
import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.widget.Toast
import androidx.fragment.app.DialogFragment
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import androidx.navigation.Navigation
import androidx.navigation.fragment.NavHostFragment
import com.at.isv.databinding.FragmentAddCustomerBinding
import com.at.isv.databinding.FragmentPendingChalanBinding
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class AddCustomerFragment : DialogFragment() {

    companion object {
        fun newInstance() = AddCustomerFragment()
    }

    private lateinit var viewModel: AddCustomerViewModel
    private var _binding: FragmentAddCustomerBinding? = null

    // This property is only valid between onCreateView and
    // onDestroyView.
    private val binding get() = _binding!!
    var viewClicked : View? = null
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        _binding = FragmentAddCustomerBinding.inflate(inflater, container, false)
        val root: View = binding.root
        viewModel = ViewModelProvider(this).get(AddCustomerViewModel::class.java)

        dialog!!.getWindow()!!.setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);


        dialog!!.getWindow()!!.setClipToOutline(true)
        dialog!!.setCanceledOnTouchOutside(false)

        viewModel.isLoading.observe(viewLifecycleOwner)
        {
            if(it) {
                binding.pb.visibility = View.VISIBLE
                viewClicked?.isEnabled = false
                requireActivity().window.setFlags(
                    WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE,
                    WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE)
            }
            else {
                viewClicked?.isEnabled = true
                requireActivity().window.clearFlags(WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE)
                binding.pb.visibility = View.GONE
            }
        }
        viewModel.errormsg.observe(viewLifecycleOwner)
        {
            if(it.isNotEmpty())
                Toast.makeText(requireContext(),it, Toast.LENGTH_SHORT).show()
        }

        binding.btnCancel.setSafeOnClickListener {
            //Navigation.findNavController(it).popBackStack()
            dismiss()
        }

        binding.btnAddCustomer.setSafeOnClickListener {
            val cname = binding.etCustomerName.text.toString().trim()
            val cadrs = binding.etCustomerAddress.text.toString().trim()
            val cpname = binding.etCustomerCP.text.toString().trim()
            val cpno = binding.etCustomerCM.text.toString().trim()

            if(cname.isEmpty())
            {
                binding.etCustomerName.error = "Please Enter Customer Name"
                binding.etCustomerName.requestFocus()
                return@setSafeOnClickListener
            }

           /* if(cadrs.isEmpty())
            {
                binding.etCustomerAddress.error = "Please Enter Customer Adderess"
                binding.etCustomerAddress.requestFocus()
                return@setSafeOnClickListener
            }

            if(cpname.isEmpty())
            {
                binding.etCustomerCP.error = "Please Enter Contact Person Name"
                binding.etCustomerCP.requestFocus()
                return@setSafeOnClickListener
            }

            if(cpno.isEmpty())
            {
                binding.etCustomerCM.error = "Please Enter Valid Mobile No"
                binding.etCustomerCM.requestFocus()
                return@setSafeOnClickListener
            }*/

            viewModel.addCustomer(cname,cadrs,cpname,cpno)

        }

        viewModel.customerAdd.observe(viewLifecycleOwner){
            if(it)
            {
                Toast.makeText(requireContext(),"Customer Added", Toast.LENGTH_SHORT).show()
               //NavHostFragment.findNavController(this@AddCustomerFragment).popBackStack()
                LocalBroadcastManager.getInstance(requireContext()).sendBroadcast(Intent("CustomerLoad"))
                dismiss()
            }
        }

        return root
    }

    fun View.setSafeOnClickListener(onSafeClick: (View) -> Unit) {
        val safeClickListener = SafeClickListener {
            viewClicked = it
            onSafeClick(it)
        }
        setOnClickListener(safeClickListener)
    }

}