package com.at.isv

import android.app.Activity
import android.app.Dialog
import android.app.ProgressDialog
import android.content.Context
import android.content.DialogInterface
import android.content.Intent
import android.content.SharedPreferences
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.*
import androidx.appcompat.app.AlertDialog
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import androidx.navigation.Navigation
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.at.isv.databinding.SublayoutForListBinding
import com.at.isv.databinding.SublayoutForListItemBinding
import com.at.isv.databinding.SublayoutForListReportBinding

import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.IOException
import java.io.Serializable
import java.math.RoundingMode
import java.text.DecimalFormat
import java.util.*
import kotlin.collections.ArrayList

class AdapterForReportSub(getDataAdapter: ArrayList<DataReportSub>, context: Context, a: Activity) :
    RecyclerView.Adapter<AdapterForReportSub.ViewHolder?>(), Filterable {
    var context: Context
    var activity: Activity
    var cat: String? = null
    var getDataAdapter: ArrayList<DataReportSub>
    var mFilteredList: ArrayList<DataReportSub>
    var type: String? = null
    lateinit var dialog: Dialog
    lateinit var alert: AlertDialog
    var selectedPosition = -1;

    init {
        this.getDataAdapter = getDataAdapter
        this.context = context
        activity = a
        mFilteredList = getDataAdapter
        this.type = type
    }

    inner class ViewHolder(val binding: SublayoutForListReportBinding) : RecyclerView.ViewHolder(binding.root){
        var currentWeight:Int = 0
    }


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val binding = SublayoutForListReportBinding.inflate(LayoutInflater.from(parent.context), parent, false)

        return ViewHolder(binding)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        with(holder){
            with(mFilteredList[position]){

                binding.tvitemname.text = this.name
                binding.tvSaleQty.text = this.saleweight + " kg"
                binding.tvSalePrice.text = this.salePrice
                binding.tvPurchaseQty.text = this.purchaseweight + " kg"
                binding.tvPurchasePrice.text = this.purchasePrice

                try {
                    var totalweight = this.saleweight.toDouble() + this.purchaseweight.toDouble()
                    var totalPrice = this.salePrice.toDouble() + this.purchasePrice.toDouble()

                    val df = DecimalFormat("#.##")
                    df.roundingMode = RoundingMode.CEILING
                    totalPrice =  df.format(totalPrice).toDouble()
                    totalweight =  df.format(totalweight).toDouble()
                    binding.tvTotalQty.text = totalweight.toString() + " kg"
                    binding.tvTotalPrice.text = totalPrice.toString()
                }
                catch (e:NumberFormatException)
                {

                }

             //   binding.tvItemWeight.text = this.vnetweight
               // binding.tvType.text = this.challantype
               // binding.tvTotal.text = this.vehprice



            }
        }
    }

    public fun setselection(selectedPos : Int){
        selectedPosition = selectedPos
        notifyDataSetChanged()
    }

    override fun getItemCount(): Int {
        return mFilteredList.size
    }



    override fun getFilter(): Filter {
        return object : Filter() {
            override fun performFiltering(charSequence: CharSequence): FilterResults {
                val charString = charSequence.toString().lowercase(Locale.getDefault())
                //Log.e("cs",("cs charString ", charString)
                mFilteredList = if (charString.isEmpty()) {
                    getDataAdapter
                } else {

                    //mFilteredList = getDataAdapter;
                    val filteredList: ArrayList<DataReportSub> = ArrayList<DataReportSub>()
                    for (androidVersion in getDataAdapter) {
                        if (androidVersion.name!!.toLowerCase().contains(charString)) {
                            filteredList.add(androidVersion)
                        }
                    }
                    filteredList

                    //  notifyDataSetChanged();
                }
                val filterResults = FilterResults()
                filterResults.values = mFilteredList
                return filterResults
            }

            override fun publishResults(charSequence: CharSequence, filterResults: FilterResults) {
                mFilteredList = filterResults.values as ArrayList<DataReportSub>
                notifyDataSetChanged()
            }
        }
    }



    companion object {
        const val PREFS_NAME = "Preference"

    }

    fun removeAt(position: Int) {
        mFilteredList.removeAt(position)
        notifyItemRemoved(position)
        notifyItemRangeChanged(position, mFilteredList.size)
    }

}