package com.at.isv

import android.app.Activity
import android.app.Dialog
import android.app.ProgressDialog
import android.content.Context
import android.content.DialogInterface
import android.content.Intent
import android.content.SharedPreferences
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.*
import androidx.appcompat.app.AlertDialog
import androidx.core.view.isVisible
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import androidx.navigation.Navigation
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.at.isv.databinding.SublayoutForListBinding
import com.at.isv.databinding.SublayoutForReportBinding

import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.IOException
import java.io.Serializable
import java.util.*
import kotlin.collections.ArrayList

class AdapterForReport(getDataAdapter: ArrayList<DataReport>, context: Context, a: Activity) :
    RecyclerView.Adapter<AdapterForReport.ViewHolder?>(), Filterable {
    var context: Context
    var activity: Activity
    var cat: String? = null
    var getDataAdapter: ArrayList<DataReport>
    var mFilteredList: ArrayList<DataReport>
    var type: String? = null
    lateinit var dialog: Dialog
    lateinit var alert: AlertDialog
    var selectedPosition = -1;

    init {
        this.getDataAdapter = getDataAdapter
        this.context = context
        activity = a
        mFilteredList = getDataAdapter
        this.type = type
    }

    inner class ViewHolder(val binding: SublayoutForReportBinding) : RecyclerView.ViewHolder(binding.root){
        var currentWeight:Int = 0
    }


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val binding = SublayoutForReportBinding.inflate(LayoutInflater.from(parent.context), parent, false)

        return ViewHolder(binding)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        with(holder){
            with(mFilteredList[position]){

                //Log.e("cs",("cs","123 111 =>"+"Total Challans :: ${this.chalanArr.size}")

               binding.tvChalan.text = "Total Jobs :: ${this.chalanArr.size}"
               binding.tvCustomer.text = "Total Customers :: ${this.custArr.size}"
               binding.tvVehicle.text = "Total Vehicles :: ${this.vehiArr.size}"
               binding.tvItem.text = "Total Items :: ${this.itemArr.size}"

                //Log.e("cs",("cs","123 123 =>"+"Total Challans :: ${this.chalanArr.size}")

                binding.recyclerviewChalan.layoutManager = LinearLayoutManager(context,RecyclerView.VERTICAL,false)
                binding.recyclerviewChalan.adapter = AdapterForFilteredList(this.chalanArr,context,activity)

                binding.recyclerviewCust.layoutManager = LinearLayoutManager(context,RecyclerView.VERTICAL,false)
                binding.recyclerviewCust.adapter = AdapterForReportSub(this.custArr,context,activity)

                binding.recyclerviewVehicle.layoutManager = LinearLayoutManager(context,RecyclerView.VERTICAL,false)
                binding.recyclerviewVehicle.adapter = AdapterForReportSub(this.vehiArr,context,activity)

                binding.recyclerviewItem.layoutManager = LinearLayoutManager(context,RecyclerView.VERTICAL,false)
                binding.recyclerviewItem.adapter = AdapterForReportSub(this.itemArr,context,activity)

                binding.tvChalan.setOnClickListener {
                    if(binding.recyclerviewChalan.isVisible)
                        binding.recyclerviewChalan.visibility = View.GONE
                    else
                        binding.recyclerviewChalan.visibility = View.VISIBLE
                }

                binding.tvCustomer.setOnClickListener {
                    if(binding.recyclerviewCust.isVisible)
                        binding.recyclerviewCust.visibility = View.GONE
                    else
                        binding.recyclerviewCust.visibility = View.VISIBLE
                }

                binding.tvVehicle.setOnClickListener {
                    if(binding.recyclerviewVehicle.isVisible)
                        binding.recyclerviewVehicle.visibility = View.GONE
                    else
                        binding.recyclerviewVehicle.visibility = View.VISIBLE
                }

                binding.tvItem.setOnClickListener {
                    if(binding.recyclerviewItem.isVisible)
                        binding.recyclerviewItem.visibility = View.GONE
                    else
                        binding.recyclerviewItem.visibility = View.VISIBLE
                }

            }
        }
    }

    public fun setselection(selectedPos : Int){
        selectedPosition = selectedPos
        notifyDataSetChanged()
    }

    override fun getItemCount(): Int {
        return mFilteredList.size
    }

    fun getcurrentlist() : ArrayList<DataReport>
    {
        return mFilteredList
    }

    override fun getFilter(): Filter {
        return object : Filter() {
            override fun performFiltering(charSequence: CharSequence): FilterResults {
                val charString = charSequence.toString().lowercase(Locale.getDefault())
                //Log.e("cs",("cs charString ", charString)
                mFilteredList = if (charString.isEmpty()) {
                    getDataAdapter
                } else {

                    //mFilteredList = getDataAdapter;
                    val filteredList: ArrayList<DataReport> = ArrayList<DataReport>()
                    for (androidVersion in getDataAdapter) {
                        if (androidVersion.chalanArr.get(0).challannumber!!.toLowerCase().contains(charString)) {
                            filteredList.add(androidVersion)
                        }
                    }
                    filteredList

                    //  notifyDataSetChanged();
                }
                val filterResults = FilterResults()
                filterResults.values = mFilteredList
                return filterResults
            }

            override fun publishResults(charSequence: CharSequence, filterResults: FilterResults) {
                mFilteredList = filterResults.values as ArrayList<DataReport>
                notifyDataSetChanged()
            }
        }
    }



    companion object {
        const val PREFS_NAME = "Preference"

    }

    fun removeAt(position: Int) {
        mFilteredList.removeAt(position)
        notifyItemRemoved(position)
        notifyItemRangeChanged(position, mFilteredList.size)
    }

}