package com.at.isv

import android.app.Activity
import android.app.Dialog
import android.app.ProgressDialog
import android.content.Context
import android.content.DialogInterface
import android.content.Intent
import android.content.SharedPreferences
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.*
import androidx.appcompat.app.AlertDialog
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import androidx.navigation.Navigation
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.at.isv.databinding.SublayoutForListBinding

import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.IOException
import java.io.Serializable
import java.util.*
import kotlin.collections.ArrayList

class AdapterForList(getDataAdapter: ArrayList<DataList>, context: Context, a: Activity) :
    RecyclerView.Adapter<AdapterForList.ViewHolder?>(), Filterable {
    var context: Context
    var activity: Activity
    var cat: String? = null
    var getDataAdapter: ArrayList<DataList>
    var mFilteredList: ArrayList<DataList>
    var type: String? = null
    lateinit var dialog: Dialog
    lateinit var alert: AlertDialog
    var selectedPosition = -1;

    init {
        this.getDataAdapter = getDataAdapter
        this.context = context
        activity = a
        mFilteredList = getDataAdapter
        this.type = type
    }

    inner class ViewHolder(val binding: SublayoutForListBinding) : RecyclerView.ViewHolder(binding.root){
        var currentWeight:Int = 0
    }


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val binding = SublayoutForListBinding.inflate(LayoutInflater.from(parent.context), parent, false)

        return ViewHolder(binding)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        with(holder){
            with(mFilteredList[position]){

                binding.tvtno.text = this.nofordisplay
                binding.tvdate.text = this.challandate
                binding.tvcompany.text = this.partyname
                binding.tvtype.text = this.type
                binding.tvweight.text = this.totalweight
                binding.tvPrice.text = this.totaliprice
                binding.tvVehicle.text = this.vehiclenumber

                if(this.status.equals("Completed"))
                    binding.vbg.background = activity.getDrawable(R.drawable.edittextborder4)
                else
                    binding.vbg.background = activity.getDrawable(R.drawable.edittextborder5)


                binding.llmain.setOnClickListener {

                    val bdscale_mac = activity.getSharedPreferences(PREFS_NAME,0).getString("bdscale_mac","").toString()
                    val bdprint_mac = activity.getSharedPreferences(PREFS_NAME,0).getString("bdprint_mac","").toString()
                    if(bdscale_mac.isEmpty() || bdprint_mac.isEmpty())
                    {
                        Toast.makeText(context,"Please ask Admin to assign the Scale and Print OR if you have settings Password then select the devices from it.",Toast.LENGTH_LONG).show()
                        return@setOnClickListener
                    }
                    activity.getSharedPreferences(PREFS_NAME,0).edit().putString("chalanmid",this.challanmid).apply()
                    if(this.status.equals("Completed"))
                    {
                        Navigation.findNavController(it).navigate(R.id.nav_gallery)
                    }
                    else
                    {
                        Navigation.findNavController(it).navigate(R.id.nav_slideshow)
                    }
                }
            }
        }
    }

    public fun setselection(selectedPos : Int){
        selectedPosition = selectedPos
        notifyDataSetChanged()
    }

    override fun getItemCount(): Int {
        return mFilteredList.size
    }

    fun getcurrentlist() : ArrayList<DataList>
    {
        return mFilteredList
    }

    override fun getFilter(): Filter {
        return object : Filter() {
            override fun performFiltering(charSequence: CharSequence): FilterResults {
                val charString = charSequence.toString().lowercase(Locale.getDefault())
                //Log.e("cs",("cs charString ", charString)
                mFilteredList = if (charString.isEmpty()) {
                    getDataAdapter
                } else {

                    //mFilteredList = getDataAdapter;
                    val filteredList: ArrayList<DataList> = ArrayList<DataList>()
                    for (androidVersion in getDataAdapter) {
                        if (androidVersion.challannumber!!.toLowerCase().contains(charString)) {
                            filteredList.add(androidVersion)
                        }
                    }
                    filteredList

                    //  notifyDataSetChanged();
                }
                val filterResults = FilterResults()
                filterResults.values = mFilteredList
                return filterResults
            }

            override fun publishResults(charSequence: CharSequence, filterResults: FilterResults) {
                mFilteredList = filterResults.values as ArrayList<DataList>
                notifyDataSetChanged()
            }
        }
    }



    companion object {
        const val PREFS_NAME = "Preference"

    }

    fun removeAt(position: Int) {
        mFilteredList.removeAt(position)
        notifyItemRemoved(position)
        notifyItemRangeChanged(position, mFilteredList.size)
    }

}