package com.at.isv

import android.app.Activity
import android.app.Dialog
import android.content.Context
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.*
import androidx.appcompat.app.AlertDialog
import androidx.recyclerview.widget.RecyclerView
import com.at.isv.databinding.SublayoutForBizImgBinding
import com.at.isv.databinding.SublayoutForListItemBinding
import com.bumptech.glide.Glide
import java.util.*

class AdapterForItemImages(getDataAdapter: ArrayList<DataItemImage>, context: Context, a: Activity) :
    RecyclerView.Adapter<AdapterForItemImages.ViewHolder?>(), Filterable {
    var context: Context
    var activity: Activity
    var cat: String? = null
    var getDataAdapter: ArrayList<DataItemImage>
    var mFilteredList: ArrayList<DataItemImage>
    var type: String? = null
    lateinit var dialog: Dialog
    lateinit var alert: AlertDialog
    var selectedPosition = -1;

    init {
        this.getDataAdapter = getDataAdapter
        this.context = context
        activity = a
        mFilteredList = getDataAdapter
        this.type = type
    }

    inner class ViewHolder(val binding: SublayoutForBizImgBinding) : RecyclerView.ViewHolder(binding.root){
        var currentWeight:Int = 0
    }


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val binding = SublayoutForBizImgBinding.inflate(LayoutInflater.from(parent.context), parent, false)

        return ViewHolder(binding)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        with(holder){
            with(mFilteredList[position]){

                //   holder.faqque.setText(getDataAdapter1.getHalltypeicon());

                Glide.with(context).load(this.challanimagename).error(R.drawable.ic_broken_image)
                    .into(binding.ivimg)

               /* if(this.cidid.equals("0"))
                    binding.ivdelete.visibility = View.VISIBLE
                else
                    binding.ivdelete.visibility = View.GONE*/

                binding.ivdelete.setOnClickListener(View.OnClickListener {
                    val pos = position
                    val alertDialogBuilder = AlertDialog.Builder(activity, R.style.AlertDialogTheme)
                    alertDialogBuilder.setMessage("Are you sure, You want to delete this Image?")
                    alertDialogBuilder.setPositiveButton(
                        "yes"
                    ) { arg0, arg1 -> removeAt(pos) }
                    alertDialogBuilder.setNegativeButton(
                        "No"
                    ) { dialog, which -> dialog.dismiss() }
                    val alertDialog = alertDialogBuilder.create()
                    alertDialog.show()
                })

            }
        }
    }

    public fun setselection(selectedPos : Int){
        selectedPosition = selectedPos
        notifyDataSetChanged()
    }

    override fun getItemCount(): Int {
        return mFilteredList.size
    }



    override fun getFilter(): Filter {
        return object : Filter() {
            override fun performFiltering(charSequence: CharSequence): FilterResults {
                val charString = charSequence.toString().lowercase(Locale.getDefault())
                //Log.e("cs",("cs charString ", charString)
                mFilteredList = if (charString.isEmpty()) {
                    getDataAdapter
                } else {

                    //mFilteredList = getDataAdapter;
                    val filteredList: ArrayList<DataItemImage> = ArrayList<DataItemImage>()
                    for (androidVersion in getDataAdapter) {
                        if (androidVersion.cidid!!.toLowerCase().contains(charString)) {
                            filteredList.add(androidVersion)
                        }
                    }
                    filteredList

                    //  notifyDataSetChanged();
                }
                val filterResults = FilterResults()
                filterResults.values = mFilteredList
                return filterResults
            }

            override fun publishResults(charSequence: CharSequence, filterResults: FilterResults) {
                mFilteredList = filterResults.values as ArrayList<DataItemImage>
                notifyDataSetChanged()
            }
        }
    }



    companion object {
        const val PREFS_NAME = "Preference"

    }

    fun removeAt(position: Int) {
        mFilteredList.removeAt(position)
        notifyItemRemoved(position)
        notifyItemRangeChanged(position, mFilteredList.size)
    }

}