package com.at.isv

import android.app.Activity
import android.app.Dialog
import android.app.ProgressDialog
import android.content.Context
import android.content.DialogInterface
import android.content.Intent
import android.content.SharedPreferences
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.*
import androidx.appcompat.app.AlertDialog
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import androidx.navigation.Navigation
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.at.isv.databinding.SublayoutForListBinding
import com.at.isv.databinding.SublayoutForListItemBinding

import okhttp3.ResponseBody
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import java.io.IOException
import java.io.Serializable
import java.util.*
import kotlin.collections.ArrayList

class AdapterForItem(getDataAdapter: ArrayList<ItemData>, context: Context, a: Activity, showDelete:Boolean, showPrice:Boolean) :
    RecyclerView.Adapter<AdapterForItem.ViewHolder?>(), Filterable {
    var context: Context
    var activity: Activity
    var cat: String? = null
    var getDataAdapter: ArrayList<ItemData>
    var mFilteredList: ArrayList<ItemData>
    var type: String? = null
    lateinit var dialog: Dialog
    lateinit var alert: AlertDialog
    var selectedPosition = -1;
    var showDelete:Boolean
    var showPrice:Boolean

    init {
        this.getDataAdapter = getDataAdapter
        this.context = context
        activity = a
        mFilteredList = getDataAdapter
        this.type = type
        this.showDelete = showDelete
        this.showPrice = showPrice
    }

    inner class ViewHolder(val binding: SublayoutForListItemBinding) : RecyclerView.ViewHolder(binding.root){
        var currentWeight:Int = 0
    }


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val binding = SublayoutForListItemBinding.inflate(LayoutInflater.from(parent.context), parent, false)

        return ViewHolder(binding)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        with(holder){
            with(mFilteredList[position]){

                binding.tvitemname.text = this.itemname
                binding.tvItemWeight.text = this.itemweight
                binding.tvItemRate.text = this.itemrate
                binding.tvTotal.text = this.itemprice

                if(showDelete)
                    binding.ivDelete.visibility = View.VISIBLE
                else
                    binding.ivDelete.visibility = View.GONE

                if(showPrice)
                    binding.llPrice3.visibility = View.VISIBLE
                else
                    binding.llPrice3.visibility = View.GONE
                if(this.chalandetailtype.equals("Sale"))
                    binding.vbg.background = activity.getDrawable(R.drawable.edittextborder7)
                else
                    binding.vbg.background = activity.getDrawable(R.drawable.edittextborder6)

                binding.ivDelete.setOnClickListener {
                    val builder = AlertDialog.Builder(context)
                    builder.setTitle("Remove Item ?")
                    builder.setMessage("Are you sure you want to remove this item from job ?")
//builder.setPositiveButton("OK", DialogInterface.OnClickListener(function = x))

                    builder.setPositiveButton(android.R.string.yes) { dialog, which ->
                        val removeItem = Intent("removeItem")
                        removeItem.putExtra("itmeid",this.chalanDetailID)
                        LocalBroadcastManager.getInstance(context).sendBroadcast(removeItem)
                    }

                    builder.setNegativeButton(android.R.string.no) { dialog, which ->
                        dialog.dismiss()
                    }


                    builder.show()
                }

            }
        }
    }

    public fun setselection(selectedPos : Int){
        selectedPosition = selectedPos
        notifyDataSetChanged()
    }

    override fun getItemCount(): Int {
        return mFilteredList.size
    }



    override fun getFilter(): Filter {
        return object : Filter() {
            override fun performFiltering(charSequence: CharSequence): FilterResults {
                val charString = charSequence.toString().lowercase(Locale.getDefault())
                //Log.e("cs",("cs charString ", charString)
                mFilteredList = if (charString.isEmpty()) {
                    getDataAdapter
                } else {

                    //mFilteredList = getDataAdapter;
                    val filteredList: ArrayList<ItemData> = ArrayList<ItemData>()
                    for (androidVersion in getDataAdapter) {
                        if (androidVersion.itemname!!.toLowerCase().contains(charString)) {
                            filteredList.add(androidVersion)
                        }
                    }
                    filteredList

                    //  notifyDataSetChanged();
                }
                val filterResults = FilterResults()
                filterResults.values = mFilteredList
                return filterResults
            }

            override fun publishResults(charSequence: CharSequence, filterResults: FilterResults) {
                mFilteredList = filterResults.values as ArrayList<ItemData>
                notifyDataSetChanged()
            }
        }
    }



    companion object {
        const val PREFS_NAME = "Preference"

    }

    fun removeAt(position: Int) {
        mFilteredList.removeAt(position)
        notifyItemRemoved(position)
        notifyItemRangeChanged(position, mFilteredList.size)
    }

}